/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator;

import java.util.Collection;
import org.eclipse.sirius.diagram.sequence.business.api.util.Range;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractFrame;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InteractionUse;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator.AbstractInteractionFrameValidator;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.util.RequestQuery;

public class InteractionUseResizeValidator
extends AbstractInteractionFrameValidator {
    protected InteractionUseResizeValidator(InteractionUse interactionUse, RequestQuery requestQuery) {
        super((AbstractFrame)interactionUse, requestQuery);
        this.defaultFrameHeight = 50;
    }

    @Override
    protected void validate() {
        if (!this.getRequestQuery().isResizeFromTop() && !this.getRequestQuery().isResizeFromBottom()) {
            this.valid = false;
        } else {
            super.validate();
        }
    }

    @Override
    protected Collection<ISequenceEvent> getFinalParents(Collection<Lifeline> coveredLifelines) {
        return this.frame.computeParentEvents();
    }

    @Override
    protected boolean canExpand() {
        return true;
    }

    @Override
    protected Range computeExpansionZone() {
        Range expansionZone = Range.emptyRange();
        if (this.getRequestQuery().isResizeFromBottom() && this.getRequestQuery().getLogicalDelta().height > 0) {
            expansionZone = new Range(this.initialRange.getUpperBound(), this.finalRange.getUpperBound());
        }
        return expansionZone;
    }
}

