/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.internal.bugzilla.ui.action.ChangeAttachmentJob;
import org.eclipse.mylyn.internal.bugzilla.ui.wizard.BugzillaAttachmentWizardPage;
import org.eclipse.mylyn.internal.bugzilla.ui.wizard.Messages;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.ui.editors.AttributeEditorFactory;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.statushandlers.StatusManager;

public class BugzillaAttachmentWizard
extends Wizard {
    private final AttributeEditorFactory factory;
    private final TaskAttribute attachmentAttribute;
    private BugzillaAttachmentWizardPage attachmentWizardPage;
    private final Shell parentShell;
    private boolean changed = false;
    private final TaskEditor taskEditor;
    private final ITaskAttachment attachment;
    private final String repositoryLabel;

    public BugzillaAttachmentWizard(Shell parentShell, AttributeEditorFactory factory, TaskAttribute attachmentAttribute, TaskEditor taskEditor, ITaskAttachment attachment, String repositoryLabel) {
        this.factory = factory;
        this.attachmentAttribute = attachmentAttribute;
        this.parentShell = parentShell;
        this.taskEditor = taskEditor;
        this.attachment = attachment;
        this.repositoryLabel = repositoryLabel;
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.BugzillaAttachmentWizard_Attachment_Details_Dialog_Title);
    }

    public boolean performFinish() {
        TaskAttribute attachmentTaskAttribute = this.attachment.getTaskAttribute();
        for (TaskAttribute child : this.attachmentAttribute.getAttributes().values()) {
            attachmentTaskAttribute.deepAddCopy(child);
        }
        ChangeAttachmentJob job = new ChangeAttachmentJob(this.attachment, this.taskEditor);
        job.setUser(true);
        if (this.attachmentWizardPage.runInBackground()) {
            this.runInBackground(job);
        } else {
            this.runInWizard(job);
        }
        return true;
    }

    private boolean runInWizard(ChangeAttachmentJob job) {
        try {
            this.getContainer().run(true, true, monitor -> {
                IStatus iStatus = job.run(monitor);
            });
            return true;
        }
        catch (InvocationTargetException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla.ui", "Unexpected error", (Throwable)e), 3);
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    private void runInBackground(ChangeAttachmentJob job) {
        job.schedule();
    }

    public void addPages() {
        this.attachmentWizardPage = new BugzillaAttachmentWizardPage(this.parentShell, this.factory, this.attachment.getTask().getTaskId(), this.attachmentAttribute, this.repositoryLabel);
        this.addPage((IWizardPage)this.attachmentWizardPage);
    }

    public boolean canFinish() {
        return this.isChanged();
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }
}

