/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.sourcelookup;

import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.sourcelookup.ISourceContainerBrowser;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class SourceLookupUIUtils {
    public static final String CONTAINER_PRESENTATION_EXTENSION = "sourceContainerPresentations";
    public static final String ICON_ATTRIBUTE = "icon";
    public static final String BROWSER_CLASS_ATTRIBUTE = "browserClass";
    public static final String CONTAINER_ID_ATTRIBUTE = "containerTypeID";
    private static Hashtable<String, IConfigurationElement> fSourceContainerPresentationHashtable;

    public SourceLookupUIUtils() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugUIPlugin.getUniqueIdentifier(), CONTAINER_PRESENTATION_EXTENSION);
        IConfigurationElement[] sourceContainerPresentationExtensions = extensionPoint.getConfigurationElements();
        fSourceContainerPresentationHashtable = new Hashtable();
        IConfigurationElement[] iConfigurationElementArray = sourceContainerPresentationExtensions;
        int n = sourceContainerPresentationExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement extension = iConfigurationElementArray[n2];
            fSourceContainerPresentationHashtable.put(extension.getAttribute(CONTAINER_ID_ATTRIBUTE), extension);
            this.registerContainerImages(extension);
            ++n2;
        }
    }

    public static Image getSourceContainerImage(String id) {
        if (fSourceContainerPresentationHashtable == null) {
            new SourceLookupUIUtils();
        }
        return DebugPluginImages.getImage(id);
    }

    public static ISourceContainerBrowser getSourceContainerBrowser(String typeID) {
        if (fSourceContainerPresentationHashtable == null) {
            new SourceLookupUIUtils();
        }
        IConfigurationElement element = fSourceContainerPresentationHashtable.get(typeID);
        ISourceContainerBrowser browser = null;
        try {
            if (element != null && element.getAttribute(BROWSER_CLASS_ATTRIBUTE) != null) {
                browser = (ISourceContainerBrowser)element.createExecutableExtension(BROWSER_CLASS_ATTRIBUTE);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return browser;
    }

    private void registerContainerImages(IConfigurationElement configElement) {
        ImageDescriptor imageDescriptor = DebugUIPlugin.getImageDescriptor(configElement, ICON_ATTRIBUTE);
        if (imageDescriptor == null) {
            imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        String configTypeID = configElement.getAttribute(CONTAINER_ID_ATTRIBUTE);
        ImageRegistry imageRegistry = DebugPluginImages.getImageRegistry();
        imageRegistry.put(configTypeID, imageDescriptor);
    }
}

