/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.util;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.datatools.enablement.ibm.util.ModelVersion;

public class ModelVersionUtil {
    public static final String PREFIX = "http://www.ibm.com/com.ibm.datatools.core/model/";
    public static final String DATAMODEL_PREFIX = "http://www.ibm.com/com.ibm.datatools.core/model/data/";
    public static final Pattern MODEL_URI_PATTERN = Pattern.compile("http://www.ibm.com/com.ibm.datatools.core/model/data/(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)");
    public static final Pattern OLD_MODEL_URI_PATTERN = Pattern.compile("http://www.ibm.com/com.ibm.datatools.core/model/(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)");
    private static Map<String, ModelVersion> map;

    static Map<String, ModelVersion> getMap() {
        if (map == null) {
            map = new HashMap<String, ModelVersion>();
            ModelVersion modelVersion = ModelVersion.CURRENT_VERSION;
        }
        return map;
    }

    public static void add(String uri, ModelVersion version) {
        ModelVersionUtil.getMap().put(uri, version);
    }

    public static ModelVersion uriToModelVersion(String uri) {
        if (uri == null) {
            return null;
        }
        ModelVersion version = ModelVersionUtil.getMap().get(uri);
        if (version != null) {
            return version;
        }
        Matcher matcher = MODEL_URI_PATTERN.matcher(uri);
        if (matcher.matches()) {
            return ModelVersion.VALID_PATTERN;
        }
        return ModelVersion.UNKNOWN;
    }

    public static String[] parseVersionNamespace(String versionNamespace) {
        Matcher matcher = MODEL_URI_PATTERN.matcher(versionNamespace);
        Matcher oldMatcher = OLD_MODEL_URI_PATTERN.matcher(versionNamespace);
        if (matcher.matches()) {
            return new String[]{DATAMODEL_PREFIX, matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4)};
        }
        if (oldMatcher.matches()) {
            return new String[]{PREFIX, oldMatcher.group(1), oldMatcher.group(2), oldMatcher.group(3), oldMatcher.group(4)};
        }
        return null;
    }
}

