/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.features.impl;

import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IMoveAnchorFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IMoveAnchorContext;
import org.eclipse.graphiti.features.impl.AbstractFeature;
import org.eclipse.graphiti.internal.Messages;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.AdvancedAnchor;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.BoxRelativeAnchor;
import org.eclipse.graphiti.mm.pictograms.FixPointAnchor;
import org.eclipse.graphiti.services.Graphiti;

public class DefaultMoveAnchorFeature
extends AbstractFeature
implements IMoveAnchorFeature {
    private static final String NAME = Messages.DefaultMoveAnchorFeature_0_xfld;

    public DefaultMoveAnchorFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public boolean canMoveAnchor(IMoveAnchorContext context) {
        Anchor anchor = context.getAnchor();
        return anchor instanceof FixPointAnchor || anchor instanceof BoxRelativeAnchor;
    }

    @Override
    public void moveAnchor(IMoveAnchorContext context) {
        if (!this.getUserDecision()) {
            return;
        }
        int posX = context.getX();
        int posY = context.getY();
        this.moveAnchor(context.getAnchor(), posX, posY);
    }

    @Override
    public void preMoveAnchor(IMoveAnchorContext context) {
    }

    @Override
    public void postMoveAnchor(IMoveAnchorContext context) {
    }

    protected void moveAnchor(Anchor anchor, int posX, int posY) {
        if (anchor instanceof AdvancedAnchor) {
            posX -= anchor.getGraphicsAlgorithm().getX();
            posY -= anchor.getGraphicsAlgorithm().getY();
        }
        if (anchor instanceof FixPointAnchor) {
            FixPointAnchor fpAnchor = (FixPointAnchor)anchor;
            fpAnchor.setLocation(Graphiti.getGaCreateService().createPoint(posX, posY));
        } else if (anchor instanceof BoxRelativeAnchor) {
            BoxRelativeAnchor brAnchor = (BoxRelativeAnchor)anchor;
            AnchorContainer anchorContainer = brAnchor.getParent();
            GraphicsAlgorithm anchorContainerGa = anchorContainer.getGraphicsAlgorithm();
            IDimension sizeOfGraphicsAlgorithm = Graphiti.getGaService().calculateSize(anchorContainerGa, false);
            int width = sizeOfGraphicsAlgorithm.getWidth();
            double newRelativeX = 1.0 * (double)posX / (double)width;
            brAnchor.setRelativeWidth(newRelativeX);
            int height = sizeOfGraphicsAlgorithm.getHeight();
            double newRelativeY = 1.0 * (double)posY / (double)height;
            brAnchor.setRelativeHeight(newRelativeY);
        }
    }

    @Override
    public boolean canExecute(IContext context) {
        boolean ret = false;
        if (context instanceof IMoveAnchorContext) {
            ret = this.canMoveAnchor((IMoveAnchorContext)context);
        }
        return ret;
    }

    @Override
    public void execute(IContext context) {
        if (context instanceof IMoveAnchorContext) {
            this.moveAnchor((IMoveAnchorContext)context);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }
}

