/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.disassembly;

import java.math.BigInteger;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.DisassemblyUtils;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.DisassemblyMessages;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.DisassemblyPart;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.model.SourceFileInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

class EditionFinderJob
extends Job {
    private final IFile fFile;
    private final BigInteger fAddress;
    private final DisassemblyPart fDisassemblyPart;
    private final SourceFileInfo fSourceInfo;

    public EditionFinderJob(SourceFileInfo sourceInfo, BigInteger address, DisassemblyPart disassemblyPart) {
        super(DisassemblyMessages.EditionFinderJob_name);
        Assert.isNotNull((Object)sourceInfo);
        Assert.isLegal((boolean)(sourceInfo.fFile instanceof IFile));
        this.fSourceInfo = sourceInfo;
        this.fFile = (IFile)sourceInfo.fFile;
        this.fAddress = address;
        this.fDisassemblyPart = disassemblyPart;
        this.setRule((ISchedulingRule)this.fFile);
        this.setSystem(true);
        sourceInfo.fEditionJob = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(DisassemblyMessages.EditionFinderJob_name, 2);
        monitor.subTask(DisassemblyMessages.EditionFinderJob_task_get_timestamp);
        Object token = this.fDisassemblyPart.retrieveModuleTimestamp(this.fAddress);
        if (token != null && !(token instanceof Long) && !monitor.isCanceled()) {
            try {
                Object object = token;
                synchronized (object) {
                    token.wait(1000L);
                }
            }
            catch (InterruptedException e) {
                DisassemblyUtils.internalError((Throwable)e);
            }
            token = this.fDisassemblyPart.retrieveModuleTimestamp(this.fAddress);
        }
        monitor.worked(1);
        if (token instanceof Long && !monitor.isCanceled()) {
            long moduleTime = (Long)token;
            long buildTime = moduleTime * 1000L;
            if (this.fFile.getLocalTimeStamp() > buildTime) {
                IFileState[] states;
                monitor.subTask(DisassemblyMessages.EditionFinderJob_task_search_history);
                try {
                    states = this.fFile.getHistory((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                catch (CoreException e) {
                    states = new IFileState[]{};
                }
                int i = 0;
                while (i < states.length) {
                    IFileState state = states[i];
                    long saveTime = state.getModificationTime();
                    if (saveTime <= buildTime) {
                        this.fSourceInfo.fEdition = state;
                        break;
                    }
                    ++i;
                }
            }
        }
        this.fSourceInfo.fEditionJob = null;
        monitor.worked(1);
        monitor.done();
        return Status.OK_STATUS;
    }
}

