/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.layouts.algorithms.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.zest.layouts.LayoutEntity;
import org.eclipse.zest.layouts.LayoutRelationship;
import org.eclipse.zest.layouts.algorithms.AbstractLayoutAlgorithm;

public class CycleChecker {
    public static boolean hasDirectedCircles(LayoutEntity[] entities, LayoutRelationship[] relationships, List<LayoutEntity> cycle) {
        if (!AbstractLayoutAlgorithm.verifyInput(entities, relationships)) {
            throw new RuntimeException("The endpoints of the relationships aren't contained in the entities list.");
        }
        HashMap<LayoutEntity, List<LayoutRelationship>> endPoints = new HashMap<LayoutEntity, List<LayoutRelationship>>();
        LayoutRelationship[] layoutRelationshipArray = relationships;
        int n = relationships.length;
        int n2 = 0;
        while (n2 < n) {
            LayoutRelationship rel = layoutRelationshipArray[n2];
            LayoutEntity subject = rel.getSourceInLayout();
            List rels = endPoints.computeIfAbsent(subject, sub -> new ArrayList());
            if (!rels.contains(rel)) {
                rels.add(rel);
            }
            ++n2;
        }
        return CycleChecker.hasCycle(new ArrayList<LayoutEntity>(Arrays.asList(entities)), endPoints, cycle);
    }

    private static boolean hasCycle(List<LayoutEntity> nodesToCheck, Map<LayoutEntity, List<LayoutRelationship>> endPoints, List<LayoutEntity> cycle) {
        while (!nodesToCheck.isEmpty()) {
            ArrayList<LayoutEntity> checkedNodes;
            LayoutEntity checkNode = nodesToCheck.get(0);
            if (CycleChecker.hasCycle(checkNode, new ArrayList<LayoutEntity>(), null, endPoints, checkedNodes = new ArrayList<LayoutEntity>(), cycle)) {
                return true;
            }
            nodesToCheck.removeAll(checkedNodes);
        }
        return false;
    }

    private static boolean hasCycle(LayoutEntity nodeToCheck, List<LayoutEntity> nodePathSoFar, LayoutRelationship cameFrom, Map<LayoutEntity, List<LayoutRelationship>> endPoints, List<LayoutEntity> nodesChecked, List<LayoutEntity> cycle) {
        if (nodePathSoFar.contains(nodeToCheck)) {
            cycle.addAll(nodePathSoFar);
            cycle.add(nodeToCheck);
            return true;
        }
        nodePathSoFar.add(nodeToCheck);
        nodesChecked.add(nodeToCheck);
        List<LayoutRelationship> relations = endPoints.get(nodeToCheck);
        if (relations != null) {
            for (LayoutRelationship rel : relations) {
                LayoutEntity currentNode;
                if (cameFrom != null && rel.equals(cameFrom) || !CycleChecker.hasCycle(currentNode = rel.getDestinationInLayout(), nodePathSoFar, rel, endPoints, nodesChecked, cycle)) continue;
                return true;
            }
        }
        nodePathSoFar.remove(nodeToCheck);
        return false;
    }
}

