/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.layouts.algorithms;

import java.lang.reflect.Field;
import java.util.Deque;
import java.util.HashMap;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraphLayout;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.zest.layouts.LayoutItem;
import org.eclipse.zest.layouts.algorithms.AbstractLayoutAlgorithm;
import org.eclipse.zest.layouts.dataStructures.InternalNode;
import org.eclipse.zest.layouts.dataStructures.InternalRelationship;

public class DirectedGraphLayoutAlgorithm
extends AbstractLayoutAlgorithm {
    public DirectedGraphLayoutAlgorithm(int styles) {
        super(styles);
    }

    @Override
    protected void applyLayoutInternal(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider, double boundsX, double boundsY, double boundsWidth, double boundsHeight) {
        HashMap<InternalNode, Node> mapping = new HashMap<InternalNode, Node>(entitiesToLayout.length);
        DirectedGraph graph = new DirectedGraph();
        LayoutItem[] layoutItemArray = entitiesToLayout;
        int n = entitiesToLayout.length;
        int n2 = 0;
        while (n2 < n) {
            InternalNode internalNode = layoutItemArray[n2];
            Node node = new Node((Object)internalNode);
            node.setSize(new Dimension(10, 10));
            mapping.put(internalNode, node);
            graph.nodes.add((Object)node);
            ++n2;
        }
        layoutItemArray = relationshipsToConsider;
        n = relationshipsToConsider.length;
        n2 = 0;
        while (n2 < n) {
            LayoutItem relationship = layoutItemArray[n2];
            Node source = (Node)mapping.get(((InternalRelationship)relationship).getSource());
            Node dest = (Node)mapping.get(((InternalRelationship)relationship).getDestination());
            Edge edge = new Edge((Object)relationship, source, dest);
            graph.edges.add((Object)edge);
            ++n2;
        }
        ExtendedDirectedGraphLayout directedGraphLayout = new ExtendedDirectedGraphLayout();
        directedGraphLayout.visit(graph);
        for (Object node2 : graph.nodes) {
            Node node = (Node)node2;
            InternalNode internalNode = (InternalNode)node.data;
            if ((this.layout_styles & 0x100) == 256) {
                internalNode.setInternalLocation(node.y, node.x);
                continue;
            }
            internalNode.setInternalLocation(node.x, node.y);
        }
        this.updateLayoutLocations(entitiesToLayout);
    }

    @Override
    protected int getCurrentLayoutStep() {
        return 0;
    }

    @Override
    protected int getTotalNumberOfLayoutSteps() {
        return 0;
    }

    @Override
    protected boolean isValidConfiguration(boolean asynchronous, boolean continuous) {
        return true;
    }

    @Override
    protected void postLayoutAlgorithm(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider) {
    }

    @Override
    protected void preLayoutAlgorithm(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider, double x, double y, double width, double height) {
    }

    @Override
    public void setLayoutArea(double x, double y, double width, double height) {
    }

    class ExtendedDirectedGraphLayout
    extends DirectedGraphLayout {
        ExtendedDirectedGraphLayout() {
        }

        public void visit(DirectedGraph graph) {
            try {
                Field field = DirectedGraphLayout.class.getDeclaredField("steps");
                field.setAccessible(true);
                Object object = field.get((Object)this);
                Deque steps = (Deque)object;
                steps.remove(10);
                steps.remove(9);
                steps.remove(8);
                steps.remove(2);
                field.setAccessible(false);
                super.visit(graph);
            }
            catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
                e.printStackTrace();
            }
        }
    }
}

