/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views.handler;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.tcf.te.ui.views.ViewsUtil;
import org.eclipse.tcf.te.ui.views.handler.MRUList;
import org.eclipse.tcf.te.ui.views.handler.UpdateActiveExtensionsOperation;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorContentService;

public class ContentMRUContribution
extends CompoundContributionItem {
    protected IContributionItem[] getContributionItems() {
        CommonNavigator navigator = (CommonNavigator)ViewsUtil.getPart("org.eclipse.tcf.te.ui.views.View");
        if (navigator == null) {
            return new IContributionItem[0];
        }
        INavigatorContentService contentService = navigator.getNavigatorContentService();
        ArrayList<ActionContributionItem> items = new ArrayList<ActionContributionItem>();
        MRUList extensionSet = new MRUList("te.ui.PrefContentMRUs");
        CommonViewer commonViewer = navigator.getCommonViewer();
        int i = 0;
        while (i < extensionSet.size()) {
            String extensionId = (String)extensionSet.get(i);
            INavigatorContentDescriptor contentDescriptor = contentService.getContentDescriptorById(extensionId);
            if (contentDescriptor != null) {
                items.add(new ActionContributionItem((IAction)new ContentMRUAction(i + 1, contentDescriptor, contentService, commonViewer)));
            }
            ++i;
        }
        return items.toArray(new IContributionItem[items.size()]);
    }

    static class ContentMRUAction
    extends Action {
        private INavigatorContentService contentService;
        private INavigatorContentDescriptor contentDescriptor;
        private CommonViewer commonViewer;

        public ContentMRUAction(int order, INavigatorContentDescriptor contentDescriptor, INavigatorContentService contentService, CommonViewer commonViewer) {
            super(order + " " + contentDescriptor.getName(), 2);
            this.contentDescriptor = contentDescriptor;
            this.contentService = contentService;
            this.commonViewer = commonViewer;
            this.setChecked(contentService.isActive(contentDescriptor.getId()));
        }

        public void run() {
            HashSet<String> activeIds = new HashSet<String>();
            String[] visibleIds = this.contentService.getVisibleExtensionIds();
            if (visibleIds != null) {
                String[] stringArray = visibleIds;
                int n = visibleIds.length;
                int n2 = 0;
                while (n2 < n) {
                    String visibleId = stringArray[n2];
                    if (this.contentService.isActive(visibleId)) {
                        activeIds.add(visibleId);
                    }
                    ++n2;
                }
            }
            if (this.isChecked()) {
                activeIds.add(this.contentDescriptor.getId());
            } else {
                activeIds.remove(this.contentDescriptor.getId());
            }
            String[] idsToActivate = activeIds.toArray(new String[activeIds.size()]);
            UpdateActiveExtensionsOperation updateExtensions = new UpdateActiveExtensionsOperation(this.commonViewer, idsToActivate);
            updateExtensions.execute(null, null);
        }
    }
}

