/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.controls.validator;

import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.tcf.te.ui.controls.validator.RegexVerifyListener;

public class HexVerifyListener
extends RegexVerifyListener {
    public static final int ATTR_TO_UPPER_CASE = 1;
    public static final int ATTR_ALLOW_DECIMAL = 2;
    public static final int ATTR_ALLOW_NEGATIVE_DECIMAL = 4;
    public static final int ATTR_ALLOW_NEGATIVE_HEX = 8;
    protected static final String HEX_REGEX = "@NEGATIVE@(0((x|X)[0-9a-fA-F]{0,@BYTES@})?)?";
    protected static final String NUMBER_REGEX = "@NEGATIVE@([0-9]*)";

    public HexVerifyListener(int attributes, int bytes) {
        super(attributes, HexVerifyListener.getRegEx(attributes, bytes));
    }

    private static String getRegEx(int attributes, int bytes) {
        return String.valueOf(HexVerifyListener.isAttribute(2, attributes) ? String.valueOf(NUMBER_REGEX.replaceAll("@NEGATIVE@", HexVerifyListener.isAttribute(4, attributes) ? "-?" : "")) + "|" : "") + HEX_REGEX.replaceAll("@BYTES@", "" + bytes).replaceAll("@NEGATIVE@", HexVerifyListener.isAttribute(8, attributes) ? "-?" : "");
    }

    public void setBounds(int maxBytes) {
        Assert.isTrue((maxBytes >= 0 ? 1 : 0) != 0);
        this.setRegularExpression(HexVerifyListener.getRegEx(this.getAttributes(), maxBytes));
    }

    @Override
    public void verifyText(VerifyEvent e) {
        super.verifyText(e);
        if (e.doit && this.isAttribute(1)) {
            e.text = e.text.toUpperCase().replace('X', 'x');
        }
    }
}

