/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.propertypages;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ValidatorSpecialChar;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SystemKeyValueFieldEditor
extends FieldEditor {
    private List keysField;
    private Text valueField;
    private Label keysLabel;
    private Label valueLabel;
    private Composite keysComposite;
    private Composite valueComposite;
    private Group boxComposite;
    private Button setButton;
    private Button clearButton;
    private String keysLabelString;
    private String valueLabelString;
    private char keyValueDelimiter = (char)61;
    private char keyValuePairDelimiter = (char)59;
    private SystemMessage errorMessage;
    private boolean contentInited;
    protected ISystemValidator valueValidator;
    protected ISystemValidator defaultValueValidator;
    private String[] contentArray;
    private Hashtable keyValues;
    private SelectionListener selectionListener;
    private static boolean boxFlavor = true;

    private SystemKeyValueFieldEditor() {
    }

    public SystemKeyValueFieldEditor(String name, String labelText, String[] keys, String keysLabelString, String valueLabelString, Composite parent) {
        super(name, labelText, parent);
        this.keyValues = new Hashtable();
        this.contentArray = keys;
        this.keysLabelString = keysLabelString;
        this.valueLabelString = valueLabelString;
        this.keysLabel.setText(keysLabelString);
        this.valueLabel.setText(valueLabelString);
        this.initContents();
        String specialChars = this.makeString(this.keyValueDelimiter, this.keyValuePairDelimiter);
        this.defaultValueValidator = new ValidatorSpecialChar(specialChars, true);
    }

    public void setValueValidator(ISystemValidator v) {
        this.valueValidator = v;
    }

    public void setDelimiterCharacters(char keyValueDelimiter, char keyValuePairDelimiter) {
        this.keyValueDelimiter = keyValueDelimiter;
        this.keyValuePairDelimiter = keyValuePairDelimiter;
        String specialChars = this.makeString(keyValueDelimiter, keyValuePairDelimiter);
        this.defaultValueValidator = new ValidatorSpecialChar(specialChars, true);
    }

    public int getNumberOfControls() {
        return boxFlavor ? 1 : 2;
    }

    protected void doStore() {
        String s = this.createString(this.keyValues);
        if (s != null) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), s);
        }
    }

    protected void doLoadDefault() {
        if (this.keysField != null) {
            String value = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            this.keyValues = value != null ? this.parseString(value) : new Hashtable();
            this.valueField.setText("");
            this.keysField.select(0);
            this.clearButton.setEnabled(false);
            this.setButton.setEnabled(false);
        }
    }

    protected void doLoad() {
        String value = this.getPreferenceStore().getString(this.getPreferenceName());
        if (value == null || value.length() == 0) {
            value = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
        }
        if (value != null) {
            this.keyValues = this.parseString(value);
        }
        if (this.keysField != null) {
            this.keysField.select(0);
            this.selectionChanged();
        }
    }

    public Hashtable parseString(String allvalues) {
        StringTokenizer tokens = new StringTokenizer(allvalues, this.makeString(this.keyValueDelimiter, this.keyValuePairDelimiter));
        Hashtable<String, String> keyValues = new Hashtable<String, String>(10);
        int count = 0;
        String token1 = null;
        String token2 = null;
        while (tokens.hasMoreTokens()) {
            if (++count % 2 == 0) {
                token2 = tokens.nextToken();
                keyValues.put(token1, token2);
                continue;
            }
            token1 = tokens.nextToken();
        }
        return keyValues;
    }

    protected String createString(Hashtable keyValues) {
        Enumeration keys = keyValues.keys();
        StringBuffer sb = new StringBuffer();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = (String)keyValues.get(key);
            if (value == null || value.length() <= 0) continue;
            sb.append(key);
            sb.append(this.keyValueDelimiter);
            sb.append(value);
            sb.append(this.keyValuePairDelimiter);
        }
        return sb.toString();
    }

    private String makeString(char charOne, char charTwo) {
        StringBuffer s = new StringBuffer(2);
        s.append(charOne);
        s.append(charTwo);
        return s.toString();
    }

    private void initContents() {
        if (this.contentArray != null && this.keysField != null && !this.contentInited) {
            this.keysField.setItems(this.contentArray);
            this.contentInited = true;
        }
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control;
        GridData gd = null;
        if (!boxFlavor && (control = this.getLabelControl(parent)) != null) {
            gd = new GridData();
            gd.horizontalSpan = numColumns;
            control.setLayoutData((Object)gd);
        }
        this.boxComposite = SystemWidgetHelpers.createGroupComposite(parent, 2, this.getLabelText());
        ((GridData)this.boxComposite.getLayoutData()).horizontalSpan = numColumns;
        this.keysComposite = this.getKeysControl((Composite)this.boxComposite);
        this.valueComposite = this.getValueControl((Composite)this.boxComposite);
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        if (control != null) {
            ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        }
        if (this.boxComposite != null) {
            ((GridData)this.boxComposite.getLayoutData()).horizontalSpan = numColumns;
        }
    }

    protected List getKeysControl() {
        return this.keysField;
    }

    protected Text getValueControl() {
        return this.valueField;
    }

    public Composite getKeysControl(Composite parent) {
        if (this.keysComposite == null) {
            this.keysComposite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            this.keysComposite.setLayout((Layout)layout);
            GridData data = new GridData(1808);
            data.heightHint = 150;
            this.keysComposite.setLayoutData((Object)data);
            this.keysLabel = new Label(this.keysComposite, 0);
            if (this.keysLabelString != null) {
                this.keysLabel.setText(this.keysLabelString);
            }
            data = new GridData(768);
            data.widthHint = 150;
            this.keysLabel.setLayoutData((Object)data);
            int options = 2820;
            this.keysField = new List(this.keysComposite, options);
            data = new GridData(1808);
            data.widthHint = 150;
            this.keysField.setLayoutData((Object)data);
            this.keysField.addSelectionListener(this.getSelectionListener());
            this.keysComposite.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    SystemKeyValueFieldEditor.this.keysComposite = null;
                    SystemKeyValueFieldEditor.this.keysField = null;
                    SystemKeyValueFieldEditor.this.keysLabel = null;
                }
            });
        }
        return this.keysComposite;
    }

    public Composite getValueControl(Composite parent) {
        if (this.valueComposite == null) {
            this.valueComposite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            this.valueComposite.setLayout((Layout)layout);
            GridData data = new GridData(1808);
            data.heightHint = 150;
            this.valueComposite.setLayoutData((Object)data);
            this.valueLabel = new Label(this.valueComposite, 0);
            if (this.valueLabelString != null) {
                this.valueLabel.setText(this.valueLabelString);
            }
            data = new GridData(768);
            this.valueLabel.setLayoutData((Object)data);
            this.valueField = new Text(this.valueComposite, 2052);
            data = new GridData(768);
            data.widthHint = 150;
            this.valueField.setLayoutData((Object)data);
            this.setButton = this.createPushButton(this.valueComposite, SystemResources.ACTION_SET_LABEL, SystemResources.ACTION_SET_TOOLTIP);
            this.clearButton = this.createPushButton(this.valueComposite, SystemResources.ACTION_CLEAR_LABEL, SystemResources.ACTION_CLEAR_TOOLTIP);
            this.valueField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SystemKeyValueFieldEditor.this.validateValueInput();
                }
            });
            this.valueComposite.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    SystemKeyValueFieldEditor.this.valueComposite = null;
                    SystemKeyValueFieldEditor.this.valueField = null;
                    SystemKeyValueFieldEditor.this.valueLabel = null;
                    SystemKeyValueFieldEditor.this.setButton = null;
                }
            });
        }
        return this.valueComposite;
    }

    private Button createPushButton(Composite parent, String label, String tooltip) {
        Button button = new Button(parent, 8);
        button.setText(label);
        button.setToolTipText(tooltip);
        GridData data = new GridData(768);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        button.addSelectionListener(this.getSelectionListener());
        return button;
    }

    private SelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.createSelectionListener();
        }
        return this.selectionListener;
    }

    public void createSelectionListener() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Widget widget = event.widget;
                if (widget == SystemKeyValueFieldEditor.this.setButton) {
                    SystemKeyValueFieldEditor.this.setPressed();
                } else if (widget == SystemKeyValueFieldEditor.this.clearButton) {
                    SystemKeyValueFieldEditor.this.clearPressed();
                } else if (widget == SystemKeyValueFieldEditor.this.keysField) {
                    SystemKeyValueFieldEditor.this.selectionChanged();
                }
            }
        };
    }

    protected SystemMessage validateValueInput() {
        this.errorMessage = null;
        String valueInput = this.valueField.getText().trim();
        if (this.valueValidator != null) {
            this.errorMessage = this.valueValidator.validate(valueInput);
        } else if (this.defaultValueValidator != null) {
            this.errorMessage = this.defaultValueValidator.validate(valueInput);
        }
        if (this.errorMessage != null) {
            this.showErrorMessage(this.errorMessage.getLevelOneText());
        } else {
            this.clearErrorMessage();
        }
        this.setButton.setEnabled(this.errorMessage == null && valueInput.length() > 0);
        return this.errorMessage;
    }

    private void setPressed() {
        this.setPresentsDefaultValue(false);
        int index = this.keysField.getSelectionIndex();
        if (index >= 0) {
            String value = this.valueField.getText().trim();
            this.valueField.setText(value);
            if (value.length() == 0) {
                this.keyValues.remove(this.contentArray[index]);
            } else {
                this.keyValues.put(this.contentArray[index], value);
            }
            this.selectionChanged();
        } else {
            this.setButton.setEnabled(false);
        }
    }

    private void clearPressed() {
        this.setPresentsDefaultValue(false);
        int index = this.keysField.getSelectionIndex();
        if (index >= 0) {
            this.keyValues.remove(this.contentArray[index]);
            this.selectionChanged();
        } else {
            this.clearButton.setEnabled(false);
        }
    }

    private void selectionChanged() {
        int index = this.keysField.getSelectionIndex();
        if (index >= 0) {
            String key = this.contentArray[index];
            String value = (String)this.keyValues.get(key);
            if (value == null) {
                this.valueField.setText("");
                this.clearButton.setEnabled(false);
            } else {
                this.valueField.setText(value);
                this.clearButton.setEnabled(true);
            }
        } else {
            this.clearButton.setEnabled(false);
        }
        this.setButton.setEnabled(false);
    }

    public void setHeightHint(int hint) {
        if (this.keysComposite != null) {
            ((GridData)this.keysComposite.getLayoutData()).heightHint = hint;
        }
        if (this.valueComposite != null) {
            ((GridData)this.valueComposite.getLayoutData()).heightHint = hint;
        }
    }

    public void setKeysWidthHint(int hint) {
        if (this.keysComposite != null) {
            ((GridData)this.keysComposite.getLayoutData()).widthHint = hint;
        }
    }

    public void setValuesWidthHint(int hint) {
        if (this.valueComposite != null) {
            ((GridData)this.valueComposite.getLayoutData()).widthHint = hint;
        }
    }

    public void setToolTipText(String tip) {
        if (boxFlavor) {
            this.boxComposite.setToolTipText(tip);
        } else {
            this.keysComposite.setToolTipText(tip);
            this.valueComposite.setToolTipText(tip);
        }
    }

    public String getToolTipText() {
        if (boxFlavor) {
            return this.boxComposite.getToolTipText();
        }
        return this.keysComposite.getToolTipText();
    }
}

