/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.internal.progress.AbstractProgressViewer;

public class ProgressCanvasViewer
extends AbstractProgressViewer {
    Label canvas;
    Object[] displayedItems = new Object[0];
    private static final List EMPTY_LIST = new ArrayList();
    private int numShowItems = 1;
    private int maxCharacterWidth;

    ProgressCanvasViewer(Composite parent, int style, int itemsToShow, int numChars, int orientation) {
        this.numShowItems = itemsToShow;
        this.maxCharacterWidth = numChars;
        this.canvas = new Label(parent, style | 0x1000000);
        this.hookControl((Control)this.canvas);
        this.initializeListeners();
    }

    protected void hookControl(Control control) {
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ProgressCanvasViewer.this.handleDispose(event);
            }
        });
    }

    protected Widget doFindInputItem(Object element) {
        return null;
    }

    protected Widget doFindItem(Object element) {
        return null;
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
        this.updateLabel();
        this.canvas.redraw();
    }

    protected List getSelectionFromWidget() {
        return EMPTY_LIST;
    }

    protected void internalRefresh(Object element) {
        this.displayedItems = this.getSortedChildren(this.getRoot());
        this.updateLabel();
        this.canvas.redraw();
    }

    private void updateLabel() {
        ILabelProvider labelProvider = (ILabelProvider)this.getLabelProvider();
        if (this.displayedItems.length > 0) {
            this.canvas.setText(labelProvider.getText(this.displayedItems[0]));
        } else {
            this.canvas.setText("");
        }
    }

    public void reveal(Object element) {
    }

    protected void setSelectionToWidget(List l, boolean reveal) {
    }

    public Control getControl() {
        return this.canvas;
    }

    private void initializeListeners() {
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        Assert.isTrue((boolean)(labelProvider instanceof ILabelProvider));
        super.setLabelProvider(labelProvider);
    }

    public Point getSizeHints() {
        Display display = this.canvas.getDisplay();
        GC gc = new GC((Drawable)this.canvas);
        FontMetrics fm = gc.getFontMetrics();
        int charWidth = fm.getAverageCharWidth();
        int charHeight = fm.getHeight();
        gc.dispose();
        int maxWidth = display.getBounds().width / 2;
        int maxHeight = display.getBounds().height / 6;
        int fontWidth = charWidth * this.maxCharacterWidth;
        int fontHeight = charHeight * this.numShowItems;
        if (maxWidth < fontWidth) {
            fontWidth = maxWidth;
        }
        if (maxHeight < fontHeight) {
            fontHeight = maxHeight;
        }
        return new Point(fontWidth, fontHeight);
    }

    @Override
    public void add(Object[] elements) {
        this.refresh(true);
    }

    @Override
    public void remove(Object[] elements) {
        this.refresh(true);
    }
}

