/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.wizards;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org.eclipse.php.internal.debug.core.debugger.IDebuggerSettingsWorkingCopy;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.ui.wizards.IDebuggerSettingsSection;
import org.eclipse.php.internal.debug.ui.wizards.Messages;
import org.eclipse.php.internal.ui.wizards.CompositeFragment;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ZendDebuggerExeSettingsSection
implements IDebuggerSettingsSection {
    protected IDebuggerSettingsWorkingCopy settingsWorkingCopy;
    protected CompositeFragment compositeFragment;
    protected Composite settingsComposite;
    protected IStatus debuggerStatus;

    public ZendDebuggerExeSettingsSection(CompositeFragment compositeFragment, Composite debuggerSettingsComposite, IDebuggerSettingsWorkingCopy settingsWorkingCopy) {
        this.settingsWorkingCopy = settingsWorkingCopy;
        this.compositeFragment = compositeFragment;
        this.settingsComposite = debuggerSettingsComposite;
        this.createContents();
    }

    @Override
    public boolean performOK() {
        return true;
    }

    @Override
    public boolean performCancel() {
        return true;
    }

    @Override
    public void validate() {
        this.compositeFragment.setMessage(this.compositeFragment.getDescription(), 0);
        if (this.debuggerStatus == null) {
            AbstractDebuggerConfiguration[] debuggers;
            this.debuggerStatus = Status.OK_STATUS;
            PHPexeItem phpExe = (PHPexeItem)this.compositeFragment.getData();
            AbstractDebuggerConfiguration[] abstractDebuggerConfigurationArray = debuggers = PHPDebuggersRegistry.getDebuggersConfigurations();
            int n = debuggers.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractDebuggerConfiguration debugger = abstractDebuggerConfigurationArray[n2];
                if (phpExe.getDebuggerID().equals(debugger.getDebuggerId())) {
                    this.debuggerStatus = debugger.validate(phpExe);
                }
                ++n2;
            }
        }
        if (this.debuggerStatus.getSeverity() == 4) {
            this.compositeFragment.setMessage(this.debuggerStatus.getMessage(), 3);
            return;
        }
        String clientPort = this.settingsWorkingCopy.getAttribute("clientPort");
        if (clientPort == null || clientPort.isEmpty()) {
            this.compositeFragment.setMessage(Messages.ZendDebuggerExeSettingsSection_Client_port_is_missing, 3);
            return;
        }
        if (this.debuggerStatus.getSeverity() == 2) {
            this.compositeFragment.setMessage(this.debuggerStatus.getMessage(), 2);
            return;
        }
        int port = Integer.valueOf(clientPort);
        if (!PHPLaunchUtilities.isPortAvailable((int)port) && !PHPLaunchUtilities.isDebugDaemonActive((int)port, (String)"org.eclipse.php.debug.core.zendDebugger")) {
            this.compositeFragment.setMessage(MessageFormat.format(Messages.DebuggerCommonSettingsSection_Port_is_already_in_use, clientPort), 2);
            return;
        }
    }

    @Override
    public boolean canTest() {
        return false;
    }

    @Override
    public void performTest() {
    }

    protected void createContents() {
        Group connectionGroup = new Group(this.settingsComposite, 0);
        connectionGroup.setFont(this.compositeFragment.getFont());
        GridLayout cgLayout = new GridLayout(2, false);
        cgLayout.marginTop = 5;
        connectionGroup.setLayout((Layout)cgLayout);
        GridData cgGridData = new GridData(768);
        connectionGroup.setLayoutData((Object)cgGridData);
        connectionGroup.setText(Messages.ZendDebuggerExeSettingsSection_Connection_settings);
        Label clientPortLabel = new Label((Composite)connectionGroup, 0);
        clientPortLabel.setText(Messages.ZendDebuggerExeSettingsSection_Client_port);
        final Text clientPortText = new Text((Composite)connectionGroup, 2048);
        GridData cptLayoutData = new GridData(768);
        clientPortText.setLayoutData((Object)cptLayoutData);
        clientPortText.setText(this.settingsWorkingCopy.getAttribute("clientPort"));
        clientPortText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String port = clientPortText.getText();
                ZendDebuggerExeSettingsSection.this.settingsWorkingCopy.setAttribute("clientPort", port);
                ZendDebuggerExeSettingsSection.this.validate();
            }
        });
    }
}

