/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.parser.builder;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.mylyn.wikitext.parser.builder.HtmlDocumentBuilder;

class HtmlEntities {
    private static HtmlEntities instance = new HtmlEntities();
    private final ListMultimap<String, String> nameToNumericEntityReferences = HtmlEntities.readHtmlEntities();
    private final Map<String, String> nameToStringEquivalent = this.createNameToStringEquivalent(this.nameToNumericEntityReferences);

    private static ListMultimap<String, String> readHtmlEntities() {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(HtmlDocumentBuilder.class.getResourceAsStream("html-entity-references.txt"), StandardCharsets.UTF_8));){
                String line;
                Splitter splitter = Splitter.on((CharMatcher)CharMatcher.whitespace()).trimResults().omitEmptyStrings();
                while ((line = reader.readLine()) != null) {
                    List lineItems = splitter.splitToList((CharSequence)line);
                    Preconditions.checkState((lineItems.size() > 1 ? 1 : 0) != 0);
                    int x = 1;
                    while (x < lineItems.size()) {
                        builder.put((Object)((String)lineItems.get(0)), (Object)((String)lineItems.get(x)));
                        ++x;
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return builder.build();
    }

    public static HtmlEntities instance() {
        return instance;
    }

    private HtmlEntities() {
    }

    public List<String> nameToEntityReferences(String name) {
        return this.nameToNumericEntityReferences.get((Object)name);
    }

    public String nameToStringEquivalent(String name) {
        return this.nameToStringEquivalent.get(name);
    }

    private Map<String, String> createNameToStringEquivalent(ListMultimap<String, String> nameToNumericEntityReferences) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (String name : nameToNumericEntityReferences.keySet()) {
            mapBuilder.put((Object)name, (Object)this.stringEquivalent(nameToNumericEntityReferences.get((Object)name)));
        }
        return mapBuilder.build();
    }

    private String stringEquivalent(List<String> values) {
        return Normalizer.normalize(values.stream().map(this::numericEntityToString).collect(Collectors.joining()), Normalizer.Form.NFC);
    }

    private String numericEntityToString(String s) {
        Preconditions.checkArgument((s.charAt(0) == '#' ? 1 : 0) != 0);
        return String.valueOf((char)Integer.parseInt(s.substring(1)));
    }
}

