/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.monitor.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.mylyn.commons.core.ExtensionPointReader;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.monitor.ui.ActivityContextManager;
import org.eclipse.mylyn.internal.monitor.ui.IMonitoredWindow;
import org.eclipse.mylyn.internal.monitor.ui.WorkbenchUserActivityMonitor;
import org.eclipse.mylyn.monitor.core.IInteractionEventListener;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.mylyn.monitor.ui.AbstractUserActivityMonitor;
import org.eclipse.mylyn.monitor.ui.AbstractUserInteractionMonitor;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.BundleContext;

public class MonitorUiPlugin
extends AbstractUIPlugin {
    private static final int DEFAULT_ACTIVITY_TIMEOUT = 180000;
    public static final String ID_PLUGIN = "org.eclipse.mylyn.monitor.ui";
    private static MonitorUiPlugin INSTANCE;
    private final List<AbstractUserInteractionMonitor> selectionMonitors = new ArrayList<AbstractUserInteractionMonitor>();
    private final List<IInteractionEventListener> interactionListeners = new ArrayList<IInteractionEventListener>();
    private ActivityContextManager activityContextManager;
    private final List<AbstractUserActivityMonitor> monitors = new ArrayList<AbstractUserActivityMonitor>();
    protected Set<IPartListener> partListeners = new HashSet<IPartListener>();
    protected Set<IPageListener> pageListeners = new HashSet<IPageListener>();
    protected Set<IPerspectiveListener> perspectiveListeners = new HashSet<IPerspectiveListener>();
    protected Set<ISelectionListener> postSelectionListeners = new HashSet<ISelectionListener>();
    private final Set<IWorkbenchWindow> monitoredWindows = new HashSet<IWorkbenchWindow>();
    public static final String OBFUSCATED_LABEL = "[obfuscated]";
    public static final String ACTIVITY_TRACKING_ENABLED = "org.eclipse.mylyn.monitor.activity.tracking.enabled";
    private IWorkbenchWindow launchingWorkbenchWindow = null;
    private final IPropertyChangeListener PROPERTY_LISTENER = event -> {
        if (event.getProperty().equals("org.eclipse.mylyn.monitor.ui.activity.timeout") || event.getProperty().equals("org.eclipse.mylyn.monitor.ui.activity.timeout.enabled")) {
            this.updateActivityTimout();
        } else if (event.getProperty().equals(ACTIVITY_TRACKING_ENABLED)) {
            this.setActivityTrackingEnabled(this.getPreferenceStore().getBoolean(ACTIVITY_TRACKING_ENABLED));
        }
    };
    protected IWindowListener WINDOW_LISTENER = new IWindowListener(){

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        /*
         * WARNING - void declaration
         */
        public void windowOpened(IWorkbenchWindow window) {
            if (PlatformUI.getWorkbench().isClosing()) {
                return;
            }
            IWorkbenchWindow iWorkbenchWindow = window;
            if (iWorkbenchWindow instanceof IMonitoredWindow) {
                void awareWindow;
                IMonitoredWindow iMonitoredWindow = (IMonitoredWindow)iWorkbenchWindow;
                IMonitoredWindow cfr_ignored_0 = (IMonitoredWindow)iWorkbenchWindow;
                if (!awareWindow.isMonitored()) {
                    return;
                }
            }
            MonitorUiPlugin.this.addListenersToWindow(window);
        }

        public void windowClosed(IWorkbenchWindow window) {
            MonitorUiPlugin.this.removeListenersFromWindow(window);
            if (window == MonitorUiPlugin.this.launchingWorkbenchWindow) {
                MonitorUiPlugin.this.launchingWorkbenchWindow = null;
            }
        }
    };
    private boolean activityTrackingEnabled;

    public MonitorUiPlugin() {
        INSTANCE = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.getPreferenceStore().setDefault("org.eclipse.mylyn.monitor.ui.activity.timeout", 180000);
        this.getPreferenceStore().setDefault("org.eclipse.mylyn.monitor.ui.activity.timeout.enabled", true);
        this.getPreferenceStore().setDefault(ACTIVITY_TRACKING_ENABLED, false);
        this.activityContextManager = new ActivityContextManager(new ArrayList<AbstractUserActivityMonitor>(0));
        UIJob job = new UIJob("Mylyn Monitor Startup"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                MonitorUiPlugin.this.init();
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.setSystem(true);
        job.schedule();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        try {
            if (this.activityContextManager != null) {
                this.activityContextManager.stop();
            }
            if (Platform.isRunning()) {
                this.getPreferenceStore().removePropertyChangeListener(this.PROPERTY_LISTENER);
                if (PlatformUI.getWorkbench() != null && !PlatformUI.getWorkbench().isClosing()) {
                    PlatformUI.getWorkbench().removeWindowListener(this.WINDOW_LISTENER);
                    for (IWorkbenchWindow window : this.monitoredWindows) {
                        this.removeListenersFromWindow(window);
                    }
                }
            }
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, ID_PLUGIN, "Monitor UI stop failed", (Throwable)e));
        }
        INSTANCE = null;
    }

    public void addWindowPartListener(IPartListener listener) {
        this.partListeners.add(listener);
        for (IWorkbenchWindow window : this.monitoredWindows) {
            window.getPartService().addPartListener(listener);
        }
    }

    public void removeWindowPartListener(IPartListener listener) {
        this.partListeners.remove(listener);
        for (IWorkbenchWindow window : this.monitoredWindows) {
            window.getPartService().removePartListener(listener);
        }
    }

    public void addWindowPageListener(IPageListener listener) {
        this.pageListeners.add(listener);
        for (IWorkbenchWindow window : this.monitoredWindows) {
            window.addPageListener(listener);
        }
    }

    public void removeWindowPageListener(IPageListener listener) {
        this.pageListeners.remove(listener);
        for (IWorkbenchWindow window : this.monitoredWindows) {
            window.removePageListener(listener);
        }
    }

    public void addWindowPerspectiveListener(IPerspectiveListener listener) {
        this.perspectiveListeners.add(listener);
        for (IWorkbenchWindow window : this.monitoredWindows) {
            window.addPerspectiveListener(listener);
        }
    }

    public void removeWindowPerspectiveListener(IPerspectiveListener listener) {
        this.perspectiveListeners.remove(listener);
        for (IWorkbenchWindow window : this.monitoredWindows) {
            window.removePerspectiveListener(listener);
        }
    }

    public void addWindowPostSelectionListener(ISelectionListener listener) {
        this.postSelectionListeners.add(listener);
        for (IWorkbenchWindow window : this.monitoredWindows) {
            ISelectionService service = window.getSelectionService();
            service.addPostSelectionListener(listener);
        }
    }

    public void removeWindowPostSelectionListener(ISelectionListener listener) {
        MonitorUiPlugin.getDefault().postSelectionListeners.remove(listener);
        for (IWorkbenchWindow window : this.monitoredWindows) {
            ISelectionService service = window.getSelectionService();
            service.removePostSelectionListener(listener);
        }
    }

    public static MonitorUiPlugin getDefault() {
        return INSTANCE;
    }

    public List<AbstractUserInteractionMonitor> getSelectionMonitors() {
        return this.selectionMonitors;
    }

    public void addInteractionListener(IInteractionEventListener listener) {
        this.interactionListeners.add(listener);
    }

    public void removeInteractionListener(IInteractionEventListener listener) {
        this.interactionListeners.remove(listener);
    }

    public void notifyInteractionObserved(InteractionEvent interactionEvent) {
        for (IInteractionEventListener listener : this.interactionListeners) {
            listener.interactionObserved(interactionEvent);
        }
    }

    public List<IInteractionEventListener> getInteractionListeners() {
        return this.interactionListeners;
    }

    public ActivityContextManager getActivityContextManager() {
        return this.activityContextManager;
    }

    public boolean suppressConfigurationWizards() {
        List<String> commandLineArgs = Arrays.asList(Platform.getCommandLineArgs());
        if (commandLineArgs.contains("-showMylynWizards")) {
            return false;
        }
        return commandLineArgs.contains("-pdelaunch");
    }

    private void removeListenersFromWindow(IWorkbenchWindow window) {
        for (IPageListener iPageListener : this.pageListeners) {
            window.removePageListener(iPageListener);
        }
        for (IPartListener iPartListener : this.partListeners) {
            window.getPartService().removePartListener(iPartListener);
        }
        for (IPerspectiveListener iPerspectiveListener : this.perspectiveListeners) {
            window.removePerspectiveListener(iPerspectiveListener);
        }
        for (ISelectionListener iSelectionListener : this.postSelectionListeners) {
            window.getSelectionService().removePostSelectionListener(iSelectionListener);
        }
        this.monitoredWindows.remove(window);
    }

    private void addListenersToWindow(IWorkbenchWindow window) {
        for (IPageListener iPageListener : this.pageListeners) {
            window.addPageListener(iPageListener);
        }
        for (IPartListener iPartListener : this.partListeners) {
            window.getPartService().addPartListener(iPartListener);
        }
        for (IPerspectiveListener iPerspectiveListener : this.perspectiveListeners) {
            window.addPerspectiveListener(iPerspectiveListener);
        }
        for (ISelectionListener iSelectionListener : this.postSelectionListeners) {
            window.getSelectionService().addPostSelectionListener(iSelectionListener);
        }
        this.monitoredWindows.add(window);
    }

    public Set<IWorkbenchWindow> getMonitoredWindows() {
        return this.monitoredWindows;
    }

    public IWorkbenchWindow getLaunchingWorkbenchWindow() {
        return this.launchingWorkbenchWindow;
    }

    private void init() {
        try {
            PlatformUI.getWorkbench().addWindowListener(this.WINDOW_LISTENER);
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (windows.length > 0) {
                this.launchingWorkbenchWindow = windows[0];
            }
            IWorkbenchWindow[] iWorkbenchWindowArray = windows;
            int n = windows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                this.addListenersToWindow(window);
                ++n2;
            }
            MonitorUiExtensionPointReader.initExtensions(this.monitors);
            this.monitors.add(new WorkbenchUserActivityMonitor());
            this.activityContextManager.init(this.monitors);
            this.updateActivityTimout();
            this.activityContextManager.start();
            this.setActivityTrackingEnabled(this.getPreferenceStore().getBoolean(ACTIVITY_TRACKING_ENABLED));
            this.getPreferenceStore().addPropertyChangeListener(this.PROPERTY_LISTENER);
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, ID_PLUGIN, "Monitor UI start failed", (Throwable)e));
        }
    }

    private void updateActivityTimout() {
        if (this.getPreferenceStore().getBoolean("org.eclipse.mylyn.monitor.ui.activity.timeout.enabled")) {
            this.activityContextManager.setInactivityTimeout(this.getPreferenceStore().getInt("org.eclipse.mylyn.monitor.ui.activity.timeout"));
        } else {
            this.activityContextManager.setInactivityTimeout(0);
        }
    }

    public void setActivityTrackingEnabled(boolean b) {
        this.activityTrackingEnabled = b;
    }

    public boolean isActivityTrackingEnabled() {
        return this.activityTrackingEnabled;
    }

    public boolean isTrackingOsTime() {
        return this.monitors.size() > 1;
    }

    static class MonitorUiExtensionPointReader {
        private static final String EXTENSION_ID_USER = "user";
        private static final String ELEMENT_ACTIVITY_TIMER = "osActivityTimer";
        private static boolean extensionsRead = false;

        MonitorUiExtensionPointReader() {
        }

        private static void initExtensions(Collection<AbstractUserActivityMonitor> monitors) {
            if (!extensionsRead) {
                ExtensionPointReader reader = new ExtensionPointReader(MonitorUiPlugin.ID_PLUGIN, EXTENSION_ID_USER, ELEMENT_ACTIVITY_TIMER, AbstractUserActivityMonitor.class);
                reader.read();
                List items = reader.getItems();
                Collections.reverse(items);
                monitors.addAll(items);
                extensionsRead = true;
            }
        }
    }
}

