/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.IBuildElement;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.core.spi.GetBuildsRequest;
import org.eclipse.mylyn.builds.internal.core.operations.GetBuildsOperation;
import org.eclipse.mylyn.builds.internal.core.operations.OperationChangeListener;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.workbench.EditorHandle;
import org.eclipse.mylyn.internal.builds.ui.BuildsUiInternal;
import org.eclipse.mylyn.internal.builds.ui.editor.BuildEditorInput;
import org.eclipse.mylyn.internal.builds.ui.editor.RefreshBuildEditorOperationListener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenHandler
extends AbstractHandler {
    public static EditorHandle fetchAndOpen(IWorkbenchPage page, IBuild build) {
        EditorHandle handle = new EditorHandle();
        OpenHandler.openEditor(page, handle, build, true);
        String label = build.getLabel();
        GetBuildsRequest request = new GetBuildsRequest(build.getPlan(), Collections.singletonList(label), GetBuildsRequest.Scope.FULL);
        GetBuildsOperation operation = BuildsUiInternal.getFactory().getGetBuildsOperation(request);
        operation.addOperationChangeListener((OperationChangeListener)new RefreshBuildEditorOperationListener(build, handle));
        operation.execute();
        return handle;
    }

    protected static void openEditor(IWorkbenchPage page, EditorHandle handle, IBuild build, boolean partial) {
        BuildEditorInput input = new BuildEditorInput(build, partial);
        try {
            IEditorPart part = page.openEditor((IEditorInput)input, "org.eclipse.mylyn.builds.ui.editors.Build");
            handle.setPart((IWorkbenchPart)part);
            handle.setStatus(Status.OK_STATUS);
        }
        catch (PartInitException e) {
            Status status = new Status(4, "org.eclipse.mylyn.builds.ui", "Unexpected error while opening build", (Throwable)e);
            StatusHandler.log((IStatus)status);
            handle.setStatus((IStatus)status);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static List<EditorHandle> open(IWorkbenchPage page, List<? extends IBuildElement> elements) {
        ArrayList<EditorHandle> handles = new ArrayList<EditorHandle>();
        for (IBuildElement iBuildElement : elements) {
            EditorHandle handle;
            IBuildElement openElement = null;
            IBuildElement iBuildElement2 = iBuildElement;
            if (iBuildElement2 instanceof IBuildPlan) {
                void plan;
                IBuildPlan cfr_ignored_0 = (IBuildPlan)iBuildElement2;
                IBuildPlan cfr_ignored_1 = (IBuildPlan)iBuildElement2;
                if (plan.getLastBuild() != null) {
                    openElement = plan.getLastBuild();
                }
            }
            if (openElement == null) {
                openElement = iBuildElement;
            }
            if (openElement instanceof IBuild && OpenHandler.isPartial((IBuild)openElement)) {
                handle = OpenHandler.fetchAndOpen(page, (IBuild)openElement);
                handles.add(handle);
                continue;
            }
            handle = OpenHandler.openInEditor(page, openElement);
            handles.add(handle);
        }
        return handles;
    }

    public static EditorHandle openInEditor(IWorkbenchPage page, IBuildElement item) {
        BuildEditorInput input = null;
        if (item instanceof IBuild) {
            input = new BuildEditorInput((IBuild)item);
        }
        if (input != null) {
            try {
                IEditorPart part = page.openEditor((IEditorInput)input, "org.eclipse.mylyn.builds.ui.editors.Build");
                EditorHandle handle = new EditorHandle(Status.OK_STATUS);
                handle.setPart((IWorkbenchPart)part);
                return handle;
            }
            catch (PartInitException e) {
                Status status = new Status(4, "org.eclipse.mylyn.builds.ui", "Unexpected error while opening build", (Throwable)e);
                StatusHandler.log((IStatus)status);
                EditorHandle handle = new EditorHandle((IStatus)status);
                return handle;
            }
        }
        Status status = new Status(4, "org.eclipse.mylyn.builds.ui", "No editor available to open " + String.valueOf(item));
        return new EditorHandle((IStatus)status);
    }

    private static boolean isPartial(IBuild element) {
        return element.getName() == null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            throw new ExecutionException("No active workbench window");
        }
        List<IBuildElement> elements = BuildsUiInternal.getElements(event);
        OpenHandler.open(page, elements);
        return null;
    }
}

