/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.commands;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.IBuildElement;
import org.eclipse.mylyn.commons.ui.ClipboardCopier;
import org.eclipse.mylyn.internal.builds.ui.BuildsUiInternal;
import org.eclipse.mylyn.internal.builds.ui.commands.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.handlers.HandlerUtil;

public class CopyDetailsHandler
extends AbstractHandler {
    public static void copyDetails(List<IBuildElement> elements, Mode mode) {
        ClipboardCopier.getDefault().copy(elements, element -> CopyDetailsHandler.getTextFor(element, mode));
    }

    public static String getTextFor(Object object) {
        return CopyDetailsHandler.getTextFor(object, Mode.SUMMARY_URL);
    }

    /*
     * WARNING - void declaration
     */
    public static String getTextFor(Object object, Mode mode) {
        StringBuilder sb = new StringBuilder();
        switch (mode) {
            case KEY: {
                void element;
                Object object2 = object;
                if (object2 instanceof IBuild) {
                    void build;
                    IBuild iBuild = (IBuild)object2;
                    IBuild cfr_ignored_0 = (IBuild)object2;
                    if (build.getId() == null) break;
                    sb.append(build.getId());
                    break;
                }
                Object object3 = object;
                if (!(object3 instanceof IBuildElement)) break;
                IBuildElement iBuildElement = (IBuildElement)object3;
                IBuildElement cfr_ignored_1 = (IBuildElement)object3;
                sb.append(element.getLabel());
                break;
            }
            case URL: {
                void element;
                Object object4 = object;
                if (!(object4 instanceof IBuildElement)) break;
                IBuildElement iBuildElement = (IBuildElement)object4;
                IBuildElement cfr_ignored_2 = (IBuildElement)object4;
                if (element.getUrl() == null) break;
                sb.append(element.getUrl());
                break;
            }
            case SUMMARY: {
                void element;
                Object object5 = object;
                if (object5 instanceof IBuild) {
                    void build;
                    IBuild iBuild = (IBuild)object5;
                    IBuild cfr_ignored_3 = (IBuild)object5;
                    if (build.getLabel() == null) break;
                    sb.append(NLS.bind((String)Messages.CopyDetailsHandler_buildLabel, (Object)build.getLabel()));
                    break;
                }
                Object object6 = object;
                if (!(object6 instanceof IBuildElement)) break;
                IBuildElement iBuildElement = (IBuildElement)object6;
                IBuildElement cfr_ignored_4 = (IBuildElement)object6;
                sb.append(element.getLabel());
                break;
            }
            case SUMMARY_URL: {
                void element;
                Object object7 = object;
                if (!(object7 instanceof IBuildElement)) break;
                IBuildElement iBuildElement = (IBuildElement)object7;
                IBuildElement cfr_ignored_5 = (IBuildElement)object7;
                Object object8 = object;
                if (object8 instanceof IBuild) {
                    void build;
                    IBuild iBuild = (IBuild)object8;
                    IBuild cfr_ignored_6 = (IBuild)object8;
                    if (build.getLabel() != null) {
                        sb.append(NLS.bind((String)Messages.CopyDetailsHandler_buildLabel, (Object)build.getLabel()));
                    }
                }
                sb.append(element.getLabel());
                if (!TasksUiInternal.isValidUrl((String)element.getUrl())) break;
                sb.append(ClipboardCopier.LINE_SEPARATOR);
                sb.append(element.getUrl());
            }
        }
        return sb.toString();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            Mode mode = Mode.SUMMARY;
            String kind = event.getParameter("kind");
            if (kind != null) {
                try {
                    mode = Mode.valueOf(kind);
                }
                catch (IllegalArgumentException e) {
                    throw new ExecutionException(NLS.bind((String)Messages.CopyDetailsHandler_invalidKindSpecified, (Object)kind));
                }
            }
            CopyDetailsHandler.copyDetails(BuildsUiInternal.getElements(event), mode);
        }
        return null;
    }

    public static enum Mode {
        KEY,
        SUMMARY,
        SUMMARY_URL,
        URL;


        public String toString() {
            return switch (this) {
                case KEY -> Messages.CopyDetailsHandler_id;
                case URL -> Messages.CopyDetailsHandler_url;
                case SUMMARY -> Messages.CopyDetailsHandler_summary;
                case SUMMARY_URL -> Messages.CopyDetailsHandler_summaryAndUrl;
                default -> null;
            };
        }
    }
}

