/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaTaskDataHandler;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorPeoplePart;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.LayoutHint;

public class BugzillaPeoplePart
extends TaskEditorPeoplePart {
    private static final int COLUMN_MARGIN = 5;

    protected Collection<TaskAttribute> getAttributes() {
        Map allAttributes = this.getTaskData().getRoot().getAttributes();
        ArrayList<TaskAttribute> attributes = new ArrayList<TaskAttribute>(allAttributes.size());
        attributes.add(this.getTaskData().getRoot().getMappedAttribute("task.common.user.assigned"));
        TaskAttribute assignee = this.getTaskData().getRoot().getAttribute(BugzillaAttribute.SET_DEFAULT_ASSIGNEE.getKey());
        if (assignee != null) {
            attributes.add(assignee);
        }
        attributes.add(this.getTaskData().getRoot().getMappedAttribute("task.common.user.reporter"));
        String useQaContact = this.getTaskData().getAttributeMapper().getTaskRepository().getProperty("bugzilla.param.useqacontact");
        if (useQaContact == null || Boolean.parseBoolean(useQaContact)) {
            attributes.add(this.getTaskData().getRoot().getMappedAttribute(BugzillaAttribute.QA_CONTACT.getKey()));
        }
        attributes.add(this.getTaskData().getRoot().getMappedAttribute(BugzillaAttribute.NEWCC.getKey()));
        if (!this.getTaskData().isNew()) {
            this.addSelfToCC(attributes);
        }
        attributes.add(this.getTaskData().getRoot().getMappedAttribute(BugzillaAttribute.CC.getKey()));
        for (TaskAttribute attribute : allAttributes.values()) {
            if (!"person".equals(attribute.getMetaData().getType()) || attribute.getId().endsWith("_name") || attribute.getId().equals(BugzillaAttribute.EXPORTER_NAME.getKey()) || attributes.contains(attribute)) continue;
            attributes.add(attribute);
        }
        return attributes;
    }

    protected void addSelfToCC(Collection<TaskAttribute> attributes) {
        TaskRepository repository = this.getTaskEditorPage().getTaskRepository();
        if (repository.getUserName() == null) {
            return;
        }
        TaskAttribute root = this.getTaskData().getRoot();
        TaskAttribute owner = root.getMappedAttribute("task.common.user.assigned");
        if (owner != null && owner.getValue().indexOf(repository.getUserName()) != -1) {
            return;
        }
        TaskAttribute reporter = root.getMappedAttribute("task.common.user.reporter");
        if (reporter != null && reporter.getValue().indexOf(repository.getUserName()) != -1) {
            return;
        }
        TaskAttribute ccAttribute = root.getMappedAttribute("task.common.user.cc");
        if (ccAttribute != null && ccAttribute.getValues().contains(repository.getUserName())) {
            return;
        }
        TaskAttribute attrAddToCC = this.getTaskData().getRoot().getMappedAttribute("task.common.addselfcc");
        if (attrAddToCC == null) {
            attrAddToCC = BugzillaTaskDataHandler.createAttribute((TaskData)this.getTaskData(), (BugzillaAttribute)BugzillaAttribute.ADDSELFCC);
        }
        attributes.add(attrAddToCC);
    }

    protected GridDataFactory createLayoutData(AbstractAttributeEditor editor) {
        LayoutHint layoutHint = editor.getLayoutHint();
        GridDataFactory gridDataFactory = GridDataFactory.fillDefaults().indent(3, 0);
        if (layoutHint != null && layoutHint.rowSpan == LayoutHint.RowSpan.MULTIPLE) {
            gridDataFactory.grab(true, true).align(4, 4).hint(130, 95);
        } else {
            gridDataFactory.grab(true, false).align(4, 128);
        }
        return gridDataFactory;
    }
}

