/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.connector;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.internal.MavenArtifactIdentifier;
import org.eclipse.m2e.core.internal.markers.IMavenMarkerManager;
import org.eclipse.m2e.core.internal.markers.MavenProblemInfo;
import org.eclipse.m2e.core.internal.markers.SourceLocation;
import org.eclipse.m2e.core.internal.markers.SourceLocationHelper;
import org.eclipse.m2e.core.lifecyclemapping.model.IPluginExecutionMetadata;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.configurator.AbstractBuildParticipant;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ILifecycleMappingConfiguration;
import org.eclipse.m2e.core.project.configurator.MojoExecutionBuildParticipant;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.m2e.jdt.IClasspathDescriptor;
import org.eclipse.m2e.jdt.IJavaProjectConfigurator;
import org.eclipse.m2e.pde.connector.PDEProjectHelper;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.osgi.framework.BundleException;

public class PDEMavenBundlePluginConfigurator
extends AbstractProjectConfigurator
implements IJavaProjectConfigurator {
    private static final String FELIX_PARAM_MANIFESTLOCATION = "manifestLocation";
    private static final String FELIX_PARAM_SUPPORTINCREMENTALBUILD = "supportIncrementalBuild";
    private static final String FELIX_MANIFEST_GOAL = "manifest";
    private static final String BND_PARAM_MANIFESTLOCATION = "manifestPath";
    private static final List<String> BND_MANIFEST_GOALS = List.of("bnd-process", "bnd-process-tests", "jar", "test-jar");

    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        List executions = this.getMojoExecutions(request, monitor);
        boolean hasManifestExecution = false;
        for (MojoExecution execution : executions) {
            Plugin plugin = execution.getPlugin();
            if (this.isFelix(plugin)) {
                if (!this.isFelixManifestGoal(execution)) continue;
                IMaven maven = MavenPlugin.getMaven();
                Boolean supportIncremental = (Boolean)maven.getMojoParameterValue(request.mavenProject(), execution, FELIX_PARAM_SUPPORTINCREMENTALBUILD, Boolean.class, monitor);
                if (supportIncremental == null || !supportIncremental.booleanValue()) {
                    this.createWarningMarker(request, execution, "configuration", "Incremental updates are currently disabled, set supportIncrementalBuild=true to support automatic manifest updates for this project.");
                }
                hasManifestExecution = true;
                continue;
            }
            if (!this.isBND(plugin) || !this.isBNDBundleGoal(execution)) continue;
            hasManifestExecution = true;
        }
        if (!hasManifestExecution && !executions.isEmpty()) {
            MojoExecution execution;
            execution = (MojoExecution)executions.get(0);
            this.createWarningMarker(request, execution, "executions", "There is currently no execution that generates a manifest, consider adding an execution for one of the following goal: " + (this.isFelix(execution.getPlugin()) ? FELIX_MANIFEST_GOAL : BND_MANIFEST_GOALS) + ".");
        }
        IMavenProjectFacade facade = request.mavenProjectFacade();
        IPath metainfPath = this.getMetainfPath(facade, executions, monitor);
        PDEProjectHelper.addPDENature(facade.getProject(), metainfPath, monitor);
    }

    private void createWarningMarker(ProjectConfigurationRequest request, MojoExecution execution, String attribute, String message) {
        PDEMavenBundlePluginConfigurator.createWarningMarker(this.projectManager, this.markerManager, request, execution, attribute, message);
    }

    static void createWarningMarker(IMavenProjectRegistry projectManager, IMavenMarkerManager markerManager, ProjectConfigurationRequest request, MojoExecution execution, String attribute, String message) {
        SourceLocation location = SourceLocationHelper.findLocation((Plugin)execution.getPlugin(), (String)attribute);
        String[] gav = location.getResourceId().split(":");
        IMavenProjectFacade facade = projectManager.getMavenProject(gav[0], gav[1], gav[2]);
        if (facade == null) {
            location = SourceLocationHelper.findLocation((MavenProject)request.mavenProject(), (MojoExecutionKey)new MojoExecutionKey(execution));
            facade = request.mavenProjectFacade();
        }
        MavenProblemInfo problem = new MavenProblemInfo(message, 1, location);
        markerManager.addErrorMarker((IResource)facade.getPom(), "org.eclipse.m2e.core.maven2Problem.lifecycleMapping", problem);
    }

    private boolean isFelixManifestGoal(MojoExecution execution) {
        return FELIX_MANIFEST_GOAL.equals(execution.getGoal());
    }

    private boolean isBNDBundleGoal(MojoExecution execution) {
        return BND_MANIFEST_GOALS.contains(execution.getGoal());
    }

    public void configureClasspath(IMavenProjectFacade facade, IClasspathDescriptor classpath, IProgressMonitor monitor) throws CoreException {
    }

    public void configureRawClasspath(ProjectConfigurationRequest request, IClasspathDescriptor classpath, IProgressMonitor monitor) throws CoreException {
    }

    private IPath getMetainfPath(IMavenProjectFacade facade, List<MojoExecution> executions, IProgressMonitor monitor) throws CoreException {
        IMaven maven = MavenPlugin.getMaven();
        for (MojoExecution execution : executions) {
            String manifestParameter;
            Plugin plugin = execution.getPlugin();
            MavenProject project = facade.getMavenProject(monitor);
            File location = (File)maven.getMojoParameterValue(project, execution, manifestParameter = this.isBND(plugin) ? BND_PARAM_MANIFESTLOCATION : FELIX_PARAM_MANIFESTLOCATION, File.class, monitor);
            if (location == null) continue;
            return facade.getProjectRelativePath(location.getAbsolutePath());
        }
        return null;
    }

    private boolean isBND(Plugin plugin) {
        return plugin != null && "bnd-maven-plugin".equals(plugin.getArtifactId());
    }

    private boolean isFelix(Plugin plugin) {
        return plugin != null && "org.apache.felix".equals(plugin.getGroupId()) && "maven-bundle-plugin".equals(plugin.getArtifactId());
    }

    public boolean hasConfigurationChanged(IMavenProjectFacade newFacade, ILifecycleMappingConfiguration oldProjectConfiguration, MojoExecutionKey key, IProgressMonitor monitor) {
        return false;
    }

    public AbstractBuildParticipant getBuildParticipant(IMavenProjectFacade projectFacade, MojoExecution execution, IPluginExecutionMetadata executionMetadata) {
        Plugin plugin = execution.getPlugin();
        if (this.isFelix(plugin) && this.isFelixManifestGoal(execution) || this.isBND(plugin) && this.isBNDBundleGoal(execution)) {
            return new ClasspathSynchronizer(execution, true, true);
        }
        return null;
    }

    private static final class ClasspathSynchronizer
    extends MojoExecutionBuildParticipant {
        public ClasspathSynchronizer(MojoExecution execution, boolean runOnIncremental, boolean runOnConfiguration) {
            super(execution, runOnIncremental, runOnConfiguration);
        }

        public Set<IProject> build(int kind, IProgressMonitor monitor) throws Exception {
            if (!this.appliesToBuildKind(kind)) {
                return null;
            }
            Set buildProjects = super.build(kind, monitor);
            IProject project = this.getMavenProjectFacade().getProject();
            Path manifest = Path.of(PDEProject.getManifest((IProject)project).getLocationURI());
            if (!Files.isRegularFile(manifest, new LinkOption[0])) {
                return buildProjects;
            }
            this.getBuildContext().refresh(manifest.toFile());
            List<ManifestElement> bundleClassPath = this.getBundleClassPathEntries(manifest);
            IJavaProject javaProject = JavaCore.create((IProject)project);
            Set<IPath> bundleClasspathJars = this.getBundleClassPathJars(bundleClassPath, javaProject, monitor);
            if (!bundleClasspathJars.isEmpty()) {
                ArrayList<IClasspathEntry> rawClasspath = new ArrayList<IClasspathEntry>(Arrays.asList(javaProject.getRawClasspath()));
                HashSet existingLibraryPaths = new HashSet();
                int sizeBefore = rawClasspath.size();
                rawClasspath.removeIf(entry -> {
                    if (entry.getEntryKind() == 1) {
                        existingLibraryPaths.add(entry.getPath());
                        return !bundleClasspathJars.contains(entry.getPath()) && ClasspathSynchronizer.isPomDerived(entry);
                    }
                    return false;
                });
                boolean changed = sizeBefore != rawClasspath.size();
                for (IPath jarPath : bundleClasspathJars) {
                    if (existingLibraryPaths.contains(jarPath)) continue;
                    rawClasspath.add(ClasspathSynchronizer.createLibraryEntry(jarPath, monitor));
                    changed = true;
                }
                if (changed) {
                    javaProject.setRawClasspath((IClasspathEntry[])rawClasspath.toArray(IClasspathEntry[]::new), monitor);
                }
            }
            return buildProjects;
        }

        private List<ManifestElement> getBundleClassPathEntries(Path manifest) throws IOException, BundleException {
            Throwable throwable = null;
            Object var3_4 = null;
            try (InputStream input = Files.newInputStream(manifest, new OpenOption[0]);){
                Map headers = ManifestElement.parseBundleManifest((InputStream)input, null);
                String bcpEntries = (String)headers.get("Bundle-ClassPath");
                ManifestElement[] elements = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)bcpEntries);
                List<Object> list = elements != null ? List.of(elements) : List.of();
                return list;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        private Set<IPath> getBundleClassPathJars(List<ManifestElement> bundleClassPath, IJavaProject javaProject, IProgressMonitor monitor) throws IOException, CoreException {
            Path bundleRoot;
            IProject project = javaProject.getProject();
            IContainer bundleRootContainer = PDEProject.getBundleRoot((IProject)project);
            Path bcpContainer = bundleRoot = Path.of(bundleRootContainer.getLocationURI());
            IPath bcpContainerPath = bundleRootContainer.getFullPath();
            if (javaProject.getOutputLocation().equals((Object)bundleRootContainer.getFullPath())) {
                Path buildDirectory = Path.of(this.getMavenProjectFacade().getMavenProject().getBuild().getDirectory(), new String[0]);
                bcpContainer = buildDirectory.resolve("m2e-bundleClassPath");
                Path relativeBCPContainerPath = Path.of(project.getLocationURI()).relativize(bcpContainer);
                bcpContainerPath = project.getFolder(relativeBCPContainerPath.toString()).getFullPath();
            }
            IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
            LinkedHashSet<IPath> bundleClasspathJars = new LinkedHashSet<IPath>();
            for (ManifestElement entry : bundleClassPath) {
                String path = entry.getValueComponents()[0];
                Path jar = bundleRoot.resolve(path);
                if (!path.endsWith(".jar") || !Files.exists(jar, new LinkOption[0])) continue;
                Path referencedJar = bcpContainer.resolve(path);
                IPath jarPath = bcpContainerPath.append(path);
                if (!Files.exists(referencedJar, new LinkOption[0])) {
                    Files.createDirectories(referencedJar.getParent(), new FileAttribute[0]);
                    Files.copy(jar, referencedJar, new CopyOption[0]);
                    wsRoot.getFile(jarPath).refreshLocal(0, monitor);
                }
                bundleClasspathJars.add(jarPath);
            }
            return bundleClasspathJars;
        }

        private static boolean isPomDerived(IClasspathEntry entry) {
            return Arrays.stream(entry.getExtraAttributes()).anyMatch(a -> a.getName().equals("maven.pomderived") && Boolean.parseBoolean(a.getValue()));
        }

        private static IClasspathEntry createLibraryEntry(IPath libPath, IProgressMonitor monitor) {
            IClasspathAttribute[] attributes = new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"maven.pomderived", (String)Boolean.toString(true))};
            IFile libFile = ResourcesPlugin.getWorkspace().getRoot().getFile(libPath);
            Collection artifacts = MavenArtifactIdentifier.identify((File)libFile.getLocation().toFile());
            IPath sourcePath = artifacts.stream().map(a -> MavenArtifactIdentifier.resolveSourceLocation((ArtifactKey)a, (IProgressMonitor)monitor)).filter(Objects::nonNull).map(Path::toString).map(IPath::fromOSString).findFirst().orElse(null);
            return JavaCore.newLibraryEntry((IPath)libPath, (IPath)sourcePath, null, null, (IClasspathAttribute[])attributes, (boolean)true);
        }
    }
}

