/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.preferences;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDEPlugin;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.preferences.IDEPreferenceConstants;
import org.eclipse.linuxtools.tools.launch.core.factory.RuntimeProcessFactory;

public class PreferenceInitializer
extends AbstractPreferenceInitializer {
    private static final String[] KERNEL_SOURCE_PATH = new String[]{"/usr/src/kernels/{kernel_version}", "/usr/src/linux", "/usr/src/linux-{kernel_version}"};

    public void initializeDefaultPreferences() {
        int i;
        IPreferenceStore store = IDEPlugin.getDefault().getPreferenceStore();
        store.setDefault("UseStoredTreePreference", false);
        store.setDefault("RemoteProbes", false);
        store.setDefault("KernelSourcePreference", this.getKernelSourceLocation());
        store.setDefault("ExcludedKernelSource", "CVS/" + File.pathSeparator + ".svn/" + File.pathSeparator + "{arch}/" + File.pathSeparator + ".arch-ids/" + File.pathSeparator + ".bzr/" + File.pathSeparator + "debian/" + File.pathSeparator + ".git/");
        store.setDefault("RemoteLocalKernelSource", "local");
        store.setDefault("TapsetPreference", "");
        for (i = 0; i < IDEPreferenceConstants.STAP_BOOLEAN_OPTIONS.length; ++i) {
            store.setDefault(IDEPreferenceConstants.STAP_BOOLEAN_OPTIONS[i][2], false);
        }
        for (i = 0; i < IDEPreferenceConstants.STAP_STRING_OPTIONS.length; ++i) {
            store.setDefault(IDEPreferenceConstants.STAP_STRING_OPTIONS[i][2], "");
        }
    }

    private String getKernelSourceLocation() {
        String version = "";
        try {
            Process process = RuntimeProcessFactory.getFactory().exec("uname -r", null, null);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            version = reader.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (String path : KERNEL_SOURCE_PATH) {
            File file = new File((path = path.replace("{kernel_version}", version)) + "/System.map");
            if (!file.exists()) continue;
            return path;
        }
        return "";
    }
}

