/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.core.ContainerFileProxy;
import org.eclipse.linuxtools.internal.docker.ui.CheckboxTreeAndListGroup;
import org.eclipse.linuxtools.internal.docker.ui.MinimizedFileSystemElement;
import org.eclipse.linuxtools.internal.docker.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.model.WorkbenchViewerComparator;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

public class ContainerCopyFromPage
extends WizardPage {
    private static final String NAME = "ContainerCopyFrom.name";
    private static final String TITLE = "ContainerCopyFrom.title";
    private static final String DESC = "ContainerCopyFrom.desc";
    private static final String TARGET_LABEL = "ContainerCopyFrom.target.label";
    private static final String TARGET_TOOLTIP = "ContainerCopyFrom.target.tooltip";
    private static final String SOURCE_LABEL = "ContainerCopyFrom.source.label";
    private static final String SOURCE_TOOLTIP = "ContainerCopyFrom.source.tooltip";
    private static final String NO_TARGET_SPECIFIED = "ContainerCopyFrom.notarget.error";
    private static final String NO_SOURCE_SPECIFIED = "ContainerCopyFrom.nosource.error";
    private static final String BROWSE_LABEL = "ContainerCopyFrom.browse.label";
    private FileSystemElement root;
    private IImportStructureProvider structureProvider;
    private boolean canBrowseContainer;
    CheckboxTreeAndListGroup selectionGroup;
    private Text targetText;
    private Text sourceText;
    private Button browseButton;
    private String target;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 500;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 250;
    private static final int COLUMNS = 3;
    private ModifyListener Listener = e -> this.validate();
    private ICheckStateListener CheckListener = e -> this.validate();

    public ContainerCopyFromPage(FileSystemElement fileSystemElement, IImportStructureProvider structureProvider, String containerName, boolean canBrowseContainer) {
        super(WizardMessages.getString(NAME));
        this.setDescription(WizardMessages.getFormattedString(DESC, containerName));
        this.setTitle(WizardMessages.getString(TITLE));
        this.setImageDescriptor(SWTImagesFactory.DESC_WIZARD);
        this.root = fileSystemElement;
        this.structureProvider = structureProvider;
        this.canBrowseContainer = canBrowseContainer;
    }

    public String getTarget() {
        return this.target;
    }

    public Iterator getValueIterator() {
        if (this.canBrowseContainer) {
            return this.selectionGroup.getAllWhiteCheckedItems();
        }
        ArrayList<MinimizedFileSystemElement> out = new ArrayList<MinimizedFileSystemElement>();
        String sourceName = this.sourceText.getText();
        MinimizedFileSystemElement element = new MinimizedFileSystemElement(sourceName, null, false);
        element.setFileSystemObject(new ContainerFileProxy(sourceName, "", false));
        out.add(element);
        return out.iterator();
    }

    private void validate() {
        boolean complete = true;
        boolean error = false;
        if (this.targetText.getText().length() == 0) {
            error = true;
            this.setErrorMessage(WizardMessages.getString(NO_TARGET_SPECIFIED));
        } else {
            File f = new File(this.targetText.getText());
            if (!f.exists()) {
                error = true;
                this.setErrorMessage(WizardMessages.getString(NO_TARGET_SPECIFIED));
            }
        }
        if (!error) {
            if (this.canBrowseContainer) {
                if (this.selectionGroup.getCheckedElementCount() == 0) {
                    error = true;
                    this.setErrorMessage(WizardMessages.getString(NO_SOURCE_SPECIFIED));
                }
            } else if (this.sourceText.getText().length() == 0) {
                error = true;
                this.setErrorMessage(WizardMessages.getString(NO_SOURCE_SPECIFIED));
            }
        }
        if (!error) {
            this.target = this.targetText.getText();
            this.setErrorMessage(null);
        }
        this.setPageComplete(complete && !error);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).span(1, 1).grab(true, false).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(6, 6).applyTo(composite);
        Label targetLabel = new Label(composite, 0);
        targetLabel.setText(WizardMessages.getString(TARGET_LABEL));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(1, 1).grab(false, false).applyTo((Control)targetLabel);
        this.targetText = new Text(composite, 2052);
        this.targetText.addModifyListener(this.Listener);
        this.targetText.setToolTipText(WizardMessages.getString(TARGET_TOOLTIP));
        GridDataFactory.fillDefaults().align(4, 4).span(1, 1).grab(true, false).applyTo((Control)this.targetText);
        this.browseButton = new Button(composite, 0);
        this.browseButton.setText(WizardMessages.getString(BROWSE_LABEL));
        this.browseButton.addSelectionListener(this.onBrowseSelect());
        GridDataFactory.fillDefaults().align(0x1000008, 4).span(1, 1).grab(false, false).applyTo((Control)this.browseButton);
        FileSystemElement input = new FileSystemElement("", null, true);
        input.addChild(this.root);
        this.root.setParent(input);
        Composite selectionComposite = null;
        if (this.canBrowseContainer) {
            selectionComposite = new Composite(composite, 0);
            GridLayout selectionLayout = new GridLayout();
            selectionComposite.setLayout((Layout)selectionLayout);
            this.selectionGroup = new CheckboxTreeAndListGroup(selectionComposite, input, this.getFolderProvider(), this.getDynamicFolderProvider(), (ILabelProvider)new WorkbenchLabelProvider(), (IStructuredContentProvider)this.getFileProvider(), (ILabelProvider)new WorkbenchLabelProvider(), 0, 500, 250);
            GridDataFactory.fillDefaults().align(4, 4).span(3, 1).grab(true, false).applyTo((Control)selectionComposite);
        } else {
            Label sourceLabel = new Label(composite, 0);
            sourceLabel.setText(WizardMessages.getString(SOURCE_LABEL));
            GridDataFactory.fillDefaults().align(4, 0x1000000).span(1, 1).grab(false, false).applyTo((Control)sourceLabel);
            this.sourceText = new Text(composite, 2052);
            this.sourceText.addModifyListener(this.Listener);
            this.sourceText.setToolTipText(WizardMessages.getString(SOURCE_TOOLTIP));
            GridDataFactory.fillDefaults().align(4, 4).span(1, 1).grab(true, false).applyTo((Control)this.sourceText);
        }
        if (this.canBrowseContainer) {
            WorkbenchViewerComparator comparator = new WorkbenchViewerComparator();
            this.selectionGroup.setTreeComparator((ViewerComparator)comparator);
            this.selectionGroup.setListComparator((ViewerComparator)comparator);
            this.selectionGroup.addCheckStateListener(this.CheckListener);
        }
        this.setControl((Control)composite);
        this.validate();
        this.setPageComplete(false);
        if (this.canBrowseContainer) {
            this.selectionGroup.aboutToOpen();
        }
    }

    private SelectionListener onBrowseSelect() {
        ContainerCopyFromPage page = this;
        return SelectionListener.widgetSelectedAdapter(e -> {
            DirectoryDialog d = new DirectoryDialog(Activator.getActiveWorkbenchShell());
            String x = d.open();
            if (x != null) {
                page.targetText.setText(x);
            }
        });
    }

    private ITreeContentProvider getFileProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof FileSystemElement) {
                    return ((FileSystemElement)o).getFiles().getChildren(o);
                }
                return new Object[0];
            }
        };
    }

    private ITreeContentProvider getFolderProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof FileSystemElement) {
                    return ((FileSystemElement)o).getFolders().getChildren(o);
                }
                return new Object[0];
            }
        };
    }

    private ITreeContentProvider getDynamicFolderProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof MinimizedFileSystemElement) {
                    return ((MinimizedFileSystemElement)((Object)o)).getFolders(ContainerCopyFromPage.this.structureProvider).getChildren(o);
                }
                if (o instanceof FileSystemElement) {
                    return ((FileSystemElement)o).getFolders().getChildren(o);
                }
                return new Object[0];
            }
        };
    }
}

