/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.instantiation.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jem.internal.instantiation.InstantiationPackage;
import org.eclipse.jem.internal.instantiation.PTCharacterLiteral;
import org.eclipse.jem.internal.instantiation.ParseVisitor;
import org.eclipse.jem.internal.instantiation.impl.PTExpressionImpl;

public class PTCharacterLiteralImpl
extends PTExpressionImpl
implements PTCharacterLiteral {
    protected static final String ESCAPED_VALUE_EDEFAULT = null;
    protected String escapedValue = ESCAPED_VALUE_EDEFAULT;
    protected static final char CHAR_VALUE_EDEFAULT = '\u0000';
    protected char charValue = '\u0000';
    private boolean charValueSet;

    protected PTCharacterLiteralImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return InstantiationPackage.eINSTANCE.getPTCharacterLiteral();
    }

    @Override
    public String getEscapedValue() {
        return this.escapedValue;
    }

    @Override
    public void setEscapedValue(String newEscapedValue) {
        this.charValueSet = false;
        this.setCharValueGen('\u0000');
        this.setEscapedValueGen(newEscapedValue);
    }

    public void setEscapedValueGen(String newEscapedValue) {
        String oldEscapedValue = this.escapedValue;
        this.escapedValue = newEscapedValue;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldEscapedValue, (Object)this.escapedValue));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public char getCharValue() {
        if (this.charValueSet || this.escapedValue == ESCAPED_VALUE_EDEFAULT) return this.getCharValueGen();
        String s = this.getEscapedValue();
        int len = s.length();
        if (len < 2 || s.charAt(0) != '\'' || s.charAt(len - 1) != '\'') {
            throw new IllegalArgumentException();
        }
        char c = s.charAt(1);
        if (c == '\'') {
            throw new IllegalArgumentException();
        }
        if (c == '\\') {
            if (len == 4) {
                this.setCharValueGen(PTCharacterLiteralImpl.getCharEscaped(s.charAt(2)));
            } else {
                if (len != 8) throw new IllegalArgumentException("illegal character literal");
                int currentPosition = 2;
                int c1 = 0;
                int c2 = 0;
                int c3 = 0;
                int c4 = 0;
                if (s.charAt(currentPosition++) != 'u') throw new IllegalArgumentException("illegal character literal");
                if ((c1 = Character.getNumericValue(s.charAt(currentPosition++))) > 15 || c1 < 0 || (c2 = Character.getNumericValue(s.charAt(currentPosition++))) > 15 || c2 < 0 || (c3 = Character.getNumericValue(s.charAt(currentPosition++))) > 15 || c3 < 0 || (c4 = Character.getNumericValue(s.charAt(currentPosition++))) > 15 || c4 < 0) {
                    throw new IllegalArgumentException("illegal character literal");
                }
                this.setCharValueGen((char)(((c1 * 16 + c2) * 16 + c3) * 16 + c4));
            }
        } else {
            this.setCharValueGen(c);
        }
        this.charValueSet = true;
        return this.getCharValueGen();
    }

    public static char getCharEscaped(char nextChar) {
        switch (nextChar) {
            case 'b': {
                return '\b';
            }
            case 't': {
                return '\t';
            }
            case 'n': {
                return '\n';
            }
            case 'f': {
                return '\f';
            }
            case 'r': {
                return '\r';
            }
            case '\"': {
                return '\"';
            }
            case '\'': {
                return '\'';
            }
            case '\\': {
                return '\\';
            }
            case '0': {
                return '\u0000';
            }
            case '1': {
                return '\u0001';
            }
            case '2': {
                return '\u0002';
            }
            case '3': {
                return '\u0003';
            }
            case '4': {
                return '\u0004';
            }
            case '5': {
                return '\u0005';
            }
            case '6': {
                return '\u0006';
            }
            case '7': {
                return '\u0007';
            }
        }
        throw new IllegalArgumentException("illegal character");
    }

    public char getCharValueGen() {
        return this.charValue;
    }

    @Override
    public void setCharValue(char newCharValue) {
        this.charValueSet = true;
        this.setCharValueGen(newCharValue);
        StringBuffer b = new StringBuffer(8);
        b.append('\'');
        PTCharacterLiteralImpl.appendCharacter(newCharValue, b);
        b.append('\'');
        this.setEscapedValueGen(b.toString());
    }

    public static void appendCharacter(char character, StringBuffer b) {
        switch (character) {
            case '\b': {
                b.append("\\b");
                break;
            }
            case '\t': {
                b.append("\\t");
                break;
            }
            case '\n': {
                b.append("\\n");
                break;
            }
            case '\f': {
                b.append("\\f");
                break;
            }
            case '\r': {
                b.append("\\r");
                break;
            }
            case '\"': {
                b.append("\\\"");
                break;
            }
            case '\'': {
                b.append("\\'");
                break;
            }
            case '\\': {
                b.append("\\\\");
                break;
            }
            case '\u0000': {
                b.append("\\0");
                break;
            }
            case '\u0001': {
                b.append("\\1");
                break;
            }
            case '\u0002': {
                b.append("\\2");
                break;
            }
            case '\u0003': {
                b.append("\\3");
                break;
            }
            case '\u0004': {
                b.append("\\4");
                break;
            }
            case '\u0005': {
                b.append("\\5");
                break;
            }
            case '\u0006': {
                b.append("\\6");
                break;
            }
            case '\u0007': {
                b.append("\\7");
                break;
            }
            default: {
                b.append(character);
            }
        }
    }

    public void setCharValueGen(char newCharValue) {
        char oldCharValue = this.charValue;
        this.charValue = newCharValue;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, oldCharValue, this.charValue));
        }
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getEscapedValue();
            }
            case 1: {
                return new Character(this.getCharValue());
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setEscapedValue((String)newValue);
                return;
            }
            case 1: {
                this.setCharValue(((Character)newValue).charValue());
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setEscapedValue(ESCAPED_VALUE_EDEFAULT);
                return;
            }
            case 1: {
                this.setCharValue('\u0000');
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return ESCAPED_VALUE_EDEFAULT == null ? this.escapedValue != null : !ESCAPED_VALUE_EDEFAULT.equals(this.escapedValue);
            }
            case 1: {
                return this.charValue != '\u0000';
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    protected void accept0(ParseVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }
}

