/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.INumberBeanProxy;
import org.eclipse.jem.internal.proxy.remote.REMAbstractNumberBeanTypeProxy;
import org.eclipse.jem.internal.proxy.remote.REMLongClassBeanProxy;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;

final class REMLongClassBeanTypeProxy
extends REMAbstractNumberBeanTypeProxy {
    private final INumberBeanProxy zeroProxy;
    private final INumberBeanProxy oneProxy;
    private final INumberBeanProxy twoProxy;
    private final INumberBeanProxy threeProxy;

    REMLongClassBeanTypeProxy(REMProxyFactoryRegistry aRegistry, IBeanTypeProxy numberType) {
        super(aRegistry, new Integer(16), Long.class.getName(), numberType);
        this.zeroProxy = new REMLongClassBeanProxy(aRegistry, new Long(0L));
        this.oneProxy = new REMLongClassBeanProxy(aRegistry, new Long(1L));
        this.twoProxy = new REMLongClassBeanProxy(aRegistry, new Long(2L));
        this.threeProxy = new REMLongClassBeanProxy(aRegistry, new Long(3L));
    }

    INumberBeanProxy createLongBeanProxy(Long aLong) {
        if (aLong >= 0L && aLong < 4L) {
            switch (aLong.intValue()) {
                case 0: {
                    return this.zeroProxy;
                }
                case 1: {
                    return this.oneProxy;
                }
                case 2: {
                    return this.twoProxy;
                }
                case 3: {
                    return this.threeProxy;
                }
            }
        }
        return new REMLongClassBeanProxy(this.fRegistry, aLong);
    }

    @Override
    protected INumberBeanProxy createNumberBeanProxy(Number aNumber) {
        return this.createLongBeanProxy((Long)aNumber);
    }

    @Override
    public IBeanProxy newInstance() {
        return this.zeroProxy;
    }

    @Override
    public IBeanProxy newBeanProxy(Commands.ValueObject value) {
        return this.createLongBeanProxy(new Long(value.aLong));
    }
}

