/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.palette.editparts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutAnimator;
import org.eclipse.gef.internal.ui.palette.editparts.DrawerEditPart;
import org.eclipse.gef.internal.ui.palette.editparts.DrawerFigure;
import org.eclipse.gef.ui.palette.PaletteViewerPreferences;

public class PaletteAnimator
extends LayoutAnimator {
    private final List<DrawerFigure> drawers = new ArrayList<DrawerFigure>();
    private final PaletteViewerPreferences prefs;

    public PaletteAnimator(PaletteViewerPreferences prefs) {
        this.prefs = prefs;
    }

    public void addDrawer(DrawerEditPart drawer) {
        this.drawers.add(drawer.getFigure());
    }

    /*
     * WARNING - void declaration
     */
    protected void autoCollapse(DrawerFigure openDrawer) {
        int autoCollapseMode = this.prefs.getAutoCollapseSetting();
        if (autoCollapseMode == 1) {
            return;
        }
        if (autoCollapseMode == 2) {
            for (DrawerFigure drawer : this.drawers) {
                if (drawer == openDrawer) continue;
                drawer.setExpanded(false);
            }
            return;
        }
        int wHint = openDrawer.getParent().getClientArea().width;
        int availableHeight = openDrawer.getParent().getSize().height;
        int requiredHeight = 0;
        ArrayList<void> closable = new ArrayList<void>();
        for (IFigure sibling : openDrawer.getParent().getChildren()) {
            void drawer;
            int height = sibling.getPreferredSize((int)wHint, (int)-1).height;
            requiredHeight += height;
            IFigure iFigure = sibling;
            if (!(iFigure instanceof DrawerFigure)) continue;
            DrawerFigure cfr_ignored_0 = (DrawerFigure)iFigure;
            DrawerFigure cfr_ignored_1 = (DrawerFigure)iFigure;
            if (sibling == openDrawer || !drawer.isExpanded() || drawer.isPinnedOpen()) continue;
            closable.add(drawer);
        }
        int i = closable.size() - 1;
        while (i >= 0 && requiredHeight > availableHeight) {
            DrawerFigure drawer = (DrawerFigure)((Object)closable.get(i));
            int expandedHeight = drawer.getPreferredSize((int)wHint, (int)-1).height;
            drawer.setExpanded(false);
            int collapsedHeight = drawer.getPreferredSize((int)wHint, (int)-1).height;
            requiredHeight -= expandedHeight - collapsedHeight;
            --i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void playbackStarting(IFigure figure) {
        IFigure iFigure = figure;
        if (iFigure instanceof DrawerFigure) {
            void drawer;
            DrawerFigure drawerFigure = (DrawerFigure)iFigure;
            DrawerFigure cfr_ignored_0 = (DrawerFigure)iFigure;
            drawer.setAnimating(true);
        }
    }

    public void removeDrawer(DrawerEditPart drawer) {
        this.drawers.remove((Object)drawer.getFigure());
    }

    /*
     * WARNING - void declaration
     */
    public void init(IFigure figure) {
        IFigure iFigure = figure;
        if (iFigure instanceof DrawerFigure) {
            void drawer;
            DrawerFigure drawerFigure = (DrawerFigure)iFigure;
            DrawerFigure cfr_ignored_0 = (DrawerFigure)iFigure;
            if (drawer.isExpanded()) {
                this.autoCollapse((DrawerFigure)drawer);
            }
            return;
        }
        super.init(figure);
    }

    /*
     * WARNING - void declaration
     */
    public void tearDown(IFigure figure) {
        IFigure iFigure = figure;
        if (iFigure instanceof DrawerFigure) {
            void drawer;
            DrawerFigure drawerFigure = (DrawerFigure)iFigure;
            DrawerFigure cfr_ignored_0 = (DrawerFigure)iFigure;
            drawer.setAnimating(false);
        }
    }
}

