/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.parts;

import javafx.scene.Node;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeType;
import org.eclipse.gef.common.collections.ObservableSetMultimap;
import org.eclipse.gef.fx.nodes.Connection;
import org.eclipse.gef.geometry.euclidean.Angle;
import org.eclipse.gef.geometry.euclidean.Vector;
import org.eclipse.gef.geometry.planar.BezierCurve;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.mvc.fx.parts.AbstractSegmentHandlePart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;

public class RectangleSegmentHandlePart
extends AbstractSegmentHandlePart<Rectangle> {
    protected static final double DEFAULT_WIDTH = 4.0;
    protected static final double DEFAULT_LENGTH = 8.0;

    @Override
    protected Rectangle doCreateVisual() {
        Rectangle visual = new Rectangle();
        visual.setTranslateX(-4.0);
        visual.setTranslateY(-2.0);
        visual.setFill((Paint)this.getMoveFill());
        visual.setStroke((Paint)this.getStroke());
        visual.setWidth(8.0);
        visual.setHeight(4.0);
        visual.setStrokeWidth(1.0);
        visual.setStrokeType(StrokeType.OUTSIDE);
        return visual;
    }

    @Override
    public void doRefreshVisual(Rectangle visual) {
        super.doRefreshVisual(visual);
        this.updateColor();
    }

    protected void updateColor() {
        ObservableSetMultimap<IVisualPart<Node>, String> anchorages = this.getAnchoragesUnmodifiable();
        if (this.getRoot() == null || anchorages.keySet().size() != 1) {
            return;
        }
        Rectangle visual = (Rectangle)this.getVisual();
        if (!visual.isVisible()) {
            return;
        }
        if (this.getSegmentParameter() == 0.5) {
            visual.setFill((Paint)this.getMoveFill());
        } else if (this.getSegmentParameter() != 0.0 && this.getSegmentParameter() != 1.0) {
            visual.setFill((Paint)this.getInsertFill());
            visual.setWidth(6.4);
            visual.setHeight(3.2);
            visual.setTranslateX(-3.2);
            visual.setTranslateY(-1.6);
        } else {
            visual.setTranslateX(-4.0);
            visual.setTranslateY(-2.0);
            visual.setWidth(8.0);
            visual.setHeight(4.0);
            boolean connected = false;
            IVisualPart targetPart = (IVisualPart)anchorages.keySet().iterator().next();
            if (targetPart.getVisual() instanceof Connection) {
                Connection connection = (Connection)targetPart.getVisual();
                if ((double)this.getSegmentIndex() + this.getSegmentParameter() == 0.0) {
                    connected = connection.isStartConnected();
                } else if (this.getSegmentParameter() + (double)this.getSegmentIndex() == (double)this.getSegmentsInScene().length) {
                    connected = connection.isEndConnected();
                }
            }
            if (connected) {
                visual.setFill((Paint)this.getConnectedFill());
            } else {
                visual.setFill((Paint)this.getMoveFill());
            }
        }
    }

    @Override
    protected void updateLocation(Rectangle visual) {
        super.updateLocation(visual);
        BezierCurve bezierSegmentInParent = this.getBezierSegmentInParent();
        if (bezierSegmentInParent == null) {
            return;
        }
        Point direction = bezierSegmentInParent.getDerivative().get(this.getSegmentParameter());
        Vector directionVector = new Vector(direction.x, direction.y);
        if (directionVector.isNull()) {
            return;
        }
        Vector xVector = new Vector(1.0, 0.0);
        Angle angleCcw = xVector.getAngleCCW(directionVector);
        visual.setRotate(angleCcw.deg());
    }
}

