/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.dsl.pluginxml;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.parsley.dsl.pluginxml.PluginXmlUtils;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.text.DocumentElementNode;
import org.eclipse.pde.internal.core.text.IDocumentAttributeNode;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.core.text.plugin.PluginAttribute;
import org.eclipse.pde.internal.core.text.plugin.PluginElementNode;
import org.eclipse.pde.internal.core.text.plugin.PluginExtensionNode;
import org.eclipse.pde.internal.core.text.plugin.PluginModel;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class PluginXmlLoader
extends PluginModel {
    private List<PluginExtensionNode> pluginExtensionNodes;
    private List<PluginElementNode> pluginExtensionElementNodes;

    public PluginXmlLoader(String source) {
        super((IDocument)new Document(source), true);
    }

    public List<PluginExtensionNode> getExtensionNodes() {
        if (this.pluginExtensionNodes == null) {
            this.initializeExtensionNodes();
        }
        return this.pluginExtensionNodes;
    }

    protected List<PluginExtensionNode> initializeExtensionNodes() {
        this.pluginExtensionNodes = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)this.getPlugin().getExtensions())), PluginExtensionNode.class));
        return this.pluginExtensionNodes;
    }

    public List<PluginElementNode> getExtensionElements() {
        if (this.pluginExtensionElementNodes == null) {
            this.initializeExtensionElements();
        }
        return this.pluginExtensionElementNodes;
    }

    protected List<PluginElementNode> initializeExtensionElements() {
        Functions.Function1 _function = it -> this.mapToNodes((DocumentElementNode)it);
        this.pluginExtensionElementNodes = IterableExtensions.toList((Iterable)Iterables.concat((Iterable)ListExtensions.map(this.getExtensionNodes(), (Functions.Function1)_function)));
        return this.pluginExtensionElementNodes;
    }

    private Iterable<PluginElementNode> mapToNodes(DocumentElementNode it) {
        return Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)it.getChildNodes())), PluginElementNode.class);
    }

    public List<PluginElementNode> getExtensionChildren(PluginElementNode node) {
        return IterableExtensions.toList(this.mapToNodes((DocumentElementNode)node));
    }

    public Iterable<Map.Entry<String, IDocumentAttributeNode>> getPluginAttributesEntrySet(PluginElementNode node) {
        return PluginXmlUtils.getPluginAttributesEntrySet(node);
    }

    public PluginExtensionNode getExtensionByPoint(String p) {
        Functions.Function1 _function = it -> {
            String _point = it.getPoint();
            return Objects.equal((Object)_point, (Object)p);
        };
        return (PluginExtensionNode)IterableExtensions.findFirst(this.getExtensionNodes(), (Functions.Function1)_function);
    }

    public String getElementExtension(PluginElementNode node) {
        IPluginObject _parent = node.getParent();
        return ((PluginExtensionNode)_parent).getPoint();
    }

    public PluginElementNode getElementByTagAndId(String xmlTag, String id) {
        Functions.Function1 _function = it -> {
            String _xMLTagName = it.getXMLTagName();
            return Objects.equal((Object)_xMLTagName, (Object)xmlTag);
        };
        Functions.Function1 _function_1 = it -> {
            boolean _xblockexpression = false;
            IDocumentAttributeNode v = this.getId((DocumentElementNode)it);
            boolean _xifexpression = false;
            if (v != null) {
                String _attributeAsString = this.getAttributeAsString(v);
                _xifexpression = Objects.equal((Object)_attributeAsString, (Object)id);
            } else {
                _xifexpression = false;
            }
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        };
        return (PluginElementNode)IterableExtensions.findFirst((Iterable)IterableExtensions.filter(this.getExtensionElements(), (Functions.Function1)_function), (Functions.Function1)_function_1);
    }

    public IDocumentAttributeNode getId(DocumentElementNode node) {
        return PluginXmlUtils.getId(node);
    }

    public String getAttributeAsString(IDocumentAttributeNode a) {
        return ((PluginAttribute)a).getValue();
    }

    public void copyFromPluginXml(String source) throws CoreException {
        List<PluginElementNode> _extensionElements = new PluginXmlLoader(source).getExtensionElements();
        for (PluginElementNode e : _extensionElements) {
            this.copy(e);
        }
    }

    public void copy(PluginElementNode source) throws CoreException {
        String xmlTagName = source.getXMLTagName();
        PluginElementNode target = this.getElementByTagAndId(xmlTagName, this.getAttributeAsString(this.getId((DocumentElementNode)source)));
        if (target == null) {
            target = this.insertExtensionElement(this.getElementExtension(source), xmlTagName);
        }
        this.copy(source, target);
    }

    public void copy(PluginElementNode source, PluginElementNode target) throws CoreException {
        IDocumentElementNode[] _childNodes;
        IPluginAttribute[] atts;
        IPluginAttribute[] iPluginAttributeArray = atts = source.getAttributes();
        int n = atts.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginAttribute a = iPluginAttributeArray[n2];
            PluginAttribute att = (PluginAttribute)a;
            PluginAttribute copy = new PluginAttribute();
            copy.setName(att.getName());
            copy.setValue(att.getValue());
            PluginXmlUtils.getNodeAttributesMap((DocumentElementNode)target).put(att.getName(), copy);
            ++n2;
        }
        IDocumentElementNode[] children = target.getChildNodes();
        IDocumentElementNode[] iDocumentElementNodeArray = _childNodes = source.getChildNodes();
        int n3 = _childNodes.length;
        int n4 = 0;
        while (n4 < n3) {
            IDocumentElementNode c = iDocumentElementNodeArray[n4];
            Functions.Function1 _function = it -> {
                String _xMLTagName = it.getXMLTagName();
                String _xMLTagName_1 = c.getXMLTagName();
                return Objects.equal((Object)_xMLTagName, (Object)_xMLTagName_1);
            };
            IDocumentElementNode myChild = (IDocumentElementNode)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)children)), (Functions.Function1)_function);
            if (myChild == null) {
                IPluginElement _createElement = this.getPluginFactory().createElement((IPluginObject)target);
                PluginElementNode newChild = (PluginElementNode)_createElement;
                newChild.setXMLTagName(c.getXMLTagName());
                target.addChildNode((IDocumentElementNode)newChild);
                this.copy((PluginElementNode)c, newChild);
            } else {
                this.copy((PluginElementNode)c, (PluginElementNode)myChild);
            }
            ++n4;
        }
    }

    public PluginExtensionNode insertExtension(String point) throws CoreException {
        IPluginExtension e = this.getPluginFactory().createExtension();
        e.setPoint(point);
        this.getPlugin().add(e);
        this.initializeExtensionNodes();
        return (PluginExtensionNode)e;
    }

    public PluginElementNode insertExtensionElement(String point, String xmlTag) throws CoreException {
        PluginExtensionNode ext = this.getExtensionByPoint(point);
        if (ext == null) {
            ext = this.insertExtension(point);
        }
        IPluginElement _createElement = this.getPluginFactory().createElement((IPluginObject)ext);
        PluginElementNode element = (PluginElementNode)_createElement;
        ext.addChildNode((IDocumentElementNode)element);
        element.setXMLTagName(xmlTag);
        this.initializeExtensionElements();
        return element;
    }

    public String getContentsAsString() {
        StringConcatenation _builder = new StringConcatenation();
        String _replaceFirst = this.getPlugin().toString().replaceFirst("eclipse version=\"3.0", "eclipse version=\"3.4").replaceFirst("(<plugin)\\r?\\n(>)", "<plugin>");
        _builder.append(_replaceFirst);
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }
}

