/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.ContentBox;
import org.eclipse.draw2d.text.FlowBox;
import org.eclipse.draw2d.text.InlineFlow;
import org.eclipse.draw2d.text.LineBox;
import org.eclipse.draw2d.text.NestedLine;

public class LineRoot
extends LineBox {
    private int baseline;
    private final boolean isMirrored;

    public LineRoot(boolean isMirrored) {
        this.isMirrored = isMirrored;
    }

    @Override
    public void add(FlowBox child) {
        super.add(child);
        child.setLineRoot(this);
    }

    private void bidiCommit() {
        int xLocation = this.getX();
        BidiLevelNode root = new BidiLevelNode();
        ArrayList<NestedLine> branches = new ArrayList<NestedLine>();
        this.buildBidiTree(this, root, branches);
        ArrayList<FlowBox> result = new ArrayList<FlowBox>();
        root.emit(result);
        int i = this.isMirrored ? result.size() - 1 : 0;
        while (i >= 0 && i < result.size()) {
            FlowBox box = (FlowBox)result.get(i);
            box.setX(xLocation);
            xLocation += box.getWidth();
            i += this.isMirrored ? -1 : 1;
        }
        this.layoutNestedLines(branches);
    }

    /*
     * WARNING - void declaration
     */
    private void buildBidiTree(FlowBox box, BidiLevelNode node, List<NestedLine> branches) {
        FlowBox flowBox = box;
        if (flowBox instanceof LineBox) {
            FlowBox flowBox2;
            void lineBox;
            LineBox lineBox2 = (LineBox)flowBox;
            LineBox cfr_ignored_0 = (LineBox)flowBox;
            for (FlowBox child : lineBox.getFragments()) {
                this.buildBidiTree(child, node, branches);
            }
            if (box != this && (flowBox2 = box) instanceof NestedLine) {
                void nestedLine;
                FlowBox child;
                child = (NestedLine)flowBox2;
                NestedLine cfr_ignored_1 = (NestedLine)flowBox2;
                branches.add((NestedLine)nestedLine);
            }
        } else {
            ContentBox leafBox = (ContentBox)box;
            while (leafBox.getBidiLevel() < node.level) {
                node = node.pop();
            }
            while (leafBox.getBidiLevel() > node.level) {
                node = node.push();
            }
            node.add(leafBox);
        }
    }

    public void commit() {
        if (this.requiresBidi()) {
            this.bidiCommit();
        } else {
            this.contiguousCommit(this, this.getX());
        }
    }

    @Override
    public boolean containsPoint(int x, int y) {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void contiguousCommit(FlowBox box, int x) {
        box.setX(x);
        FlowBox flowBox = box;
        if (flowBox instanceof LineBox) {
            void lineBox;
            LineBox lineBox2 = (LineBox)flowBox;
            LineBox cfr_ignored_0 = (LineBox)flowBox;
            List<FlowBox> fragments = lineBox.getFragments();
            int i = this.isMirrored ? fragments.size() - 1 : 0;
            while (i >= 0 && i < fragments.size()) {
                FlowBox child = fragments.get(i);
                this.contiguousCommit(child, x);
                x += child.getWidth();
                i += this.isMirrored ? -1 : 1;
            }
        }
    }

    private Result findParent(NestedLine line, List<NestedLine> branches, int afterIndex) {
        int i = afterIndex + 1;
        while (i < branches.size()) {
            NestedLine box = branches.get(i);
            int index = box.getFragments().indexOf(line);
            if (index >= 0) {
                return new Result(box, index);
            }
            ++i;
        }
        return new Result(this, this.getFragments().indexOf(line));
    }

    @Override
    public int getBaseline() {
        return this.baseline;
    }

    @Override
    LineRoot getLineRoot() {
        return this;
    }

    int getVisibleBottom() {
        return this.baseline + this.contentDescent;
    }

    int getVisibleTop() {
        return this.baseline - this.contentAscent;
    }

    private void layoutNestedLines(List<NestedLine> branches) {
        int i = 0;
        while (i < branches.size()) {
            NestedLine parent = branches.get(i);
            FlowBox prevChild = null;
            Rectangle bounds = null;
            List<FlowBox> frags = parent.getFragments();
            int j = 0;
            while (j < frags.size()) {
                FlowBox child = frags.get(j);
                if (prevChild != null && prevChild.getX() + prevChild.width != child.getX() && child.getX() + child.width != prevChild.getX()) {
                    InlineFlow parentFig = parent.owner;
                    NestedLine newBox = new NestedLine(parentFig);
                    newBox.setLineRoot(this);
                    int k = j;
                    while (k < frags.size()) {
                        newBox.fragments.add(frags.remove(k));
                    }
                    Result result = this.findParent(parent, branches, i);
                    result.parent.getFragments().add(result.index + 1, newBox);
                    parentFig.fragments.add(parentFig.fragments.indexOf(parent) + 1, newBox);
                    branches.add(i + 1, newBox);
                    break;
                }
                if (bounds == null) {
                    bounds = new Rectangle(child.getX(), 1, child.getWidth(), 1);
                } else {
                    bounds.union(child.getX(), 1, child.getWidth(), 1);
                }
                prevChild = child;
                ++j;
            }
            parent.setX(bounds.x);
            parent.setWidth(bounds.width);
            ++i;
        }
    }

    public void setBaseline(int baseline) {
        this.baseline = baseline;
    }

    @Override
    public void setLineTop(int top) {
        this.baseline = top + this.getAscent();
    }

    private static class BidiLevelNode
    extends ArrayList<Object> {
        int level;
        final BidiLevelNode parent;

        BidiLevelNode() {
            this(null, 0);
        }

        BidiLevelNode(BidiLevelNode parent, int level) {
            this.parent = parent;
            this.level = level;
        }

        void emit(List<FlowBox> list) {
            if (this.level % 2 == 1) {
                int i = this.size() - 1;
                while (i >= 0) {
                    BidiLevelNode.emitChild(list, this.get(i));
                    --i;
                }
            } else {
                int i = 0;
                while (i < this.size()) {
                    BidiLevelNode.emitChild(list, this.get(i));
                    ++i;
                }
            }
        }

        BidiLevelNode pop() {
            return this.parent;
        }

        /*
         * WARNING - void declaration
         */
        BidiLevelNode push() {
            Object last;
            Object e;
            if (!this.isEmpty() && (e = (last = this.get(this.size() - 1))) instanceof BidiLevelNode) {
                void bidiLevelNode;
                BidiLevelNode bidiLevelNode2 = (BidiLevelNode)e;
                BidiLevelNode cfr_ignored_0 = (BidiLevelNode)e;
                if (bidiLevelNode.level == this.level + 1) {
                    return bidiLevelNode;
                }
            }
            BidiLevelNode child = new BidiLevelNode(this, this.level + 1);
            super.add(child);
            return child;
        }

        /*
         * WARNING - void declaration
         */
        private static void emitChild(List<FlowBox> list, Object child) {
            Object object = child;
            if (object instanceof BidiLevelNode) {
                void bidiLevelNode;
                BidiLevelNode bidiLevelNode2 = (BidiLevelNode)object;
                BidiLevelNode cfr_ignored_0 = (BidiLevelNode)object;
                bidiLevelNode.emit(list);
            } else {
                Object object2 = child;
                if (object2 instanceof FlowBox) {
                    void box;
                    FlowBox flowBox = (FlowBox)object2;
                    FlowBox cfr_ignored_1 = (FlowBox)object2;
                    list.add((FlowBox)box);
                }
            }
        }
    }

    private static class Result {
        private final int index;
        private final LineBox parent;

        private Result(LineBox box, int i) {
            this.parent = box;
            this.index = i;
        }
    }
}

