/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers.ui.quickfix;

import org.eclipse.cdt.codan.internal.checkers.ui.CheckersUiActivator;
import org.eclipse.cdt.codan.internal.checkers.ui.Messages;
import org.eclipse.cdt.codan.ui.AbstractAstRewriteQuickFix;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;

public class QuickFixAssignmentInCondition
extends AbstractAstRewriteQuickFix {
    public String getLabel() {
        return Messages.QuickFixAssignmentInCondition_Message;
    }

    public void modifyAST(IIndex index, IMarker marker) {
        try {
            IASTTranslationUnit ast = this.getTranslationUnitViaEditor(marker).getAST(index, 2);
            int markerStart = marker.getAttribute("charStart", -1);
            int markerEnd = marker.getAttribute("charEnd", -1);
            if (markerStart == -1 || markerEnd == -1 || markerStart >= markerEnd) {
                return;
            }
            IASTNodeSelector nodeSelector = ast.getNodeSelector(null);
            IASTNode containedNode = nodeSelector.findEnclosingNode(markerStart, markerEnd - markerStart);
            if (containedNode instanceof IASTBinaryExpression) {
                IASTBinaryExpression expr = (IASTBinaryExpression)containedNode;
                IASTNodeLocation[] leftSubexprLocations = expr.getOperand1().getNodeLocations();
                if (leftSubexprLocations.length != 1) {
                    return;
                }
                IASTNodeLocation leftSubexprLocation = leftSubexprLocations[0];
                int leftSubexprEnd = leftSubexprLocation.getNodeOffset() + leftSubexprLocation.getNodeLength();
                FindReplaceDocumentAdapter adapter = new FindReplaceDocumentAdapter(this.getDocument());
                adapter.find(leftSubexprEnd, "=", true, false, false, false);
                adapter.replace("==", false);
            }
        }
        catch (CoreException e) {
            CheckersUiActivator.log(e);
        }
        catch (BadLocationException e) {
            CheckersUiActivator.log(e);
        }
    }
}

