/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.elementparsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.uibinder.elementparsers.HtmlPlaceholderInterpreter;
import com.google.gwt.uibinder.elementparsers.TextPlaceholderInterpreter;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;
import com.google.gwt.uibinder.rebind.messages.MessageWriter;
import com.google.gwt.uibinder.rebind.messages.MessagesWriter;
import com.google.gwt.user.client.ui.HasHTML;
import com.google.gwt.user.client.ui.HasText;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class WidgetPlaceholderInterpreter
extends HtmlPlaceholderInterpreter {
    private int serial = 0;
    private final String ancestorExpression;
    private final String fieldName;
    private final Map<String, XMLElement> idToWidgetElement = new HashMap<String, XMLElement>();
    private final Set<String> idIsHasHTML = new HashSet<String>();
    private final Set<String> idIsHasText = new HashSet<String>();

    WidgetPlaceholderInterpreter(String fieldName, UiBinderWriter writer, MessageWriter message, String ancestorExpression) {
        super(writer, message, ancestorExpression);
        this.fieldName = fieldName;
        this.ancestorExpression = ancestorExpression;
    }

    public String interpretElement(XMLElement elem) throws UnableToCompleteException {
        if (!this.uiWriter.isWidgetElement(elem)) {
            return super.interpretElement(elem);
        }
        JClassType type = this.uiWriter.findFieldType(elem);
        TypeOracle oracle = this.uiWriter.getOracle();
        MessagesWriter mw = this.uiWriter.getMessages();
        String name = mw.consumeMessageAttribute("ph", elem);
        if ("".equals(name)) {
            name = "widget" + ++this.serial;
        }
        String idHolder = this.uiWriter.declareDomIdHolder();
        this.idToWidgetElement.put(idHolder, elem);
        if (oracle.findType(HasHTML.class.getName()).isAssignableFrom(type)) {
            return this.handleHasHTMLPlaceholder(elem, name, idHolder);
        }
        if (oracle.findType(HasText.class.getName()).isAssignableFrom(type)) {
            return this.handleHasTextPlaceholder(elem, name, idHolder);
        }
        return this.handleOpaqueWidgetPlaceholder(name, idHolder);
    }

    public String postProcess(String consumed) throws UnableToCompleteException {
        for (String idHolder : this.idToWidgetElement.keySet()) {
            XMLElement childElem = this.idToWidgetElement.get(idHolder);
            String childField = this.uiWriter.parseElementToField(childElem);
            this.genSetWidgetTextCall(idHolder, childField);
            this.uiWriter.addInitStatement("%1$s.addAndReplaceElement(%2$s, %3$s);", new Object[]{this.fieldName, childField, idHolder});
        }
        this.idToWidgetElement.clear();
        return super.postProcess(consumed);
    }

    private String genCloseTag(String name) {
        String closePlaceholder = this.nextClosePlaceholder(name + "End", "</span>");
        return closePlaceholder;
    }

    private String genOpenTag(String name, String idHolder) {
        String openTag = String.format("<span id='\" + %s + \"'>", idHolder);
        String openPlaceholder = this.nextOpenPlaceholder(name + "Begin", openTag);
        return openPlaceholder;
    }

    private void genSetWidgetTextCall(String idHolder, String childField) {
        if (this.idIsHasText.contains(idHolder)) {
            this.uiWriter.addInitStatement("%s.setText(%s.getElementById(%s).getInnerText());", new Object[]{childField, this.fieldName, idHolder});
        }
        if (this.idIsHasHTML.contains(idHolder)) {
            this.uiWriter.addInitStatement("%s.setHTML(%s.getElementById(%s).getInnerHTML());", new Object[]{childField, this.fieldName, idHolder});
        }
    }

    private String handleHasHTMLPlaceholder(XMLElement elem, String name, String idHolder) throws UnableToCompleteException {
        this.idIsHasHTML.add(idHolder);
        String openPlaceholder = this.genOpenTag(name, idHolder);
        String body = elem.consumeInnerHtml((XMLElement.PostProcessingInterpreter)new HtmlPlaceholderInterpreter(this.uiWriter, this.message, this.ancestorExpression));
        String bodyToken = this.tokenator.nextToken(body);
        String closePlaceholder = this.genCloseTag(name);
        return openPlaceholder + bodyToken + closePlaceholder;
    }

    private String handleHasTextPlaceholder(XMLElement elem, String name, String idHolder) throws UnableToCompleteException {
        this.idIsHasText.add(idHolder);
        String openPlaceholder = this.genOpenTag(name, idHolder);
        String body = elem.consumeInnerText((XMLElement.PostProcessingInterpreter)new TextPlaceholderInterpreter(this.uiWriter, this.message));
        String bodyToken = this.tokenator.nextToken(body);
        String closePlaceholder = this.genCloseTag(name);
        return openPlaceholder + bodyToken + closePlaceholder;
    }

    private String handleOpaqueWidgetPlaceholder(String name, String idHolder) {
        String tag = String.format("<span id='\" + %s + \"'></span>", idHolder);
        String placeholder = this.nextPlaceholder(name, "<span></span>", tag);
        return placeholder;
    }
}

