/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.wsdl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import org.eclipse.wst.wsi.internal.core.wsdl.WSDLDocument;

public final class WSDLUtils {
    public static boolean isRpcLiteral(String bindingStyle, BindingOperation operation) {
        return WSDLUtils.checkStyleAndUse("rpc", "literal", bindingStyle, operation);
    }

    public static boolean isDocLiteral(String bindingStyle, BindingOperation operation) {
        return WSDLUtils.checkStyleAndUse("document", "literal", bindingStyle, operation);
    }

    private static boolean checkStyleAndUse(String checkStyle, String checkUse, String bindingStyle, BindingOperation bindingOperation) {
        boolean styleFound = false;
        boolean styleAndUseFound = false;
        SOAPOperation soapOperation = WSDLUtils.getSoapOperation(bindingOperation);
        if (soapOperation == null || soapOperation.getStyle() == null) {
            if (checkStyle.equals(bindingStyle)) {
                styleFound = true;
            }
        } else if (checkStyle.equals(soapOperation.getStyle())) {
            styleFound = true;
        }
        if (styleFound) {
            SOAPBody soapBody = WSDLUtils.getInputSoapBody(bindingOperation);
            if (soapBody == null || soapBody.getUse() == null) {
                if (checkUse.equals("literal")) {
                    styleAndUseFound = true;
                }
            } else if (checkUse.equals(soapBody.getUse())) {
                styleAndUseFound = true;
            }
        }
        return styleAndUseFound;
    }

    public static SOAPBinding getSoapBinding(Binding binding) {
        SOAPBinding soapBinding = null;
        List extElements = null;
        extElements = binding.getExtensibilityElements();
        if (extElements != null) {
            Iterator iterator = extElements.iterator();
            while (iterator.hasNext() && soapBinding == null) {
                Object obj = iterator.next();
                if (!(obj instanceof SOAPBinding)) continue;
                soapBinding = (SOAPBinding)obj;
            }
        }
        return soapBinding;
    }

    public static SOAPOperation getSoapOperation(BindingOperation bindingOperation) {
        SOAPOperation soapOperation = null;
        List extElements = null;
        extElements = bindingOperation.getExtensibilityElements();
        if (extElements != null) {
            Iterator iterator = extElements.iterator();
            while (iterator.hasNext() && soapOperation == null) {
                Object obj = iterator.next();
                if (!(obj instanceof SOAPOperation)) continue;
                soapOperation = (SOAPOperation)obj;
            }
        }
        return soapOperation;
    }

    public static SOAPBody getInputSoapBody(BindingOperation bindingOperation) {
        SOAPBody soapBody = null;
        List extElements = null;
        extElements = bindingOperation.getBindingInput().getExtensibilityElements();
        if (extElements != null) {
            Iterator iterator = extElements.iterator();
            while (iterator.hasNext() && soapBody == null) {
                Object obj = iterator.next();
                if (!(obj instanceof SOAPBody)) continue;
                soapBody = (SOAPBody)obj;
            }
        }
        return soapBody;
    }

    public static HashSet findMessages(Definition definition, Binding binding) {
        HashSet bindingMessages = new HashSet();
        HashSet portTypeMessages = WSDLUtils.findMessages(binding.getPortType());
        for (BindingOperation bindingOperation : binding.getBindingOperations()) {
            HashSet tempMessages;
            if (bindingOperation.getBindingInput() != null) {
                tempMessages = WSDLUtils.findMessages(bindingOperation.getBindingInput().getExtensibilityElements().iterator(), portTypeMessages, definition);
                bindingMessages.addAll(tempMessages);
            }
            if (bindingOperation.getBindingOutput() == null) continue;
            tempMessages = WSDLUtils.findMessages(bindingOperation.getBindingOutput().getExtensibilityElements().iterator(), portTypeMessages, definition);
            bindingMessages.addAll(tempMessages);
        }
        return bindingMessages;
    }

    public static HashSet findMessages(PortType portType) {
        HashSet<Message> messageSet = new HashSet<Message>();
        for (Operation operation : portType.getOperations()) {
            if (operation.getInput() != null) {
                messageSet.add(operation.getInput().getMessage());
            }
            if (operation.getOutput() != null) {
                messageSet.add(operation.getOutput().getMessage());
            }
            Iterator faults = operation.getFaults().values().iterator();
            while (faults.hasNext()) {
                messageSet.add(((Fault)faults.next()).getMessage());
            }
        }
        return messageSet;
    }

    protected static HashSet findMessages(Iterator extElementList, HashSet messageSet, Definition definition) {
        HashSet<Message> returnSet = new HashSet<Message>();
        Message saveMessage = null;
        while (extElementList.hasNext()) {
            Message message;
            ExtensibilityElement extElement = (ExtensibilityElement)extElementList.next();
            if (!(extElement instanceof SOAPHeader)) continue;
            SOAPHeader soapHeader = (SOAPHeader)extElement;
            QName messageQName = soapHeader.getMessage();
            if (messageQName != null) {
                message = definition.getMessage(messageQName);
                if (message == null) {
                    message = definition.createMessage();
                    message.setQName(messageQName);
                    message.setUndefined(true);
                }
                if (!messageSet.contains(message)) {
                    returnSet.add(message);
                    saveMessage = message;
                }
            }
            for (SOAPHeaderFault soapHeaderFault : soapHeader.getSOAPHeaderFaults()) {
                messageQName = soapHeaderFault.getMessage();
                if (messageQName == null) continue;
                message = definition.getMessage(messageQName);
                if (message == null) {
                    message = definition.createMessage();
                    message.setQName(messageQName);
                    message.setUndefined(true);
                }
                if (messageSet.contains(message) || saveMessage != null && (saveMessage == null || saveMessage.getQName().equals(message.getQName()))) continue;
                returnSet.add(message);
            }
        }
        return returnSet;
    }

    public static boolean isSOAP12WSDL(WSDLDocument wsdlDocument) {
        boolean result = false;
        if (wsdlDocument != null) {
            Binding[] bindings = wsdlDocument.getBindings();
            ArrayList extensibilityElementList = new ArrayList();
            if (bindings != null) {
                int i = 0;
                while (i < bindings.length) {
                    extensibilityElementList.addAll(bindings[i].getExtensibilityElements());
                    ++i;
                }
                for (ExtensibilityElement e : extensibilityElementList) {
                    if (!"http://schemas.xmlsoap.org/wsdl/soap12/".equals(e.getElementType().getNamespaceURI())) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }
}

