/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.property.editor.font;

import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.util.TemplateUtils;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.swt.model.ModelMessages;
import org.eclipse.wb.internal.swt.model.jface.resource.FontRegistryInfo;
import org.eclipse.wb.internal.swt.model.jface.resource.KeyFieldInfo;
import org.eclipse.wb.internal.swt.model.property.editor.font.AbstractFontPage;
import org.eclipse.wb.internal.swt.model.property.editor.font.FontDialog;
import org.eclipse.wb.internal.swt.model.property.editor.font.FontInfo;

public final class RegistryFontPage
extends AbstractFontPage {
    public static final String NAME = "FontRegistry";
    public static final int FONT_STYLE_NONE = 0;
    public static final int FONT_STYLE_BOLD = 1;
    public static final int FONT_STYLE_ITALIC = 2;
    private static final RegistryLabelProvider REGISTRY_LABEL_PROVIDER = new RegistryLabelProvider();
    private static final KeyLabelProvider KEY_LABEL_PROVIDER = new KeyLabelProvider();
    private static final KeyFieldInfo NO_VALUE_KEY = new KeyFieldInfo(Object.class, ModelMessages.RegistryFontPage_selectRegistry, null);
    private static final KeyFieldInfo[] NO_VALUE_KEY_INPUT = new KeyFieldInfo[]{NO_VALUE_KEY};
    private final Text m_registryText;
    private final ListViewer m_registryList;
    private final Text m_keyText;
    private final ListViewer m_keyList;
    private final Text m_styleText;
    private final org.eclipse.swt.widgets.List m_methodList;

    public RegistryFontPage(Composite parent, int style, FontDialog fontDialog, List<FontRegistryInfo> registries) {
        super(parent, style, fontDialog);
        GridLayoutFactory.create((Composite)this).columns(3);
        new Label((Composite)this, 0).setText(ModelMessages.RegistryFontPage_registry);
        new Label((Composite)this, 0).setText(ModelMessages.RegistryFontPage_key);
        new Label((Composite)this, 0).setText(ModelMessages.RegistryFontPage_method);
        this.m_registryText = new Text((Composite)this, 2056);
        GridDataFactory.create((Control)this.m_registryText).fill();
        this.m_keyText = new Text((Composite)this, 2056);
        GridDataFactory.create((Control)this.m_keyText).fill();
        this.m_styleText = new Text((Composite)this, 2056);
        GridDataFactory.create((Control)this.m_styleText).fill();
        this.m_registryList = new ListViewer((Composite)this, 2560);
        GridDataFactory.create((Control)this.m_registryList.getControl()).hintVC(12).grab().fill();
        this.m_registryList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.m_registryList.setLabelProvider((IBaseLabelProvider)REGISTRY_LABEL_PROVIDER);
        this.m_registryList.setInput(registries);
        this.m_registryList.addPostSelectionChangedListener(new ISelectionChangedListener(){
            FontRegistryInfo m_registryInfo;

            public void selectionChanged(SelectionChangedEvent event) {
                FontRegistryInfo registryInfo = RegistryFontPage.this.getSelectionRegistry();
                if (registryInfo != null && this.m_registryInfo != registryInfo) {
                    this.m_registryInfo = registryInfo;
                    RegistryFontPage.this.m_registryText.setText(REGISTRY_LABEL_PROVIDER.getText((Object)registryInfo));
                    List<KeyFieldInfo> keyFields = registryInfo.getKeyFields();
                    RegistryFontPage.this.m_keyList.setInput(keyFields);
                    if (!keyFields.isEmpty()) {
                        RegistryFontPage.this.m_keyList.setSelection((ISelection)new StructuredSelection((Object)keyFields.get(0)));
                    }
                }
            }
        });
        this.m_keyList = new ListViewer((Composite)this, 2048);
        GridDataFactory.create((Control)this.m_keyList.getControl()).hintHC(30).fill().grab();
        this.m_keyList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.m_keyList.setLabelProvider((IBaseLabelProvider)KEY_LABEL_PROVIDER);
        this.m_keyList.setInput((Object)NO_VALUE_KEY_INPUT);
        this.m_keyList.addPostSelectionChangedListener(new ISelectionChangedListener(){
            KeyFieldInfo m_keyFieldInfo;

            public void selectionChanged(SelectionChangedEvent event) {
                KeyFieldInfo keyFieldInfo = RegistryFontPage.this.getKeyInfo();
                if (keyFieldInfo != null && keyFieldInfo != NO_VALUE_KEY && this.m_keyFieldInfo != keyFieldInfo) {
                    this.m_keyFieldInfo = keyFieldInfo;
                    RegistryFontPage.this.m_keyText.setText(keyFieldInfo.keyName);
                    if (RegistryFontPage.this.m_methodList.getSelectionIndex() == -1) {
                        RegistryFontPage.this.m_methodList.setSelection(0);
                    }
                    RegistryFontPage.this.updateFont();
                }
            }
        });
        this.m_methodList = new org.eclipse.swt.widgets.List((Composite)this, 2560);
        GridDataFactory.create((Control)this.m_methodList).hintC(10, 12).fill();
        this.m_methodList.add("get()");
        this.m_methodList.add("getBold()");
        this.m_methodList.add("getItalic()");
        this.m_methodList.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int selectionIndex = RegistryFontPage.this.m_methodList.getSelectionIndex();
                if (selectionIndex != -1) {
                    RegistryFontPage.this.m_styleText.setText(RegistryFontPage.this.m_methodList.getItem(selectionIndex));
                    RegistryFontPage.this.updateFont();
                }
            }
        });
    }

    protected final FontRegistryInfo getSelectionRegistry() {
        IStructuredSelection selection = (IStructuredSelection)this.m_registryList.getSelection();
        if (selection != null) {
            return (FontRegistryInfo)((Object)selection.getFirstElement());
        }
        return null;
    }

    protected final KeyFieldInfo getKeyInfo() {
        IStructuredSelection selection = (IStructuredSelection)this.m_keyList.getSelection();
        if (selection != null) {
            return (KeyFieldInfo)selection.getFirstElement();
        }
        return null;
    }

    protected final void updateFont() {
        try {
            FontRegistryInfo registryInfo = this.getSelectionRegistry();
            KeyFieldInfo keyFieldInfo = this.getKeyInfo();
            int selectionIndex = this.m_methodList.getSelectionIndex();
            if (registryInfo == null || keyFieldInfo == null || selectionIndex == -1) {
                return;
            }
            Object methodSignature = "get";
            if (selectionIndex == 1) {
                methodSignature = (String)methodSignature + "Bold";
            } else if (selectionIndex == 2) {
                methodSignature = (String)methodSignature + "Italic";
            }
            String source = TemplateUtils.format((String)"{0}.{1}({2})", (Object[])new Object[]{registryInfo, methodSignature, keyFieldInfo.keySource});
            methodSignature = (String)methodSignature + "(java.lang.String)";
            Object fontValue = ReflectionUtils.invokeMethod((Object)registryInfo.getObject(), (String)methodSignature, (Object[])new Object[]{keyFieldInfo.keyValue});
            this.m_fontDialog.setFontInfo(new FontInfo(null, fontValue, source, false));
        }
        catch (Throwable e) {
            DesignerPlugin.log((Throwable)e);
        }
    }

    @Override
    public void setFont(final FontInfo fontInfo) {
        if (fontInfo != null) {
            ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    if (fontInfo.getData() instanceof Object[]) {
                        Object[] data = (Object[])fontInfo.getData();
                        RegistryFontPage.this.m_registryList.setSelection((ISelection)new StructuredSelection(data[0]));
                        RegistryFontPage.this.m_keyList.setSelection((ISelection)new StructuredSelection(data[1]));
                        RegistryFontPage.this.m_methodList.setSelection(((Integer)data[2]).intValue());
                    }
                }
            });
        }
    }

    private static class KeyLabelProvider
    extends LabelProvider {
        private KeyLabelProvider() {
        }

        public String getText(Object element) {
            KeyFieldInfo keyFieldInfo = (KeyFieldInfo)element;
            return keyFieldInfo.keyName;
        }
    }

    private static class RegistryLabelProvider
    extends LabelProvider {
        private RegistryLabelProvider() {
        }

        public String getText(Object element) {
            try {
                FontRegistryInfo registryInfo = (FontRegistryInfo)((Object)element);
                return registryInfo.getVariableSupport().getTitle();
            }
            catch (Throwable e) {
                DesignerPlugin.log((Throwable)e);
                return "???";
            }
        }
    }
}

