/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.layout.form;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.wb.core.editor.IDesignPageSite;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.core.model.broadcast.ObjectInfoTreeComplete;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.swt.model.layout.form.IFormLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.IControlInfo;

public final class FormLayoutPreferences<C extends IControlInfo> {
    private static final String PREFERENCE_CHANGE_LISTENER_KEY = "FormLayout.preferenceChangeListener";
    private final IFormLayoutInfo<C> m_layout;
    private final ObjectInfo m_layoutModel;
    private static final QualifiedName KEY_H_PERCENTS = new QualifiedName("org.eclipse.wb.swt", "formLayout.snap.percents.horizontal");
    private static final QualifiedName KEY_V_PERCENTS = new QualifiedName("org.eclipse.wb.swt", "formLayout.snap.percents.vertical");
    private final IPreferenceStore m_preferences;

    public FormLayoutPreferences(IFormLayoutInfo<C> layout, ToolkitDescription toolkit) {
        this.m_layout = layout;
        this.m_preferences = toolkit.getPreferences();
        this.m_layoutModel = layout.getUnderlyingModel();
        this.m_layoutModel.addBroadcastListener((Object)new ObjectInfoTreeComplete(){

            public void invoke() throws Exception {
                FormLayoutPreferences.this.addPropertyChangeListener();
            }
        });
    }

    public void addPropertyChangeListener() {
        ObjectInfo rooObject = this.m_layoutModel.getRoot();
        if (rooObject.getArbitraryValue((Object)PREFERENCE_CHANGE_LISTENER_KEY) == null) {
            final PreferenceChangeListener listener = new PreferenceChangeListener();
            this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)listener);
            rooObject.putArbitraryValue((Object)PREFERENCE_CHANGE_LISTENER_KEY, (Object)listener);
            rooObject.addBroadcastListener((Object)new ObjectEventListener(){

                public void dispose() throws Exception {
                    FormLayoutPreferences.this.getPreferenceStore().removePropertyChangeListener(listener);
                    FormLayoutPreferences.this.m_layoutModel.getRoot().putArbitraryValue((Object)FormLayoutPreferences.PREFERENCE_CHANGE_LISTENER_KEY, null);
                }
            });
        }
    }

    public IPreferenceStore getPreferenceStore() {
        return this.m_preferences;
    }

    public List<Integer> getVerticalPercents() {
        return Lists.newArrayList(this.loadPercents(KEY_V_PERCENTS));
    }

    public List<Integer> getHorizontalPercents() {
        return Lists.newArrayList(this.loadPercents(KEY_H_PERCENTS));
    }

    public int getSnapSensitivity() {
        return this.getPreferenceStore().getInt("formLayout.snap.sensitivity");
    }

    public int getHorizontalContainerGap() {
        return this.getPreferenceStore().getInt("formLayout.snap.windowMargin.horizontal");
    }

    public int getVerticalContainerGap() {
        return this.getPreferenceStore().getInt("formLayout.snap.windowMargin.vertical");
    }

    public int getHorizontalPercentsGap() {
        return this.getPreferenceStore().getInt("formLayout.snap.percentOffset.horizontal");
    }

    public int getVerticalPercentsGap() {
        return this.getPreferenceStore().getInt("formLayout.snap.percentOffset.vertical");
    }

    public int getHorizontalComponentGap() {
        return this.getPreferenceStore().getInt("formLayout.snap.widgetOffset.horizontal");
    }

    public int getVerticalComponentGap() {
        return this.getPreferenceStore().getInt("formLayout.snap.widgetOffset.vertical");
    }

    public void addPercent(int percent, boolean isHorizontal) {
        QualifiedName keyPercents = isHorizontal ? KEY_H_PERCENTS : KEY_V_PERCENTS;
        Set<Integer> percents = this.loadPercents(keyPercents);
        percents.add(percent);
        this.savePercents(keyPercents, percents);
    }

    public void removePercent(int percent, boolean isHorizontal) {
        QualifiedName keyPercents = isHorizontal ? KEY_H_PERCENTS : KEY_V_PERCENTS;
        Set<Integer> percents = this.loadPercents(keyPercents);
        percents.remove(percent);
        this.savePercents(keyPercents, percents);
    }

    public void defaultPercents(boolean isHorizontal) {
        QualifiedName keyPercents = isHorizontal ? KEY_H_PERCENTS : KEY_V_PERCENTS;
        this.setPersistentProperty(keyPercents, "");
    }

    public void setAsDefaultPercents(boolean isHorizontal) {
        QualifiedName keyPercents = isHorizontal ? KEY_H_PERCENTS : KEY_V_PERCENTS;
        Set<Integer> percents = this.loadPercents(keyPercents);
        this.setPersistentProperty(keyPercents, "");
        this.getPreferenceStore().setValue(keyPercents.getLocalName(), this.getPercentsString(percents));
    }

    private void savePercents(QualifiedName keyPercents, Set<Integer> percents) {
        this.setPersistentProperty(keyPercents, this.getPercentsString(percents));
    }

    private String getPercentsString(Collection<Integer> percents) {
        StringBuffer buffer = new StringBuffer();
        for (Integer percent : percents) {
            buffer.append(percent);
            buffer.append(" ");
        }
        buffer.delete(buffer.length() - 1, buffer.length());
        return buffer.toString();
    }

    private Set<Integer> loadPercents(final QualifiedName keyPercents) {
        final TreeSet<Integer> values = new TreeSet<Integer>();
        ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                FormLayoutPreferences.fillPercents(FormLayoutPreferences.this.getPersistentProperty(keyPercents), values);
            }
        });
        if (values.isEmpty()) {
            FormLayoutPreferences.fillPercents(this.getPreferenceStore().getString(keyPercents.getLocalName()), values);
        }
        return values;
    }

    private void setPersistentProperty(final QualifiedName key, final String value) {
        ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                IResource resource = FormLayoutPreferences.this.m_layout.getUnderlyingResource();
                resource.setPersistentProperty(key, value);
            }
        });
    }

    private String getPersistentProperty(QualifiedName key) throws Exception {
        IResource resource = this.m_layout.getUnderlyingResource();
        return resource.getPersistentProperty(key);
    }

    public static Collection<Integer> fillPercents(String percents, Collection<Integer> percentsCollection) {
        if (!StringUtils.isEmpty((String)percents)) {
            String[] splitted;
            String[] stringArray = splitted = StringUtils.split((String)percents);
            int n = splitted.length;
            int n2 = 0;
            while (n2 < n) {
                String percentString = stringArray[n2];
                try {
                    int percent = Integer.parseInt(percentString);
                    percentsCollection.add(percent);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ++n2;
            }
        }
        return percentsCollection;
    }

    public boolean useClassic() {
        IPreferenceStore preferences = this.getPreferenceStore();
        String value = preferences.getString("formLayout.mode");
        return "classic".equals(value);
    }

    public static final class PercentsInfo {
        public final int value;

        public PercentsInfo(Integer percent) {
            this.value = percent;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private final class PreferenceChangeListener
    implements IPropertyChangeListener {
        private PreferenceChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if ("formLayout.mode".equals(event.getProperty())) {
                ExecutionUtils.runAsync((RunnableEx)new RunnableEx(){

                    public void run() throws Exception {
                        IDesignPageSite.Helper.getSite((ObjectInfo)((PreferenceChangeListener)PreferenceChangeListener.this).FormLayoutPreferences.this.m_layoutModel).reparse();
                    }
                });
            }
        }
    }
}

