/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.jface.resource;

import java.util.HashSet;
import java.util.List;
import org.eclipse.wb.core.model.IRootProcessor;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.internal.core.model.util.GlobalStateJava;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.GlobalState;
import org.eclipse.wb.internal.swt.model.jface.resource.RegistryContainerInfo;
import org.eclipse.wb.internal.swt.model.jface.resource.ResourceRegistryInfo;
import org.eclipse.wb.internal.swt.support.AbstractSupport;
import org.eclipse.wb.internal.swt.support.DisplaySupport;

public final class ResourceRegistryRootProcessor
implements IRootProcessor {
    public void process(JavaInfo root, List<JavaInfo> components) throws Exception {
        this.processRoot(root);
        this.processComponents(root, components);
    }

    private void processRoot(final JavaInfo root) {
        root.addBroadcastListener((Object)new ObjectEventListener(){

            public void refreshDispose() throws Exception {
                ResourceRegistryRootProcessor.disposeResourceRegistries(root);
            }

            public void dispose() throws Exception {
                ResourceRegistryRootProcessor.disposeResourceRegistries(root);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private void processComponents(JavaInfo root, List<JavaInfo> components) throws Exception {
        for (JavaInfo javaInfo : components) {
            void resourceRegistryInfo;
            JavaInfo javaInfo2 = javaInfo;
            if (!(javaInfo2 instanceof ResourceRegistryInfo)) continue;
            ResourceRegistryInfo cfr_ignored_0 = (ResourceRegistryInfo)javaInfo2;
            ResourceRegistryInfo cfr_ignored_1 = (ResourceRegistryInfo)javaInfo2;
            RegistryContainerInfo.get(root).addChild((ObjectInfo)resourceRegistryInfo);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void disposeResourceRegistries(JavaInfo javaInfo) throws Exception {
        ObjectInfo activeObject = GlobalState.getActiveObject();
        ObjectInfo objectInfo = activeObject;
        if (!(objectInfo instanceof JavaInfo)) {
            return;
        }
        JavaInfo javaInfo2 = (JavaInfo)objectInfo;
        JavaInfo cfr_ignored_0 = (JavaInfo)objectInfo;
        try {
            Object display;
            Runnable[] disposeList;
            GlobalStateJava.activate((JavaInfo)javaInfo);
            if (AbstractSupport.is_SWT() && (disposeList = (Runnable[])ReflectionUtils.getFieldObject((Object)(display = DisplaySupport.getDefault()), (String)"disposeList")) != null) {
                HashSet<Runnable> disposeRunnables = new HashSet<Runnable>();
                for (ResourceRegistryInfo registryInfo : RegistryContainerInfo.getRegistries(javaInfo, ResourceRegistryInfo.class)) {
                    Runnable disposeRunnable = registryInfo.getDisposeRunnable();
                    if (disposeRunnable == null) continue;
                    disposeRunnables.add(disposeRunnable);
                }
                int i = 0;
                while (i < disposeList.length) {
                    Runnable disposeRunnable = disposeList[i];
                    if (disposeRunnable != null && disposeRunnables.contains(disposeRunnable)) {
                        disposeList[i] = null;
                        disposeRunnable.run();
                    }
                    ++i;
                }
            }
        }
        finally {
            void activeJavaInfo;
            GlobalStateJava.activate((JavaInfo)activeJavaInfo);
        }
    }
}

