/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.FormLayout.gef.header.selection;

import java.text.MessageFormat;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.swt.graphics.Font;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.draw2d.border.Border;
import org.eclipse.wb.draw2d.border.CompoundBorder;
import org.eclipse.wb.draw2d.border.LineBorder;
import org.eclipse.wb.draw2d.border.MarginBorder;
import org.eclipse.wb.internal.core.utils.ui.DrawUtils;
import org.eclipse.wb.internal.swing.FormLayout.gef.GefMessages;

public final class ResizeHintFigure
extends Figure {
    private String m_text;
    private String m_sizeHint;
    private boolean m_showSizeHint = true;

    public ResizeHintFigure() {
        this.setOpaque(true);
        this.setBackgroundColor(IColorConstants.tooltipBackground);
        this.setForegroundColor(IColorConstants.tooltipForeground);
        this.setBorder((Border)new CompoundBorder((Border)new LineBorder(IColorConstants.tooltipForeground), (Border)new MarginBorder(2)));
    }

    public void setText(String text) {
        this.m_text = text;
        this.update();
    }

    public void setSizeHint(String hint) {
        this.m_sizeHint = hint;
        this.update();
    }

    public void setShowSizeHint(boolean showSizeHint) {
        this.m_showSizeHint = showSizeHint;
        this.update();
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Font font = this.getFont();
        int width = 0;
        int height = 0;
        Dimension size = FigureUtils.calculateTextSize((String)this.m_text, (Font)font);
        width = Math.max(width, size.width);
        height += size.height;
        if (this.m_showSizeHint) {
            Object[] objectArray;
            int hintWidth = 0;
            Font boldFont = DrawUtils.getBoldFont((Font)font);
            try {
                hintWidth += FigureUtils.calculateTextSize((String)GefMessages.ResizeHintFigure_hint, (Font)boldFont).width;
                hintWidth += FigureUtils.calculateTextSize((String)GefMessages.ResizeHintFigure_press, (Font)font).width;
                hintWidth += FigureUtils.calculateTextSize((String)"Ctrl", (Font)boldFont).width;
                objectArray = new Object[]{this.m_sizeHint};
            }
            finally {
                boldFont.dispose();
            }
            width = Math.max(width, hintWidth += FigureUtils.calculateTextSize((String)MessageFormat.format((String)GefMessages.ResizeHintFigure_toSetSize, (Object[])objectArray), (Font)font).width);
            height *= 2;
        }
        Insets insets = this.getInsets();
        return new Dimension(width + insets.getWidth(), height + insets.getHeight());
    }

    private void update() {
        this.setSize(this.getPreferredSize());
        this.repaint();
    }

    protected void paintClientArea(Graphics graphics) {
        graphics.drawText(this.m_text, 0, 0);
        if (this.m_showSizeHint) {
            int y = this.getClientArea().height / 2;
            Font font = this.getFont();
            Font boldFont = DrawUtils.getBoldFont((Font)font);
            try {
                int x = 0;
                x = this.drawText(graphics, x, y + 1, GefMessages.ResizeHintFigure_hint, boldFont);
                x = this.drawText(graphics, x, y, GefMessages.ResizeHintFigure_press, font);
                graphics.pushState();
                graphics.setForegroundColor(IColorConstants.lightBlue);
                x = this.drawText(graphics, x, y + 1, "Ctrl", boldFont);
                graphics.popState();
                x = this.drawText(graphics, x, y, MessageFormat.format(GefMessages.ResizeHintFigure_toSetSize, this.m_sizeHint), font);
            }
            finally {
                boldFont.dispose();
            }
        }
    }

    private int drawText(Graphics graphics, int x, int y, String text, Font font) {
        graphics.setFont(font);
        graphics.drawText(text, x, y);
        return x + FigureUtils.calculateTextSize((String)text, (Font)font).width;
    }
}

