/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.universal.contentdetect;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class ContentDetectHelper {
    public static final int NO_STATE = -1;
    private static final String EXTENSION_COUNT_XML = "extensionCount.xml";
    private static final String EXTENSION_NAMES_XML = "extensionNames.xml";
    private static final String INTROCOUNT = "introcount";
    private static final String CONTRIBUTOR = "contributor";
    private static final String NAME = "name";
    private static final String ROOT = "root";
    private static final String PLUGIN_ID = "org.eclipse.ui.intro.universal";
    private File configurationDirectory;

    private File getConfigurationLocation() {
        URL configURL;
        Location location;
        if (this.configurationDirectory == null && (location = Platform.getConfigurationLocation()) != null && (configURL = location.getURL()) != null && configURL.getProtocol().startsWith("file")) {
            this.configurationDirectory = new File(configURL.getFile(), PLUGIN_ID);
            if (this.configurationDirectory != null && !this.configurationDirectory.exists()) {
                this.configurationDirectory.mkdirs();
            }
        }
        return this.configurationDirectory;
    }

    public void saveExtensionCount(int count) {
        XMLMemento writeMemento = XMLMemento.createWriteRoot((String)ROOT);
        writeMemento.putInteger(INTROCOUNT, count);
        this.saveMemento(writeMemento, EXTENSION_COUNT_XML);
    }

    public int getExtensionCount() {
        XMLMemento readMemento = this.getReadMemento(EXTENSION_COUNT_XML);
        if (readMemento == null) {
            return -1;
        }
        Integer extensionCount = readMemento.getInteger(INTROCOUNT);
        if (extensionCount == null) {
            return -1;
        }
        return extensionCount;
    }

    public void saveContributors(Set<String> contributors) {
        XMLMemento writeMemento = XMLMemento.createWriteRoot((String)ROOT);
        Iterator<String> iter = contributors.iterator();
        while (iter.hasNext()) {
            IMemento childMemento = writeMemento.createChild(CONTRIBUTOR);
            childMemento.putString(NAME, iter.next());
        }
        this.saveMemento(writeMemento, EXTENSION_NAMES_XML);
    }

    public Set<String> getContributors() {
        HashSet<String> contributors = new HashSet<String>();
        XMLMemento readMemento = this.getReadMemento(EXTENSION_NAMES_XML);
        if (readMemento == null) {
            return contributors;
        }
        IMemento[] children = readMemento.getChildren(CONTRIBUTOR);
        int c = 0;
        while (c < children.length) {
            contributors.add(children[c].getString(NAME));
            ++c;
        }
        return contributors;
    }

    private XMLMemento getReadMemento(String filename) {
        XMLMemento memento;
        File stateFile = this.getStateFile(filename);
        try {
            Throwable throwable = null;
            Object var5_5 = null;
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(stateFile), StandardCharsets.UTF_8);){
                memento = XMLMemento.createReadRoot((Reader)reader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            memento = null;
        }
        catch (Exception exception) {
            memento = null;
        }
        return memento;
    }

    private void saveMemento(XMLMemento memento, String filename) {
        File stateFile = this.getStateFile(filename);
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(stateFile), StandardCharsets.UTF_8);){
                memento.save((Writer)writer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            stateFile.delete();
        }
    }

    private File getStateFile(String filename) {
        if (this.getConfigurationLocation() == null) {
            return null;
        }
        File stateFile = new File(this.getConfigurationLocation(), filename);
        return stateFile;
    }

    public Set<String> findNewContributors(Set<String> contributors, Set<String> previousContributors) {
        HashSet<String> result = new HashSet<String>(contributors);
        Iterator<String> iter = previousContributors.iterator();
        while (iter.hasNext()) {
            result.remove(iter.next());
        }
        return result;
    }

    public void deleteStateFiles() {
        try {
            File stateFile = new File(this.getConfigurationLocation(), EXTENSION_COUNT_XML);
            stateFile.delete();
            stateFile = new File(this.getConfigurationLocation(), EXTENSION_NAMES_XML);
            stateFile.delete();
        }
        catch (RuntimeException runtimeException) {}
    }
}

