/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.editor;

import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.workspace.EMFCommandOperation;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.business.api.diagramtype.DiagramTypeDescriptorRegistry;
import org.eclipse.sirius.diagram.business.api.diagramtype.IDiagramTypeDescriptor;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.ui.internal.refresh.layout.SiriusCanonicalLayoutHandler;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.internal.commands.WrappingCommandIgnoringAffectedFiles;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.DDiagramEditorImpl;

public class DOperationHistoryListener
implements IOperationHistoryListener {
    private final DDiagramEditorImpl editor;

    public DOperationHistoryListener(DDiagramEditorImpl editor) {
        this.editor = editor;
    }

    public void historyNotification(OperationHistoryEvent event) {
        if (event.getEventType() == 4 && this.editor.getDiagramEditPart() != null && this.eventShouldTriggerArrange(event)) {
            SiriusCanonicalLayoutHandler.launchArrangeCommand(this.editor.getDiagramEditPart());
        }
    }

    protected boolean eventShouldTriggerArrange(OperationHistoryEvent event) {
        boolean result = true;
        if (event.getOperation() instanceof WrappingCommandIgnoringAffectedFiles) {
            ICommand originalCommand = ((WrappingCommandIgnoringAffectedFiles)event.getOperation()).getOriginalCommand();
            if (Messages.InitializeHiddenElementsCommand_label.equals(originalCommand.getLabel())) {
                result = false;
            } else if (Messages.SiriusContainerEditPolicy_arrangeCommandLabel.equals(originalCommand.getLabel())) {
                result = false;
            }
        } else if (event.getOperation() instanceof EMFCommandOperation) {
            EMFCommandOperation command = (EMFCommandOperation)event.getOperation();
            result = Messages.RefreshDiagramOnOpeningCommand_label.equals(command.getLabel()) ? false : (Messages.SiriusCanonicalLayoutCommand_label.equals(command.getLabel()) ? false : (org.eclipse.sirius.tools.api.Messages.CreateRepresentationCommand_label.equals(command.getLabel()) ? false : this.eventShouldTriggerArrangeWithSpecificCondition(event)));
        }
        return result;
    }

    protected boolean eventShouldTriggerArrangeWithSpecificCondition(OperationHistoryEvent event) {
        DiagramDescription diagramDescription;
        EObject resolveSemanticElement;
        boolean result = true;
        if (this.editor.getDiagramEditPart() != null && (resolveSemanticElement = this.editor.getDiagramEditPart().resolveSemanticElement()) instanceof DDiagram && (diagramDescription = ((DDiagram)resolveSemanticElement).getDescription()) != null) {
            for (IDiagramTypeDescriptor diagramTypeDescriptor : DiagramTypeDescriptorRegistry.getInstance().getAllDiagramTypeDescriptors()) {
                if (!diagramTypeDescriptor.getDiagramDescriptionProvider().handles(diagramDescription.eClass().getEPackage())) continue;
                result = diagramTypeDescriptor.getDiagramDescriptionProvider().eventShouldTriggerArrange(event);
                break;
            }
        }
        return result;
    }
}

