/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.graphical.figures;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.LayoutHelper;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.api.preferences.SiriusDiagramUiPreferencesKeys;
import org.eclipse.sirius.diagram.ui.tools.internal.util.EditPartQuery;
import org.eclipse.sirius.ext.draw2d.figure.FigureUtilities;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;

public class SiriusLayoutHelper
extends LayoutHelper {
    private IGraphicalEditPart containerEditPart;

    public SiriusLayoutHelper(IGraphicalEditPart editPart) {
        this.containerEditPart = editPart;
    }

    public Point getReferencePosition(IFigure parent, Viewport viewport, IGraphicalEditPart part) {
        Point result;
        Rectangle visibleAreainLogicalRef = viewport.getBounds().getCopy();
        GraphicalHelper.screen2logical((Rectangle)visibleAreainLogicalRef, (GraphicalEditPart)part);
        Rectangle parentBoundsInLogicalRef = parent.getBounds().getCopy();
        Point topLeft = parentBoundsInLogicalRef.getTopLeft();
        FigureUtilities.translateToAbsoluteByIgnoringScrollbar((IFigure)parent, (Point)topLeft);
        parentBoundsInLogicalRef.setLocation(topLeft);
        boolean parentIsVisible = visibleAreainLogicalRef.intersects(parentBoundsInLogicalRef);
        Rectangle parentVisibleArea = visibleAreainLogicalRef.getIntersection(parentBoundsInLogicalRef);
        if (!parentIsVisible) {
            result = parent.getBounds().getCenter().getCopy();
        } else if (parentVisibleArea.equals((Object)visibleAreainLogicalRef)) {
            result = parentVisibleArea.getCenter();
        } else {
            result = parentVisibleArea.getCenter();
            FigureUtilities.translateToRelativeByIgnoringScrollbar((IFigure)parent, (Point)result);
        }
        GraphicalHelper.logical2screen((Point)result, (IGraphicalEditPart)this.containerEditPart);
        EditPartQuery editPartQuery = new EditPartQuery(this.containerEditPart);
        Point snapLocation = editPartQuery.getSnapLocation((Request)new CreateRequest(), result);
        GraphicalHelper.screen2logical((Point)snapLocation, (GraphicalEditPart)this.containerEditPart);
        return snapLocation;
    }

    public Point updateClobberedPosition(IFigure clobbered, IFigure newlyAddedChild) {
        Point clobberedPosition = this.computeTranslatedPoint(this.determineReferencePoint(clobbered), clobbered, true);
        GraphicalHelper.logical2screen((Point)clobberedPosition, (IGraphicalEditPart)this.containerEditPart);
        EditPartQuery editPartQuery = new EditPartQuery(this.containerEditPart);
        Point snapLocation = editPartQuery.getSnapLocation((Request)new CreateRequest(), clobberedPosition);
        GraphicalHelper.screen2logical((Point)snapLocation, (GraphicalEditPart)this.containerEditPart);
        return snapLocation;
    }

    public Point determineReferencePoint(IFigure figure) {
        int pref = DiagramUIPlugin.getPlugin().getPreferenceStore().getInt(SiriusDiagramUiPreferencesKeys.PREF_NEWLY_CREATED_ELEMENTS_LAYOUT.name());
        Dimension size = figure.getSize().getCopy().union(figure.getPreferredSize());
        Rectangle bounds = figure.getBounds().getCopy().setSize(size);
        Point referencePoint = switch (pref) {
            case 1 -> bounds.getBottomLeft().getCopy();
            case 2 -> bounds.getTopRight().getCopy();
            default -> bounds.getRight().getCopy();
        };
        return referencePoint;
    }

    public Point computeTranslatedPoint(Point referencePoint, IFigure figure, boolean isFirstCreatedElement) {
        int shiftingValue = 30;
        if (isFirstCreatedElement && new EditPartQuery(this.containerEditPart).isSnapToGridEnabled()) {
            Dimension spacing = (Dimension)this.containerEditPart.getViewer().getProperty("SnapToGrid.GridSpacing");
            shiftingValue = spacing.width;
        }
        int pref = DiagramUIPlugin.getPlugin().getPreferenceStore().getInt(SiriusDiagramUiPreferencesKeys.PREF_NEWLY_CREATED_ELEMENTS_LAYOUT.name());
        int translationUnit = figure != null ? MapModeUtil.getMapMode((IFigure)figure).DPtoLP(shiftingValue) : shiftingValue;
        Point clobberedPosition = switch (pref) {
            case 1 -> referencePoint.getCopy().translate(0, translationUnit);
            case 2 -> referencePoint.getCopy().translate(translationUnit, 0);
            default -> referencePoint.getCopy().translate(translationUnit, 0);
        };
        return clobberedPosition;
    }
}

