/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.model.elements;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.php.internal.debug.core.zend.debugger.RemoteDebugger;
import org.eclipse.php.phpunit.model.connection.MessageException;
import org.eclipse.php.phpunit.model.connection.MessageFrame;
import org.eclipse.php.phpunit.model.elements.PHPUnitElement;
import org.eclipse.php.phpunit.model.elements.PHPUnitTraceFrame;

public abstract class PHPUnitTestEvent
extends PHPUnitElement {
    protected String message;
    protected String diff;
    protected List<PHPUnitTraceFrame> trace;

    public PHPUnitTestEvent(MessageException exception, PHPUnitElement parent, RemoteDebugger remoteDebugger) {
        super(exception, parent, remoteDebugger);
        this.message = exception.getMessage();
        this.diff = exception.getDiff();
        Map<Integer, MessageFrame> frames = exception.getTrace();
        if (frames == null || frames.isEmpty()) {
            return;
        }
        this.trace = new ArrayList<PHPUnitTraceFrame>(frames.size());
        for (Integer key : frames.keySet()) {
            this.trace.add(new PHPUnitTraceFrame(frames.get(key), this, remoteDebugger));
        }
    }

    public String getMessage() {
        return this.message;
    }

    public String getDiff() {
        return this.diff;
    }

    public List<PHPUnitTraceFrame> getTrace() {
        return this.trace;
    }
}

