/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.product;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.product.ProductDefinitionOperation;
import org.eclipse.pde.internal.ui.wizards.product.ProductDefinitonWizardPage;
import org.eclipse.pde.internal.ui.wizards.product.ProductIntroOperation;
import org.eclipse.pde.internal.ui.wizards.product.ProductIntroWizardPage;
import org.eclipse.swt.widgets.Shell;

public class ProductIntroWizard
extends Wizard {
    private ProductDefinitonWizardPage fProductDefinitionPage;
    private ProductIntroWizardPage fNewIntroPage;
    private final boolean fNeedNewProduct;
    private String fIntroId;
    private String fProductId;
    private String fPluginId;
    private String fApplication;
    private final IProduct fProduct;

    public ProductIntroWizard(IProduct product, boolean needNewProduct) {
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_DEFCON_WIZ);
        this.setNeedsProgressMonitor(true);
        this.fProduct = product;
        this.fNeedNewProduct = needNewProduct;
        this.setWindowTitle(PDEUIMessages.ProductIntroWizard_title);
    }

    public void addPages() {
        if (this.fNeedNewProduct) {
            this.fProductDefinitionPage = new ProductDefinitonWizardPage("product", this.fProduct);
            this.addPage((IWizardPage)this.fProductDefinitionPage);
        }
        this.fNewIntroPage = new ProductIntroWizardPage("intro", this.fProduct);
        this.addPage((IWizardPage)this.fNewIntroPage);
    }

    public boolean performFinish() {
        try {
            if (this.fNeedNewProduct) {
                this.fProductId = this.fProductDefinitionPage.getProductId();
                this.fPluginId = this.fProductDefinitionPage.getDefiningPlugin();
                this.fApplication = this.fProductDefinitionPage.getApplication();
                String newProductName = this.fProductDefinitionPage.getProductName();
                if (newProductName != null) {
                    this.fProduct.setName(newProductName);
                }
                this.fProduct.setProductId(this.getProductId());
                this.fProduct.setApplication(this.fApplication);
                this.getContainer().run(false, true, (IRunnableWithProgress)new ProductDefinitionOperation(this.fProduct, this.fPluginId, this.fProductId, this.fApplication, this.getContainer().getShell()));
            }
            this.fIntroId = this.fNewIntroPage.getIntroId();
            if (this.fPluginId == null) {
                this.fPluginId = this.fNewIntroPage.getDefiningPlugin();
            }
            this.getContainer().run(false, true, (IRunnableWithProgress)new ProductIntroOperation(this.fProduct, this.fPluginId, this.fIntroId, this.getContainer().getShell()));
        }
        catch (InvocationTargetException e) {
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)PDEUIMessages.ProductDefinitionWizard_error, (String)e.getTargetException().getMessage());
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public String getIntroId() {
        return this.fIntroId;
    }

    public String getProductId() {
        return this.fPluginId + "." + this.fProductId;
    }

    public String getApplication() {
        return this.fApplication;
    }
}

