/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards;

import java.io.File;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.pde.internal.core.feature.WorkspaceFeatureModel;
import org.eclipse.pde.internal.core.natures.PDE;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.ui.wizards.datatransfer.ProjectConfigurator;

public class FeatureProjectConfigurator
implements ProjectConfigurator {
    public boolean canConfigure(IProject project, Set<IPath> ignoredDirectories, IProgressMonitor monitor) {
        IFile featureFile = project.getFile("feature.xml");
        if (featureFile.exists()) {
            WorkspaceFeatureModel workspaceFeatureModel = new WorkspaceFeatureModel(featureFile);
            workspaceFeatureModel.load();
            return workspaceFeatureModel.isLoaded();
        }
        return featureFile.exists();
    }

    public void configure(IProject project, Set<IPath> ignoredDirectories, IProgressMonitor monitor) {
        if (!PDE.hasFeatureNature((IProject)project)) {
            try {
                CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.pde.FeatureNature", (IProgressMonitor)monitor);
            }
            catch (CoreException ex) {
                PDEPlugin.log(ex);
            }
        }
    }

    public boolean shouldBeAnEclipseProject(IContainer container, IProgressMonitor monitor) {
        return container.getFile(IPath.fromOSString((String)"feature.xml")).exists();
    }

    public Set<IFolder> getFoldersToIgnore(IProject project, IProgressMonitor monitor) {
        return null;
    }

    public Set<File> findConfigurableLocations(File root, IProgressMonitor monitor) {
        return null;
    }
}

