/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.IFeatureModelDelta;
import org.eclipse.pde.internal.core.IFeatureModelListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.isite.ISiteCategory;
import org.eclipse.pde.internal.core.isite.ISiteCategoryDefinition;
import org.eclipse.pde.internal.core.isite.ISiteFeature;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.dialogs.FeatureSelectionDialog;
import org.eclipse.pde.internal.ui.editor.ModelDataTransfer;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TreeSection;
import org.eclipse.pde.internal.ui.editor.feature.FeatureEditor;
import org.eclipse.pde.internal.ui.editor.site.SiteEditor;
import org.eclipse.pde.internal.ui.editor.site.SiteFeatureAdapter;
import org.eclipse.pde.internal.ui.editor.site.SiteLabelProvider;
import org.eclipse.pde.internal.ui.editor.site.SynchronizePropertiesAction;
import org.eclipse.pde.internal.ui.parts.TreePart;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.osgi.framework.Version;

public class CategorySection
extends TreeSection
implements IFeatureModelListener {
    private static final int BUTTON_ADD_CATEGORY = 0;
    private static final int BUTTON_ADD_FEATURE = 1;
    private static final int BUTTON_IMPORT_ENVIRONMENT = 3;
    private static final int BUTTON_BUILD_FEATURE = 5;
    private static final int BUTTON_BUILD_ALL = 6;
    private static int newCategoryCounter;
    private ISiteModel fModel;
    private TreePart fCategoryTreePart;
    private TreeViewer fCategoryViewer;
    private LabelProvider fSiteLabelProvider;
    private ISiteFeature[] cachedFeatures;
    private IStructuredSelection cachedSelection;

    public CategorySection(PDEFormPage formPage, Composite parent) {
        String[] stringArray = new String[7];
        stringArray[0] = PDEUIMessages.CategorySection_new;
        stringArray[1] = PDEUIMessages.CategorySection_add;
        stringArray[3] = PDEUIMessages.CategorySection_environment;
        stringArray[5] = PDEUIMessages.CategorySection_build;
        stringArray[6] = PDEUIMessages.CategorySection_buildAll;
        super(formPage, parent, 128, stringArray);
        this.getSection().setText(PDEUIMessages.CategorySection_title);
        this.getSection().setDescription(PDEUIMessages.CategorySection_desc);
    }

    @Override
    public void createClient(Section section, FormToolkit toolkit) {
        this.fModel = (ISiteModel)this.getPage().getModel();
        this.fModel.addModelChangedListener((IModelChangedListener)this);
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createViewerPartControl(container, 2, 2, toolkit);
        this.fCategoryTreePart = this.getTreePart();
        this.fCategoryViewer = this.fCategoryTreePart.getTreeViewer();
        this.fCategoryViewer.setContentProvider((IContentProvider)new CategoryContentProvider());
        this.fSiteLabelProvider = new SiteLabelProvider();
        this.fCategoryViewer.setLabelProvider((IBaseLabelProvider)this.fSiteLabelProvider);
        this.fCategoryViewer.setInput((Object)this.fModel.getSite());
        int ops = 19;
        Transfer[] transfers = new Transfer[]{ModelDataTransfer.getInstance()};
        if (this.isEditable()) {
            this.fCategoryViewer.addDropSupport(ops, transfers, (DropTargetListener)new ViewerDropAdapter((Viewer)this.fCategoryViewer){

                public void dragEnter(DropTargetEvent event) {
                    Object target = this.determineTarget(event);
                    if (target == null && event.detail == 1) {
                        event.detail = 2;
                    }
                    super.dragEnter(event);
                }

                public void dragOperationChanged(DropTargetEvent event) {
                    Object target = this.determineTarget(event);
                    if (target == null && event.detail == 1) {
                        event.detail = 2;
                    }
                    super.dragOperationChanged(event);
                }

                public void dragOver(DropTargetEvent event) {
                    Object target = this.determineTarget(event);
                    if (target == null && event.detail == 1) {
                        event.detail = 2;
                    }
                    super.dragOver(event);
                }

                /*
                 * WARNING - void declaration
                 */
                protected int determineLocation(DropTargetEvent event) {
                    Rectangle bounds;
                    void item;
                    Widget widget = event.item;
                    if (!(widget instanceof Item)) {
                        return 4;
                    }
                    Item item2 = (Item)widget;
                    Item cfr_ignored_0 = (Item)widget;
                    Point coordinates = new Point(event.x, event.y);
                    coordinates = this.getViewer().getControl().toControl(coordinates);
                    if (item != null && (bounds = this.getBounds((Item)item)) == null) {
                        return 4;
                    }
                    return 3;
                }

                public boolean performDrop(Object data) {
                    if (!(data instanceof Object[])) {
                        return false;
                    }
                    Object target = this.getCurrentTarget();
                    int op = this.getCurrentOperation();
                    Object[] objects = (Object[])data;
                    if (objects.length > 0 && objects[0] instanceof SiteFeatureAdapter) {
                        if (op == 1 && target != null) {
                            CategorySection.this.copyFeature((SiteFeatureAdapter)objects[0], target);
                        } else {
                            CategorySection.this.moveFeature((SiteFeatureAdapter)objects[0], target);
                        }
                        return true;
                    }
                    return false;
                }

                public boolean validateDrop(Object target, int operation, TransferData transferType) {
                    return target instanceof ISiteCategoryDefinition || target == null;
                }
            });
        }
        this.fCategoryViewer.addDragSupport(3, transfers, new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                ITreeSelection ssel = CategorySection.this.fCategoryViewer.getStructuredSelection();
                if (ssel == null || ssel.isEmpty() || !(ssel.getFirstElement() instanceof SiteFeatureAdapter)) {
                    event.doit = false;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                ITreeSelection ssel = CategorySection.this.fCategoryViewer.getStructuredSelection();
                event.data = ssel.toArray();
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        this.fCategoryTreePart.setButtonEnabled(0, this.isEditable());
        this.fCategoryTreePart.setButtonEnabled(1, this.isEditable());
        this.fCategoryTreePart.setButtonEnabled(5, this.isEditable());
        this.fCategoryTreePart.setButtonEnabled(6, this.isEditable());
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        this.initialize();
    }

    private boolean categoryExists(String name) {
        ISiteCategoryDefinition[] defs;
        ISiteCategoryDefinition[] iSiteCategoryDefinitionArray = defs = this.fModel.getSite().getCategoryDefinitions();
        int n = defs.length;
        int n2 = 0;
        while (n2 < n) {
            ISiteCategoryDefinition def = iSiteCategoryDefinitionArray[n2];
            String dname = def.getName();
            if (dname != null && dname.equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void copyFeature(SiteFeatureAdapter adapter, Object target) {
        ISiteFeature feature = this.findRealFeature(adapter);
        if (feature == null) {
            try {
                feature = this.copySiteFeature(this.fModel, adapter.feature);
                this.fModel.getSite().addFeatures(new ISiteFeature[]{feature});
            }
            catch (CoreException coreException) {
                return;
            }
        }
        if (target != null && target instanceof ISiteCategoryDefinition) {
            this.addCategory(feature, ((ISiteCategoryDefinition)target).getName());
        }
    }

    private void addCategory(ISiteFeature aFeature, String catName) {
        try {
            ISiteCategory cat;
            ISiteCategory[] cats;
            if (aFeature == null) {
                return;
            }
            ISiteCategory[] iSiteCategoryArray = cats = aFeature.getCategories();
            int n = cats.length;
            int n2 = 0;
            while (n2 < n) {
                cat = iSiteCategoryArray[n2];
                if (cat.getName().equals(catName)) {
                    return;
                }
                ++n2;
            }
            cat = this.fModel.getFactory().createCategory(aFeature);
            cat.setName(catName);
            this.expandCategory(catName);
            aFeature.addCategories(new ISiteCategory[]{cat});
        }
        catch (CoreException coreException) {}
    }

    private void moveFeature(SiteFeatureAdapter adapter, Object target) {
        ISiteFeature feature = this.findRealFeature(adapter);
        if (feature == null) {
            return;
        }
        if (adapter.category != null) {
            this.removeCategory(feature, adapter.category);
        }
        if (target != null && target instanceof ISiteCategoryDefinition) {
            this.addCategory(feature, ((ISiteCategoryDefinition)target).getName());
        }
    }

    @Override
    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleAddCategoryDefinition();
                break;
            }
            case 1: {
                this.handleNewFeature();
                break;
            }
            case 5: {
                this.handleBuild();
                break;
            }
            case 6: {
                ((SiteEditor)this.getPage().getPDEEditor()).handleBuild(this.fModel.getSite().getFeatures());
                break;
            }
            case 3: {
                this.handleImportEnvironment();
            }
        }
    }

    @Override
    protected void handleDoubleClick(IStructuredSelection ssel) {
        super.handleDoubleClick(ssel);
        Object selected = ssel.getFirstElement();
        if (selected instanceof SiteFeatureAdapter) {
            IFeature feature = CategorySection.findFeature(((SiteFeatureAdapter)selected).feature);
            FeatureEditor.openFeatureEditor(feature);
        }
    }

    @Override
    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
        this.updateButtons();
    }

    private void handleAddCategoryDefinition() {
        String name = NLS.bind((String)PDEUIMessages.CategorySection_newCategoryName, (Object)Integer.toString(++newCategoryCounter));
        while (this.categoryExists(name)) {
            name = NLS.bind((String)PDEUIMessages.CategorySection_newCategoryName, (Object)Integer.toString(++newCategoryCounter));
        }
        String label = NLS.bind((String)PDEUIMessages.CategorySection_newCategoryLabel, (Object)Integer.toString(newCategoryCounter));
        ISiteCategoryDefinition categoryDef = this.fModel.getFactory().createCategoryDefinition();
        try {
            categoryDef.setName(name);
            categoryDef.setLabel(label);
            this.fModel.getSite().addCategoryDefinitions(new ISiteCategoryDefinition[]{categoryDef});
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        this.fCategoryViewer.setSelection((ISelection)new StructuredSelection((Object)categoryDef), true);
    }

    private boolean handleRemove() {
        ITreeSelection ssel = this.fCategoryViewer.getStructuredSelection();
        Iterator iterator = ssel.iterator();
        boolean success = true;
        HashSet removedCategories = new HashSet();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object == null) continue;
            if (object instanceof ISiteCategoryDefinition) {
                if (this.handleRemoveCategoryDefinition((ISiteCategoryDefinition)object)) continue;
                success = false;
                continue;
            }
            SiteFeatureAdapter fa = (SiteFeatureAdapter)object;
            if (removedCategories.contains(fa.category) || this.handleRemoveSiteFeatureAdapter(fa)) continue;
            success = false;
        }
        return success;
    }

    private boolean handleRemoveCategoryDefinition(ISiteCategoryDefinition catDef) {
        try {
            Object[] children;
            Object[] objectArray = children = ((CategoryContentProvider)this.fCategoryViewer.getContentProvider()).getChildren(catDef);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                ISiteCategory[] cats;
                Object element = objectArray[n2];
                SiteFeatureAdapter adapter = (SiteFeatureAdapter)element;
                ISiteCategory[] iSiteCategoryArray = cats = adapter.feature.getCategories();
                int n3 = cats.length;
                int n4 = 0;
                while (n4 < n3) {
                    ISiteCategory cat = iSiteCategoryArray[n4];
                    if (adapter.category.equals(cat.getName())) {
                        adapter.feature.removeCategories(new ISiteCategory[]{cat});
                    }
                    ++n4;
                }
                if (adapter.feature.getCategories().length == 0) {
                    this.fModel.getSite().removeFeatures(new ISiteFeature[]{adapter.feature});
                }
                ++n2;
            }
            this.fModel.getSite().removeCategoryDefinitions(new ISiteCategoryDefinition[]{catDef});
            return true;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private boolean handleRemoveSiteFeatureAdapter(SiteFeatureAdapter adapter) {
        try {
            ISiteFeature feature = adapter.feature;
            if (adapter.category == null) {
                this.fModel.getSite().removeFeatures(new ISiteFeature[]{feature});
            } else {
                this.removeCategory(feature, adapter.category);
                if (feature.getCategories().length == 0) {
                    this.fModel.getSite().removeFeatures(new ISiteFeature[]{feature});
                }
            }
            return true;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private void removeCategory(ISiteFeature aFeature, String catName) {
        try {
            ISiteCategory[] cats;
            if (aFeature == null) {
                return;
            }
            ISiteCategory[] iSiteCategoryArray = cats = aFeature.getCategories();
            int n = cats.length;
            int n2 = 0;
            while (n2 < n) {
                ISiteCategory cat = iSiteCategoryArray[n2];
                if (catName.equals(cat.getName())) {
                    aFeature.removeCategories(new ISiteCategory[]{cat});
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
    }

    private ISiteFeature findRealFeature(SiteFeatureAdapter adapter) {
        ISiteFeature[] features;
        ISiteFeature featureCopy = adapter.feature;
        ISiteFeature[] iSiteFeatureArray = features = this.fModel.getSite().getFeatures();
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            ISiteFeature feature = iSiteFeatureArray[n2];
            if (feature.getId().equals(featureCopy.getId()) && feature.getVersion().equals(featureCopy.getVersion())) {
                return feature;
            }
            ++n2;
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        FeatureModelManager mng = PDECore.getDefault().getFeatureModelManager();
        mng.removeFeatureModelListener((IFeatureModelListener)this);
        this.fModel.removeModelChangedListener((IModelChangedListener)this);
        if (this.fSiteLabelProvider != null) {
            this.fSiteLabelProvider.dispose();
        }
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        ISiteFeature[] features;
        Action removeAction = new Action(PDEUIMessages.CategorySection_remove){

            public void run() {
                CategorySection.this.doGlobalAction(ActionFactory.DELETE.getId());
            }
        };
        removeAction.setEnabled(this.isEditable());
        manager.add((IAction)removeAction);
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
        ISelection selection = this.fCategoryViewer.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (features = this.getFeaturesFromSelection((IStructuredSelection)selection)).length > 0) {
            manager.add((IContributionItem)new Separator());
            SynchronizePropertiesAction synchronizeAction = new SynchronizePropertiesAction(features, this.fModel);
            manager.add((IAction)synchronizeAction);
            Action buildAction = new Action(PDEUIMessages.CategorySection_build){

                public void run() {
                    ((SiteEditor)CategorySection.this.getPage().getPDEEditor()).handleBuild(features);
                }
            };
            buildAction.setEnabled(this.isEditable());
            manager.add((IAction)buildAction);
        }
    }

    @Override
    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleRemove();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            return this.handleRemove();
        }
        return super.doGlobalAction(actionId);
    }

    public void refresh() {
        this.fCategoryViewer.refresh();
        this.updateButtons();
        super.refresh();
    }

    private void updateButtons() {
        if (!this.isEditable()) {
            return;
        }
        ITreeSelection sel = this.fCategoryViewer.getStructuredSelection();
        this.fCategoryTreePart.setButtonEnabled(5, this.getFeaturesFromSelection((IStructuredSelection)sel).length > 0);
        int featureCount = this.fModel.getSite().getFeatures().length;
        this.fCategoryTreePart.setButtonEnabled(6, featureCount > 0);
        this.fCategoryTreePart.setButtonEnabled(3, featureCount > 0);
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        this.markStale();
    }

    public void initialize() {
        this.refresh();
        FeatureModelManager mng = PDECore.getDefault().getFeatureModelManager();
        mng.addFeatureModelListener((IFeatureModelListener)this);
    }

    @Override
    protected void doPaste(Object target, Object[] objects) {
        try {
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof SiteFeatureAdapter) {
                    this.copyFeature((SiteFeatureAdapter)object, target);
                } else if (object instanceof ISiteCategoryDefinition) {
                    this.fModel.getSite().addCategoryDefinitions(new ISiteCategoryDefinition[]{(ISiteCategoryDefinition)object});
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
    }

    @Override
    protected boolean canPaste(Object target, Object[] objects) {
        if (target == null || target instanceof ISiteCategoryDefinition) {
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof SiteFeatureAdapter) {
                    return true;
                }
                if (object instanceof ISiteCategoryDefinition) {
                    ISiteCategoryDefinition[] defs;
                    String name = ((ISiteCategoryDefinition)object).getName();
                    ISiteCategoryDefinition[] iSiteCategoryDefinitionArray = defs = this.fModel.getSite().getCategoryDefinitions();
                    int n3 = defs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ISiteCategoryDefinition def = iSiteCategoryDefinitionArray[n4];
                        String dname = def.getName();
                        if (dname != null && dname.equals(name)) {
                            return false;
                        }
                        ++n4;
                    }
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private void handleBuild() {
        ITreeSelection sel = this.fCategoryViewer.getStructuredSelection();
        ((SiteEditor)this.getPage().getPDEEditor()).handleBuild(this.getFeaturesFromSelection((IStructuredSelection)sel));
    }

    private ISiteFeature[] getFeaturesFromSelection(IStructuredSelection sel) {
        if (sel.isEmpty()) {
            return new ISiteFeature[0];
        }
        if (this.cachedSelection == sel) {
            return this.cachedFeatures;
        }
        this.cachedSelection = sel;
        ArrayList<ISiteFeature> features = new ArrayList<ISiteFeature>(sel.size());
        for (Object next : sel) {
            if (!(next instanceof SiteFeatureAdapter) || ((SiteFeatureAdapter)next).feature == null) continue;
            features.add(((SiteFeatureAdapter)next).feature);
        }
        this.cachedFeatures = features.toArray(new ISiteFeature[features.size()]);
        return this.cachedFeatures;
    }

    public static IFeature findFeature(ISiteFeature siteFeature) {
        IFeatureModel model = PDECore.getDefault().getFeatureModelManager().findFeatureModelRelaxed(siteFeature.getId(), siteFeature.getVersion());
        if (model != null) {
            return model.getFeature();
        }
        return null;
    }

    private void handleImportEnvironment() {
        ITreeSelection sel = this.fCategoryViewer.getStructuredSelection();
        ISiteFeature[] selectedFeatures = this.getFeaturesFromSelection((IStructuredSelection)sel);
        BusyIndicator.showWhile((Display)this.fCategoryTreePart.getControl().getDisplay(), () -> new SynchronizePropertiesAction(selectedFeatures, this.getModel()).run());
    }

    private void handleNewFeature() {
        Control control = this.fCategoryViewer.getControl();
        BusyIndicator.showWhile((Display)control.getDisplay(), () -> {
            IFeatureModel[] allModels = PDECore.getDefault().getFeatureModelManager().getModels();
            ArrayList<IFeatureModel> newModels = new ArrayList<IFeatureModel>();
            IFeatureModel[] iFeatureModelArray = allModels;
            int n = allModels.length;
            int n2 = 0;
            while (n2 < n) {
                IFeatureModel allModel = iFeatureModelArray[n2];
                if (this.canAdd(allModel)) {
                    newModels.add(allModel);
                }
                ++n2;
            }
            IFeatureModel[] candidateModels = newModels.toArray(new IFeatureModel[newModels.size()]);
            FeatureSelectionDialog dialog = new FeatureSelectionDialog(this.fCategoryViewer.getTree().getShell(), candidateModels, true);
            if (dialog.open() == 0) {
                Object[] models = dialog.getResult();
                try {
                    this.doAdd(models);
                }
                catch (CoreException e) {
                    PDEPlugin.log(e);
                }
            }
        });
    }

    private boolean canAdd(IFeatureModel candidate) {
        ISiteFeature[] features = this.fModel.getSite().getFeatures();
        IFeature cfeature = candidate.getFeature();
        ISiteFeature[] iSiteFeatureArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            ISiteFeature bfeature = iSiteFeatureArray[n2];
            if (bfeature.getId().equals(cfeature.getId()) && bfeature.getVersion().equals(cfeature.getVersion())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static ISiteFeature createSiteFeature(ISiteModel model, IFeatureModel featureModel) throws CoreException {
        IFeature feature = featureModel.getFeature();
        ISiteFeature sfeature = model.getFactory().createFeature();
        sfeature.setId(feature.getId());
        sfeature.setVersion(feature.getVersion());
        sfeature.setURL("features/" + feature.getId() + "_" + CategorySection.formatVersion(feature.getVersion()) + ".jar");
        sfeature.setOS(feature.getOS());
        sfeature.setWS(feature.getWS());
        sfeature.setArch(feature.getArch());
        sfeature.setNL(feature.getNL());
        sfeature.setIsPatch(CategorySection.isFeaturePatch(feature));
        return sfeature;
    }

    private static String formatVersion(String version) {
        try {
            Version v = new Version(version);
            return v.toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return version;
        }
    }

    private static boolean isFeaturePatch(IFeature feature) {
        IFeatureImport[] imports;
        IFeatureImport[] iFeatureImportArray = imports = feature.getImports();
        int n = imports.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureImport import1 = iFeatureImportArray[n2];
            if (import1.isPatch()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public ISiteModel getModel() {
        return this.fModel;
    }

    public void doAdd(Object[] candidates) throws CoreException {
        String categoryName = null;
        ISelection selection = this.fCategoryViewer.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (element instanceof ISiteCategoryDefinition) {
                categoryName = ((ISiteCategoryDefinition)element).getName();
            } else if (element instanceof SiteFeatureAdapter) {
                categoryName = ((SiteFeatureAdapter)element).category;
            }
        }
        ISiteFeature[] added = new ISiteFeature[candidates.length];
        int i = 0;
        while (i < candidates.length) {
            IFeatureModel candidate = (IFeatureModel)candidates[i];
            ISiteFeature child = CategorySection.createSiteFeature(this.fModel, candidate);
            if (categoryName != null) {
                this.addCategory(child, categoryName);
            }
            added[i] = child;
            ++i;
        }
        this.fModel.getSite().addFeatures(added);
        if (added.length > 0) {
            if (categoryName != null) {
                this.expandCategory(categoryName);
            }
            this.fCategoryViewer.setSelection((ISelection)new StructuredSelection((Object)new SiteFeatureAdapter(categoryName, added[added.length - 1])), true);
        }
    }

    void fireSelection() {
        this.fCategoryViewer.setSelection(this.fCategoryViewer.getSelection());
    }

    public boolean setFormInput(Object input) {
        if (input instanceof ISiteCategoryDefinition) {
            this.fCategoryViewer.setSelection((ISelection)new StructuredSelection(input), true);
            return true;
        }
        if (input instanceof SiteFeatureAdapter) {
            String category = ((SiteFeatureAdapter)input).category;
            if (category != null) {
                this.expandCategory(category);
            }
            this.fCategoryViewer.setSelection((ISelection)new StructuredSelection(input), true);
            return true;
        }
        return super.setFormInput(input);
    }

    private void expandCategory(String category) {
        if (category != null) {
            ISiteCategoryDefinition[] catDefs;
            ISiteCategoryDefinition[] iSiteCategoryDefinitionArray = catDefs = this.fModel.getSite().getCategoryDefinitions();
            int n = catDefs.length;
            int n2 = 0;
            while (n2 < n) {
                ISiteCategoryDefinition catDef = iSiteCategoryDefinitionArray[n2];
                if (category.equals(catDef.getName())) {
                    this.fCategoryViewer.expandToLevel((Object)catDef, 1);
                    break;
                }
                ++n2;
            }
        }
    }

    public void modelsChanged(IFeatureModelDelta delta) {
        this.markStale();
    }

    private ISiteFeature copySiteFeature(ISiteModel model, ISiteFeature sourceFeature) throws CoreException {
        ISiteFeature sfeature = model.getFactory().createFeature();
        sfeature.setId(sourceFeature.getId());
        sfeature.setVersion(sourceFeature.getVersion());
        sfeature.setURL(sourceFeature.getURL());
        sfeature.setOS(sourceFeature.getOS());
        sfeature.setWS(sourceFeature.getWS());
        sfeature.setArch(sourceFeature.getArch());
        sfeature.setNL(sourceFeature.getNL());
        sfeature.setIsPatch(sourceFeature.isPatch());
        return sfeature;
    }

    class CategoryContentProvider
    implements ITreeContentProvider {
        CategoryContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ISiteFeature[] features;
            ArrayList<SiteFeatureAdapter> result = new ArrayList<SiteFeatureAdapter>();
            ISiteCategoryDefinition[] catDefs = CategorySection.this.fModel.getSite().getCategoryDefinitions();
            Collections.addAll(result, catDefs);
            ISiteFeature[] iSiteFeatureArray = features = CategorySection.this.fModel.getSite().getFeatures();
            int n = features.length;
            int n2 = 0;
            while (n2 < n) {
                ISiteFeature feature = iSiteFeatureArray[n2];
                if (feature.getCategories().length == 0) {
                    result.add(new SiteFeatureAdapter(null, feature));
                }
                ++n2;
            }
            return result.toArray();
        }

        /*
         * WARNING - void declaration
         */
        public Object[] getChildren(Object parent) {
            Object object = parent;
            if (object instanceof ISiteCategoryDefinition) {
                ISiteCategoryDefinition iSiteCategoryDefinition = (ISiteCategoryDefinition)object;
                ISiteCategoryDefinition cfr_ignored_0 = (ISiteCategoryDefinition)object;
                ISiteFeature[] features = CategorySection.this.fModel.getSite().getFeatures();
                HashSet<SiteFeatureAdapter> result = new HashSet<SiteFeatureAdapter>();
                ISiteFeature[] iSiteFeatureArray = features;
                int n = features.length;
                int n2 = 0;
                while (n2 < n) {
                    ISiteCategory[] cats;
                    ISiteFeature feature = iSiteFeatureArray[n2];
                    ISiteCategory[] iSiteCategoryArray = cats = feature.getCategories();
                    int n3 = cats.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        void catDef;
                        ISiteCategory cat = iSiteCategoryArray[n4];
                        if (cat.getDefinition() != null && cat.getDefinition().equals(catDef)) {
                            result.add(new SiteFeatureAdapter(cat.getName(), feature));
                        }
                        ++n4;
                    }
                    ++n2;
                }
                return result.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public boolean hasChildren(Object element) {
            Object object = element;
            if (object instanceof ISiteCategoryDefinition) {
                ISiteFeature[] features;
                ISiteCategoryDefinition iSiteCategoryDefinition = (ISiteCategoryDefinition)object;
                ISiteCategoryDefinition cfr_ignored_0 = (ISiteCategoryDefinition)object;
                ISiteFeature[] iSiteFeatureArray = features = CategorySection.this.fModel.getSite().getFeatures();
                int n = features.length;
                int n2 = 0;
                while (n2 < n) {
                    ISiteCategory[] cats;
                    ISiteFeature feature = iSiteFeatureArray[n2];
                    ISiteCategory[] iSiteCategoryArray = cats = feature.getCategories();
                    int n3 = cats.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        void catDef;
                        ISiteCategory cat = iSiteCategoryArray[n4];
                        if (cat.getDefinition() != null && cat.getDefinition().equals(catDef)) {
                            return true;
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            return false;
        }
    }
}

