/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.isite.ISite;
import org.eclipse.pde.internal.core.isite.ISiteArchive;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormEditorContributor;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.site.NewArchiveDialog;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.model.WorkbenchContentProvider;

public class ArchiveSection
extends PDESection {
    private Table fTable;
    private TableViewer fViewer;
    private ISiteModel fModel;
    private Button fAddButton;
    private Button fEditButton;
    private Button fRemoveButton;

    public ArchiveSection(PDEFormPage formPage, Composite parent) {
        super(formPage, parent, 128);
        this.getSection().setText(PDEUIMessages.SiteEditor_ArchiveSection_header);
        this.getSection().setDescription(PDEUIMessages.SiteEditor_ArchiveSection_instruction);
        this.createClient(this.getSection(), formPage.getManagedForm().getToolkit());
    }

    @Override
    public void createClient(Section section, FormToolkit toolkit) {
        this.fModel = (ISiteModel)this.getPage().getModel();
        this.fModel.addModelChangedListener((IModelChangedListener)this);
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        Composite container = toolkit.createComposite((Composite)section);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 2));
        container.setLayoutData((Object)new GridData(768));
        GridData data = new GridData(1808);
        section.setLayoutData((Object)data);
        this.createTable(container, toolkit);
        this.createTableViewer();
        this.createButtons(container, toolkit);
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        this.initialize();
    }

    public void dispose() {
        this.fModel.removeModelChangedListener((IModelChangedListener)this);
        super.dispose();
    }

    private void createButtons(Composite parent, FormToolkit toolkit) {
        Composite container = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(2));
        this.fAddButton = toolkit.createButton(container, PDEUIMessages.SiteEditor_add, 8);
        this.fAddButton.setLayoutData((Object)new GridData(768));
        this.fAddButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.showDialog(null)));
        this.fAddButton.setEnabled(this.isEditable());
        this.fEditButton = toolkit.createButton(container, PDEUIMessages.SiteEditor_edit, 8);
        this.fEditButton.setLayoutData((Object)new GridData(768));
        this.fEditButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            IStructuredSelection ssel = this.fViewer.getStructuredSelection();
            if (ssel.size() == 1) {
                this.showDialog((ISiteArchive)ssel.getFirstElement());
            }
        }));
        this.fRemoveButton = toolkit.createButton(container, PDEUIMessages.SiteEditor_remove, 8);
        this.fRemoveButton.setLayoutData((Object)new GridData(768));
        this.fRemoveButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleDelete()));
        this.fRemoveButton.setEnabled(false);
        this.fEditButton.setEnabled(false);
        toolkit.paintBordersFor(container);
    }

    private void createTable(Composite container, FormToolkit toolkit) {
        this.fTable = toolkit.createTable(container, 65538);
        GridData gd = new GridData(1808);
        gd.heightHint = 100;
        this.fTable.setLayoutData((Object)gd);
        TableColumn col1 = new TableColumn(this.fTable, 0);
        col1.setText(PDEUIMessages.SiteEditor_ArchiveSection_col1);
        TableColumn col2 = new TableColumn(this.fTable, 0);
        col2.setText(PDEUIMessages.SiteEditor_ArchiveSection_col2);
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 200));
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 200));
        this.fTable.setLayout((Layout)tlayout);
        this.fTable.setHeaderVisible(true);
        this.createContextMenu((Control)this.fTable);
    }

    private void createTableViewer() {
        this.fViewer = new TableViewer(this.fTable);
        this.fViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new ArchiveLabelProvider());
        this.fViewer.setInput((Object)this.getPage().getModel());
        this.fViewer.addSelectionChangedListener(event -> this.handleSelectionChanged());
    }

    private void handleSelectionChanged() {
        IStructuredSelection ssel = this.fViewer.getStructuredSelection();
        this.getManagedForm().fireSelectionChanged((IFormPart)this, (ISelection)ssel);
        this.getPage().getPDEEditor().setSelection((ISelection)ssel);
        if (!this.isEditable()) {
            return;
        }
        if (ssel != null) {
            this.fRemoveButton.setEnabled(!ssel.isEmpty());
            this.fEditButton.setEnabled(ssel.size() == 1);
        } else {
            this.fRemoveButton.setEnabled(false);
            this.fEditButton.setEnabled(false);
        }
    }

    private void showDialog(ISiteArchive archive) {
        ISiteModel model = (ISiteModel)this.getPage().getModel();
        BusyIndicator.showWhile((Display)this.fTable.getDisplay(), () -> {
            NewArchiveDialog dialog = new NewArchiveDialog(this.fTable.getShell(), model, archive);
            dialog.create();
            SWTUtil.setDialogSize((Dialog)dialog, 400, -1);
            dialog.open();
        });
    }

    private void handleDelete() {
        try {
            IStructuredSelection ssel = this.fViewer.getStructuredSelection();
            if (!ssel.isEmpty()) {
                ISiteArchive[] array = ssel.toList().toArray(new ISiteArchive[ssel.size()]);
                ISite site = ((ISiteModel)this.getPage().getModel()).getSite();
                site.removeArchives(array);
            }
        }
        catch (CoreException coreException) {}
    }

    @Override
    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            BusyIndicator.showWhile((Display)this.fTable.getDisplay(), this::handleDelete);
            return true;
        }
        if (actionId.equals(ActionFactory.SELECT_ALL.getId())) {
            this.handleSelectAll();
            return true;
        }
        return super.doGlobalAction(actionId);
    }

    public void refresh() {
        this.fViewer.refresh();
        super.refresh();
    }

    public void initialize() {
        this.refresh();
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        this.markStale();
    }

    private void createContextMenu(Control control) {
        MenuManager popupMenuManager = new MenuManager();
        IMenuListener listener = mng -> {
            Action removeAction = new Action(PDEUIMessages.SiteEditor_remove){

                public void run() {
                    ArchiveSection.this.doGlobalAction(ActionFactory.DELETE.getId());
                }
            };
            removeAction.setEnabled(this.isEditable());
            mng.add((IAction)removeAction);
            mng.add((IContributionItem)new Separator());
            PDEFormEditorContributor contributor = this.getPage().getPDEEditor().getContributor();
            contributor.contextMenuAboutToShow(mng);
        };
        popupMenuManager.addMenuListener(listener);
        popupMenuManager.setRemoveAllWhenShown(true);
        control.setMenu(popupMenuManager.createContextMenu(control));
    }

    public boolean setFormInput(Object input) {
        if (input instanceof ISiteArchive) {
            this.fViewer.setSelection((ISelection)new StructuredSelection(input), true);
            return true;
        }
        return super.setFormInput(input);
    }

    @Override
    protected void handleSelectAll() {
        TableViewer viewer = this.fViewer;
        if (viewer == null) {
            return;
        }
        Table table = viewer.getTable();
        if (table == null) {
            return;
        }
        table.selectAll();
        this.handleSelectionChanged();
    }

    static class ArchiveLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ArchiveLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            ISiteArchive archive = (ISiteArchive)obj;
            return switch (index) {
                case 0 -> archive.getPath();
                case 1 -> archive.getURL();
                default -> "";
            };
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }

    static class ContentProvider
    implements IStructuredContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object parent) {
            ISiteModel model = (ISiteModel)parent;
            return model.getSite().getArchives();
        }
    }

    class FolderProvider
    extends WorkbenchContentProvider {
        FolderProvider() {
        }

        public boolean hasChildren(Object element) {
            Object[] children;
            Object[] objectArray = children = this.getChildren(element);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (child instanceof IFolder) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

