/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.spy.preferences.viewer;

import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.pde.spy.preferences.model.PreferenceEntry;
import org.eclipse.swt.graphics.Font;

public class PreferenceMapLabelProvider
extends ObservableMapLabelProvider
implements IFontProvider {
    private LocalResourceManager resourceManager;
    private final FontDescriptor fontDescriptor;

    public PreferenceMapLabelProvider(FontDescriptor fontDescriptor, IObservableMap<Object, Object>[] attributeMaps) {
        super(attributeMaps);
        Assert.isNotNull((Object)fontDescriptor, (String)"<fontDescriptor> must not be null");
        this.fontDescriptor = fontDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    public String getColumnText(Object element, int columnIndex) {
        Object object;
        String columnText = super.getColumnText(element, columnIndex);
        if ("".equals(columnText) && (object = element) instanceof PreferenceEntry) {
            PreferenceEntry preferenceEntry = (PreferenceEntry)object;
            PreferenceEntry cfr_ignored_0 = (PreferenceEntry)object;
            switch (columnIndex) {
                case 1: {
                    void entry;
                    columnText = entry.getKey();
                    break;
                }
                case 2: {
                    void entry;
                    columnText = entry.getOldValue();
                    break;
                }
                case 3: {
                    void entry;
                    columnText = entry.getNewValue();
                    break;
                }
                default: {
                    void entry;
                    columnText = entry.getNodePath();
                }
            }
        }
        return columnText;
    }

    /*
     * WARNING - void declaration
     */
    public Font getFont(Object element) {
        Object object = element;
        if (object instanceof PreferenceEntry) {
            void preferenceEntry;
            PreferenceEntry preferenceEntry2 = (PreferenceEntry)object;
            PreferenceEntry cfr_ignored_0 = (PreferenceEntry)object;
            if (preferenceEntry.isRecentlyChanged()) {
                return (Font)this.getResourceManager().create((DeviceResourceDescriptor)this.fontDescriptor);
            }
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        if (this.resourceManager != null) {
            this.resourceManager.dispose();
        }
    }

    protected ResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.resourceManager;
    }
}

