/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.use;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.pde.api.tools.ui.internal.IApiToolsHelpContextIds;
import org.eclipse.pde.api.tools.ui.internal.SWTFactory;
import org.eclipse.pde.api.tools.ui.internal.use.Messages;
import org.eclipse.pde.api.tools.ui.internal.use.UsePatternPage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class DescriptionPatternPage
extends UsePatternPage {
    static final String PAGE_NAME = "description";
    private final int kind = -1;
    private Button kbutton = null;
    private Text patterntext = null;
    private String pattern = null;

    public DescriptionPatternPage(String pattern, int kind) {
        super(PAGE_NAME, Messages.DescriptionPatternPage_package_name_pattern, null);
        this.pattern = pattern;
        this.resetMessage(this.pattern != null);
    }

    public void createControl(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 1, 1, 768);
        SWTFactory.createLabel(comp, Messages.DescriptionPatternPage_patetern, 1);
        this.patterntext = SWTFactory.createSingleText(comp, 1);
        this.patterntext.addModifyListener(e -> {
            this.setDirty();
            this.setPageComplete(this.isPageComplete());
        });
        if (this.pattern != null) {
            this.patterntext.setText(this.pattern);
        }
        this.patterntext.selectAll();
        this.patterntext.setFocus();
        this.kbutton = SWTFactory.createCheckButton(comp, Messages.DescriptionPatternPage_api_pattern, null, -1 == 1 || -1 == -1, 1);
        this.setControl((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IApiToolsHelpContextIds.APITOOLS_DESCRIPTION_PATTERN_WIZARD_PAGE);
    }

    public boolean isPageComplete() {
        String newtext = this.patterntext.getText().trim();
        if ("".equals(newtext)) {
            if (this.pageDirty()) {
                this.setErrorMessage(Messages.DescriptionPatternPage_provide_regex);
            } else {
                this.setMessage(Messages.DescriptionPatternPage_provide_regex);
            }
            return false;
        }
        try {
            Pattern.compile(newtext);
        }
        catch (PatternSyntaxException pse) {
            this.setErrorMessage(pse.getDescription());
            return false;
        }
        this.resetMessage(this.pattern != null);
        return true;
    }

    @Override
    protected void resetMessage(boolean isediting) {
        this.setErrorMessage(null);
        if (isediting) {
            this.setMessage(Messages.DescriptionPatternPage_edit_package_pattern);
        } else {
            this.setMessage(Messages.DescriptionPatternPage_create_package__pattern);
        }
    }

    public IWizardPage getNextPage() {
        return null;
    }

    @Override
    public int getKind() {
        return this.kbutton.getSelection() ? 1 : 2;
    }

    @Override
    public String getPattern() {
        return this.patterntext.getText().trim();
    }
}

