/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.wizards;

import com.ibm.icu.text.SimpleDateFormat;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.commons.core.CoreUtil;
import org.eclipse.mylyn.commons.core.ICoreRunnable;
import org.eclipse.mylyn.commons.ui.CommonUiUtil;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.internal.commons.core.ZipFileUtil;
import org.eclipse.mylyn.internal.tasks.core.ITasksCoreConstants;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.wizards.Messages;
import org.eclipse.mylyn.internal.tasks.ui.wizards.TaskDataImportWizardPage;
import org.eclipse.mylyn.internal.tasks.ui.workingsets.TaskWorkingSetUpdater;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class TaskDataImportWizard
extends Wizard
implements IImportWizard {
    private TaskDataImportWizardPage importPage = null;

    public TaskDataImportWizard() {
        IDialogSettings masterSettings = TasksUiPlugin.getDefault().getDialogSettings();
        this.setDialogSettings(this.getSettingsSection(masterSettings));
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.TaskDataImportWizard_Import);
    }

    private IDialogSettings getSettingsSection(IDialogSettings master) {
        IDialogSettings settings = master.getSection("org.eclipse.mylyn.tasklist.ui.importWizard");
        if (settings == null) {
            settings = master.addNewSection("org.eclipse.mylyn.tasklist.ui.importWizard");
        }
        return settings;
    }

    public void addPages() {
        this.importPage = new TaskDataImportWizardPage();
        this.importPage.setWizard((IWizard)this);
        this.addPage((IWizardPage)this.importPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean canFinish() {
        return this.importPage.isPageComplete();
    }

    public boolean performFinish() {
        String sourceZip = this.importPage.getSourceZipFile();
        File sourceZipFile = new File(sourceZip);
        if (!sourceZipFile.exists()) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.TaskDataImportWizard_File_not_found, (String)(sourceZipFile.toString() + Messages.TaskDataImportWizard_could_not_be_found));
            return false;
        }
        if (!CoreUtil.TEST_MODE && !MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.TaskDataImportWizard_confirm_overwrite, (String)Messages.TaskDataImportWizard_existing_task_data_about_to_be_erased_proceed)) {
            return false;
        }
        if (TaskDataImportWizard.performFinish(sourceZipFile, this.getContainer())) {
            this.importPage.saveSettings();
            return true;
        }
        return false;
    }

    public static boolean performFinish(File sourceZipFile, IWizardContainer container) {
        block8: {
            TasksUi.getTaskActivityManager().deactivateTask(TasksUi.getTaskActivityManager().getActiveTask());
            try {
                try {
                    TaskWorkingSetUpdater.setEnabled(false);
                    if (container != null) {
                        CommonUiUtil.run((IRunnableContext)container, (ICoreRunnable)new FileCopyJob(sourceZipFile));
                        break block8;
                    }
                    WorkbenchUtil.busyCursorWhile((ICoreRunnable)new FileCopyJob(sourceZipFile));
                }
                catch (CoreException e) {
                    Status status = new Status(4, "org.eclipse.mylyn.tasks.ui", NLS.bind((String)"Problems encountered importing task data: {0}", (Object)e.getMessage()), (Throwable)e);
                    TasksUiInternal.logAndDisplayStatus(Messages.TaskDataImportWizard_task_data_import_failed, (IStatus)status);
                    TaskWorkingSetUpdater.setEnabled(true);
                }
                catch (OperationCanceledException operationCanceledException) {
                    TaskWorkingSetUpdater.setEnabled(true);
                }
            }
            finally {
                TaskWorkingSetUpdater.setEnabled(true);
            }
        }
        return true;
    }

    static class FileCopyJob
    implements ICoreRunnable {
        private static final String PREFIX_BACKUP = ".backup-";
        private final String JOB_LABEL = Messages.TaskDataImportWizard_Importing_Data;
        private final File sourceZipFile;

        public FileCopyJob(File sourceZipFile) {
            this.sourceZipFile = sourceZipFile;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            block14: {
                try {
                    boolean hasDefaultTaskList = false;
                    int numEntries = 0;
                    try (ZipFile zipFile = new ZipFile(this.sourceZipFile, 1);){
                        Enumeration<? extends ZipEntry> entries = zipFile.entries();
                        while (entries.hasMoreElements()) {
                            ZipEntry entry = entries.nextElement();
                            if (entry.getName().equals("tasks.xml.zip")) {
                                hasDefaultTaskList = true;
                            }
                            ++numEntries;
                        }
                    }
                    if (numEntries <= 0) break block14;
                    monitor.beginTask(this.JOB_LABEL, numEntries);
                    Job.getJobManager().beginRule(ITasksCoreConstants.ROOT_SCHEDULING_RULE, monitor);
                    if (monitor.isCanceled()) {
                        return;
                    }
                    try {
                        ZipFileUtil.unzipFiles((File)this.sourceZipFile, (String)TasksUiPlugin.getDefault().getDataDirectory(), (IProgressMonitor)monitor);
                        if (!hasDefaultTaskList) {
                            this.renameTaskList();
                        }
                        this.readTaskListData();
                    }
                    catch (IOException e) {
                        Status status = new Status(4, "org.eclipse.mylyn.tasks.ui", e.getMessage(), (Throwable)e);
                        throw new CoreException((IStatus)status);
                    }
                }
                finally {
                    Job.getJobManager().endRule(ITasksCoreConstants.ROOT_SCHEDULING_RULE);
                    monitor.done();
                }
            }
        }

        private void readTaskListData() {
            if (!CoreUtil.TEST_MODE) {
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            TasksUiPlugin.getDefault().reloadDataDirectory();
                        }
                        catch (CoreException e) {
                            TasksUiInternal.displayStatus(Messages.TaskDataImportWizard_Import_Error, e.getStatus());
                        }
                    }
                });
            } else {
                TasksUiPlugin.getDefault().initializeDataSources();
            }
        }

        private void renameTaskList() {
            File taskListFileSnapshot;
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd-HHmmss", Locale.ENGLISH);
            String date = format.format(new Date());
            File taskListFile = new File(TasksUiPlugin.getDefault().getDataDirectory(), "tasks.xml.zip");
            if (taskListFile.exists()) {
                taskListFile.renameTo(new File(taskListFile.getParentFile(), taskListFile.getName() + PREFIX_BACKUP + date));
            }
            if ((taskListFileSnapshot = new File(TasksUiPlugin.getDefault().getDataDirectory(), ".tasks.xml.zip")).exists()) {
                taskListFileSnapshot.renameTo(new File(taskListFile.getParentFile(), taskListFileSnapshot.getName() + PREFIX_BACKUP + date));
            }
        }
    }
}

