/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;

public class TaskEditorInputFactory
implements IElementFactory {
    public static final String TAG_TASK_HANDLE = "taskHandle";
    public static final String ID_FACTORY = "org.eclipse.mylyn.tasks.ui.elementFactories.task.editor";

    public IAdaptable createElement(IMemento memento) {
        String handle = memento.getString(TAG_TASK_HANDLE);
        AbstractTask task = TasksUiPlugin.getTaskList().getTask(handle);
        if (task != null) {
            TaskRepository taskRepository = TasksUi.getRepositoryManager().getRepository(task.getConnectorKind(), task.getRepositoryUrl());
            if (taskRepository != null) {
                return new TaskEditorInput(taskRepository, (ITask)task);
            }
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", "Repository for connector kind " + task.getConnectorKind() + " with url " + task.getRepositoryUrl() + " cannont be found."));
        } else {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", "Failed to restore task editor: Task with handle \"" + handle + "\" could not be found in task list."));
        }
        return null;
    }

    public static void saveState(IMemento memento, TaskEditorInput input) {
        if (input.getTask() != null) {
            memento.putString(TAG_TASK_HANDLE, input.getTask().getHandleIdentifier());
        }
    }
}

