/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.internal.tasks.ui.Messages;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TaskOpenEvent;
import org.eclipse.mylyn.internal.tasks.ui.util.TaskOpenListener;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class OpenRepositoryTaskJob
extends Job {
    private final String repositoryUrl;
    private final String repositoryKind;
    private final String taskId;
    private final String taskUrl;
    private ITask task;
    private TaskOpenListener listener;
    private final long timestamp;
    private String taskKey;
    private TaskRepository repository;

    public OpenRepositoryTaskJob(TaskRepository repository, String taskKey, String taskUrl, IWorkbenchPage page) {
        super(MessageFormat.format(Messages.OpenRepositoryTaskJob_Opening_repository_task_X, taskKey));
        this.repositoryKind = repository.getConnectorKind();
        this.taskId = null;
        this.repositoryUrl = repository.getRepositoryUrl();
        this.taskUrl = taskUrl;
        this.timestamp = 0L;
        this.repository = repository;
        this.taskKey = taskKey;
    }

    public OpenRepositoryTaskJob(String repositoryKind, String repositoryUrl, String taskId, String taskUrl, IWorkbenchPage page) {
        this(repositoryKind, repositoryUrl, taskId, taskUrl, 0L, page);
    }

    public OpenRepositoryTaskJob(String repositoryKind, String repositoryUrl, String taskId, String taskUrl, long timestamp, IWorkbenchPage page) {
        super(MessageFormat.format(Messages.OpenRepositoryTaskJob_Opening_repository_task_X, taskId));
        this.repositoryKind = repositoryKind;
        this.taskId = taskId;
        this.repositoryUrl = repositoryUrl;
        this.taskUrl = taskUrl;
        this.timestamp = timestamp;
    }

    public OpenRepositoryTaskJob(IWorkbenchPage page, String repositoryKind, String repositoryUrl, String taskIdOrKey, String taskUrl) {
        this(repositoryKind, repositoryUrl, taskIdOrKey, taskUrl, page);
        this.taskKey = taskIdOrKey;
    }

    public ITask getTask() {
        return this.task;
    }

    public void setListener(TaskOpenListener listener) {
        this.listener = listener;
    }

    public IStatus run(IProgressMonitor monitor) {
        block8: {
            monitor.beginTask(Messages.OpenRepositoryTaskJob_Opening_Remote_Task, 10);
            if (this.repository == null) {
                this.repository = TasksUi.getRepositoryManager().getRepository(this.repositoryKind, this.repositoryUrl);
            }
            if (this.repository == null) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError(null, (String)Messages.OpenRepositoryTaskJob_Repository_Not_Found, (String)(MessageFormat.format(Messages.OpenRepositoryTaskJob_Could_not_find_repository_configuration_for_X, OpenRepositoryTaskJob.this.repositoryUrl) + "\n" + MessageFormat.format(Messages.OpenRepositoryTaskJob_Please_set_up_repository_via_X, Messages.TasksUiPlugin_Task_Repositories)));
                        TasksUiUtil.openUrl(OpenRepositoryTaskJob.this.taskUrl);
                    }
                });
                return Status.OK_STATUS;
            }
            AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(this.repositoryKind);
            try {
                try {
                    final TaskData taskData = this.getTaskData(connector, monitor);
                    if (taskData != null) {
                        this.task = TasksUi.getRepositoryModel().createTask(this.repository, taskData.getTaskId());
                        TasksUiPlugin.getTaskDataManager().putUpdatedTaskData(this.task, taskData, true);
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                List commentAttributes;
                                TaskOpenEvent event = TasksUiInternal.openTask(OpenRepositoryTaskJob.this.task, OpenRepositoryTaskJob.this.taskId);
                                if (OpenRepositoryTaskJob.this.listener != null && event != null) {
                                    OpenRepositoryTaskJob.this.listener.taskOpened(event);
                                }
                                if (OpenRepositoryTaskJob.this.timestamp != 0L && event != null && (commentAttributes = taskData.getAttributeMapper().getAttributesByType(taskData, "comment")).size() > 0) {
                                    for (TaskAttribute commentAttribute : commentAttributes) {
                                        Date dateValue;
                                        TaskAttribute commentCreateDate = commentAttribute.getMappedAttribute("task.common.comment.date");
                                        if (commentCreateDate == null || (dateValue = taskData.getAttributeMapper().getDateValue(commentCreateDate)).getTime() < OpenRepositoryTaskJob.this.timestamp) continue;
                                        TaskAttribute dn = commentAttribute.getMappedAttribute("task.common.comment.number");
                                        TaskEditor editor = (TaskEditor)event.getEditor();
                                        if (dn == null) break;
                                        editor.selectReveal("task.common.comment-" + dn.getValue());
                                        break;
                                    }
                                }
                            }
                        });
                        break block8;
                    }
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TasksUiUtil.openUrl(OpenRepositoryTaskJob.this.taskUrl);
                        }
                    });
                }
                catch (CoreException e) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TasksUiInternal.displayStatus(Messages.OpenRepositoryTaskJob_Unable_to_open_task, e.getStatus());
                        }
                    });
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }
        return Status.OK_STATUS;
    }

    TaskData getTaskData(AbstractRepositoryConnector connector, IProgressMonitor monitor) throws CoreException {
        if (this.taskId != null && this.taskKey != null && connector.supportsSearchByTaskKey(this.repository)) {
            try {
                TaskData data = this.getTaskDataByKey(connector, monitor);
                if (data != null) {
                    return data;
                }
            }
            catch (RuntimeException | CoreException data) {
                // empty catch block
            }
            try {
                return connector.getTaskData(this.repository, this.taskId, monitor);
            }
            catch (RuntimeException | CoreException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", NLS.bind((String)"Could not find task with ID \"{0}\" on repository {1}.", (Object)this.taskId, (Object)this.repository), e));
            }
        }
        if (this.taskId != null) {
            return connector.getTaskData(this.repository, this.taskId, monitor);
        }
        if (this.taskKey != null && connector.supportsSearchByTaskKey(this.repository)) {
            return this.getTaskDataByKey(connector, monitor);
        }
        return null;
    }

    private TaskData getTaskDataByKey(AbstractRepositoryConnector connector, IProgressMonitor monitor) throws CoreException {
        TaskData searchTaskData = connector.searchByTaskKey(this.repository, this.taskKey, monitor);
        if (searchTaskData != null && searchTaskData.isPartial()) {
            return connector.getTaskData(this.repository, searchTaskData.getTaskId(), monitor);
        }
        return searchTaskData;
    }
}

