/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui.pr;

import java.io.IOException;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.github.core.PullRequest;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.internal.github.core.pr.PullRequestComposite;
import org.eclipse.mylyn.internal.github.core.pr.PullRequestConnector;
import org.eclipse.mylyn.internal.github.core.pr.PullRequestUtils;
import org.eclipse.mylyn.internal.github.ui.GitHubUi;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.mylyn.resources.ui.ResourcesUi;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskActivationAdapter;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.TasksUi;

public class PullRequestContextSynchronizer
extends TaskActivationAdapter {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void taskActivated(ITask task) {
        if (task == null) {
            return;
        }
        if (!"githubPullRequests".equals(task.getConnectorKind())) {
            return;
        }
        IInteractionContext context = ContextCore.getContextManager().getActiveContext();
        if (context == null) {
            return;
        }
        try {
            TaskData data = TasksUi.getTaskDataManager().getTaskData(task);
            PullRequestComposite prComp = PullRequestConnector.getPullRequest((TaskData)data);
            if (prComp == null) {
                return;
            }
            PullRequest request = prComp.getRequest();
            Repository repository = PullRequestUtils.getRepository((PullRequest)request);
            if (repository == null) {
                return;
            }
            Throwable throwable = null;
            Object var8_12 = null;
            try {
                RevWalk walk = new RevWalk(repository);
                try {
                    try (TreeWalk diffs = new TreeWalk(walk.getObjectReader());){
                        diffs.setFilter(TreeFilter.ANY_DIFF);
                        diffs.setRecursive(true);
                        diffs.addTree((AnyObjectId)walk.parseCommit((AnyObjectId)ObjectId.fromString((String)request.getHead().getSha())).getTree());
                        diffs.addTree((AnyObjectId)walk.parseCommit((AnyObjectId)ObjectId.fromString((String)request.getBase().getSha())).getTree());
                        HashSet<IFile> resources = new HashSet<IFile>();
                        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                        String base = repository.getWorkTree().getAbsolutePath() + "/";
                        while (diffs.next()) {
                            IFile file = root.getFileForLocation(Path.fromOSString((String)(base + diffs.getPathString())));
                            if (file == null) continue;
                            resources.add(file);
                        }
                        if (!resources.isEmpty()) {
                            ResourcesUi.addResourceToContext(resources, (InteractionEvent.Kind)InteractionEvent.Kind.SELECTION);
                        }
                    }
                    if (walk == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (walk == null) throw throwable;
                    walk.close();
                    throw throwable;
                }
                walk.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (MissingObjectException data) {
            return;
        }
        catch (IOException e) {
            GitHubUi.logError(e);
            return;
        }
        catch (CoreException e) {
            GitHubUi.logError(e);
        }
    }
}

