/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.query;

import org.eclipse.core.runtime.Platform;

public enum BytesDisplay {
    Bytes,
    Kilobytes,
    Megabytes,
    Gigabytes,
    Smart;

    public static final BytesDisplay DEFAULT;
    public static final String PROPERTY_NAME = "bytes_display";
    private static BytesDisplay currentValue;

    static {
        DEFAULT = Bytes;
        currentValue = BytesDisplay.parse(System.getProperty(PROPERTY_NAME));
        String propValue = System.getProperty(PROPERTY_NAME);
        if (propValue == null) {
            String MATUI_PLUGIN = "org.eclipse.mat.ui";
            String prefValue = Platform.getPreferencesService().getString(MATUI_PLUGIN, PROPERTY_NAME, null, null);
            BytesDisplay.setCurrentValue(BytesDisplay.parse(prefValue));
        } else {
            BytesDisplay.setCurrentValue(BytesDisplay.parse(propValue));
        }
    }

    public static BytesDisplay parse(String value) {
        if (value != null && value.length() > 0) {
            BytesDisplay[] bytesDisplayArray = BytesDisplay.values();
            int n = bytesDisplayArray.length;
            int n2 = 0;
            while (n2 < n) {
                BytesDisplay v = bytesDisplayArray[n2];
                if (v.toString().equalsIgnoreCase(value)) {
                    return v;
                }
                ++n2;
            }
        }
        return DEFAULT;
    }

    public static BytesDisplay getCurrentValue() {
        return currentValue;
    }

    public static void setCurrentValue(BytesDisplay val) {
        System.setProperty(PROPERTY_NAME, val.toString());
        currentValue = val;
    }
}

