/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDEPlugin;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.CodeFormatterUtil;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.IndentUtil;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.STPHeuristicScanner;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.STPIndenter;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.STPPartitionScanner;

public class STPAutoEditStrategy
extends DefaultIndentLineAutoEditStrategy {
    private static final String LINE_COMMENT = "//";
    private boolean fCloseBrace = true;
    private String fPartitioning;
    private IProject fProject;

    public STPAutoEditStrategy(String fPartitioning, IProject project) {
        this.fPartitioning = fPartitioning;
        this.fProject = project;
    }

    private static int getBlockBalance(IDocument document, int offset) {
        if (offset < 1) {
            return -1;
        }
        if (offset >= document.getLength()) {
            return 1;
        }
        int begin = offset;
        int end = offset - 1;
        STPHeuristicScanner scanner = new STPHeuristicScanner(document);
        do {
            begin = scanner.findOpeningPeer(begin - 1, '{', '}');
            end = scanner.findClosingPeer(end + 1, '{', '}');
            if (begin == -1 && end == -1) {
                return 0;
            }
            if (begin != -1) continue;
            return -1;
        } while (end != -1);
        return 1;
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        boolean isNewLine;
        boolean modified = false;
        boolean bl = isNewLine = command.length == 0 && command.text != null && this.isLineDelimiter(document, command.text);
        if (isNewLine) {
            this.smartIndentAfterNewLine(document, command);
        } else if (command.text.length() == 1) {
            this.smartIndentOnKeypress(document, command);
        } else if (command.text.length() > 1 && command.text.trim().length() != 0) {
            this.smartPaste(document, command);
        }
        if (command.text.equals("\"") && !this.inStringOrComment(document, command)) {
            command.text = "\"\"";
            modified = true;
        } else if (command.text.equals("(") && !this.inStringOrComment(document, command)) {
            command.text = "()";
            modified = true;
        } else if (command.text.equals("[") && !this.inStringOrComment(document, command)) {
            command.text = "[]";
            modified = true;
        }
        if (modified) {
            command.caretOffset = command.offset + 1;
            command.shiftsCaret = false;
        }
        super.customizeDocumentCommand(document, command);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean inStringOrComment(IDocument d, DocumentCommand c) {
        int docLength = d.getLength();
        if (c.offset == -1 || docLength == 0) {
            return false;
        }
        try {
            ITypedRegion partition = TextUtilities.getPartition((IDocument)d, (String)this.fPartitioning, (int)c.offset, (boolean)false);
            String partitionType = partition.getType();
            if (c.offset > 0 && ("__stp_comment".equals(partitionType) || "__stp_multiline_comment".equals(partitionType) || "__stp_string".equals(partitionType))) {
                return true;
            }
            IRegion lineInfo = d.getLineInformationOfOffset(c.offset);
            int offset = lineInfo.getOffset();
            boolean inChar = false;
            boolean inString = false;
            boolean inComment = false;
            int i = offset;
            while (true) {
                if (i >= c.offset) {
                    return inString || inChar || inComment;
                }
                char ch = d.getChar(i);
                switch (ch) {
                    case '\"': {
                        if (inChar) break;
                        inString = !inString;
                        break;
                    }
                    case '\'': {
                        if (inString) break;
                        inChar = !inChar;
                        break;
                    }
                    case '\\': {
                        ++i;
                        break;
                    }
                    case '/': {
                        if (inString || inChar) break;
                        ch = d.getChar(i + 1);
                        if (ch == '/') {
                            return true;
                        }
                        if (ch != '*') break;
                        inComment = true;
                        break;
                    }
                    case '#': {
                        if (inString || inChar) break;
                        return true;
                    }
                    case '*': {
                        if (inString || inChar || !inComment || (ch = d.getChar(i + 1)) != '/') break;
                        inComment = false;
                        break;
                    }
                }
                ++i;
            }
        }
        catch (BadLocationException e) {
            IDEPlugin.log(e);
            return false;
        }
    }

    private void smartIndentAfterNewLine(IDocument d, DocumentCommand c) {
        int docLength = d.getLength();
        if (c.offset == -1 || docLength == 0) {
            return;
        }
        int addIndent = 0;
        STPHeuristicScanner scanner = new STPHeuristicScanner(d);
        try {
            int firstCharPos;
            ITypedRegion partition = TextUtilities.getPartition((IDocument)d, (String)this.fPartitioning, (int)c.offset, (boolean)false);
            if ("__stp_conditional".equals(partition.getType()) && c.offset > 0 && d.getChar(c.offset - 1) == '\\') {
                scanner = new STPHeuristicScanner(d, this.fPartitioning, "__stp_conditional");
                addIndent = 1;
            }
            int line = d.getLineOfOffset(c.offset);
            IRegion reg = d.getLineInformation(line);
            int start = reg.getOffset();
            int lineEnd = start + reg.getLength();
            StringBuilder indent = null;
            STPIndenter indenter = new STPIndenter(d, scanner, this.fProject);
            indent = indenter.computeIndentation(c.offset);
            if (indent == null) {
                indent = new StringBuilder();
            }
            if (addIndent > 0 && indent.length() == 0) {
                indent = indenter.createReusingIndent(indent, addIndent, 0);
            }
            StringBuilder buf = new StringBuilder(c.text + String.valueOf(indent));
            int contentStart = this.findEndOfWhiteSpace(d, c.offset, lineEnd);
            c.length = Math.max(contentStart - c.offset, 0);
            if (this.getBracketCount(d, start, c.offset, true) > 0 && this.fCloseBrace && !this.isClosedBrace(d, c.offset)) {
                c.caretOffset = c.offset + buf.length();
                c.shiftsCaret = false;
                if ((c.offset == 0 || STPAutoEditStrategy.computeAnonymousPosition(d, c.offset - 1, lineEnd) == -1) && lineEnd - contentStart > 0) {
                    c.length = lineEnd - c.offset;
                    buf.append(d.get(contentStart, lineEnd - contentStart).toCharArray());
                }
                buf.append(TextUtilities.getDefaultLineDelimiter((IDocument)d));
                StringBuilder reference = null;
                int nonWS = this.findEndOfWhiteSpace(d, start, lineEnd);
                reference = nonWS < c.offset && d.getChar(nonWS) == '{' ? new StringBuilder(d.get(start, nonWS - start)) : indenter.getReferenceIndentation(c.offset);
                if (reference != null) {
                    buf.append((CharSequence)reference);
                }
                buf.append('}');
                int bound = c.offset > 200 ? c.offset - 200 : -2;
                int bracePos = scanner.findOpeningPeer(c.offset - 1, bound, '{', '}');
                if (bracePos != -1 && (scanner.looksLikeCompositeTypeDefinitionBackward(bracePos, bound) || scanner.previousToken(bracePos - 1, bound) == 12)) {
                    buf.append(';');
                }
            } else if (c.offset > start && contentStart < lineEnd && d.getChar(contentStart) == '}' && (firstCharPos = scanner.findNonWhitespaceBackward(c.offset - 1, start)) != -1 && d.getChar(firstCharPos) == '{') {
                c.caretOffset = c.offset + buf.length();
                c.shiftsCaret = false;
                StringBuilder reference = null;
                int nonWS = this.findEndOfWhiteSpace(d, start, lineEnd);
                reference = nonWS < c.offset && d.getChar(nonWS) == '{' ? new StringBuilder(d.get(start, nonWS - start)) : indenter.getReferenceIndentation(c.offset);
                buf.append(TextUtilities.getDefaultLineDelimiter((IDocument)d));
                if (reference != null) {
                    buf.append((CharSequence)reference);
                }
            }
            c.text = buf.toString();
        }
        catch (BadLocationException e) {
            IDEPlugin.log(e);
        }
    }

    private void smartIndentUponE(IDocument doc, DocumentCommand c) {
        if (c.offset < 4 || doc.getLength() == 0) {
            return;
        }
        try {
            String content = doc.get(c.offset - 3, 3);
            if (content.equals("els")) {
                STPHeuristicScanner scanner = new STPHeuristicScanner(doc);
                int p = c.offset - 3;
                int line = doc.getLineOfOffset(p);
                int lineOffset = doc.getLineOffset(line);
                if (doc.get(lineOffset, p - lineOffset).trim().length() != 0) {
                    return;
                }
                int pos = scanner.findNonWhitespaceBackward(p - 1, -2);
                if (pos == -1) {
                    return;
                }
                int lastLine = doc.getLineOfOffset(pos);
                if (lastLine < line) {
                    STPIndenter indenter = new STPIndenter(doc, scanner, this.fProject);
                    int ref = indenter.findReferencePosition(p, true, STPIndenter.MatchMode.REGULAR);
                    if (ref == -1) {
                        return;
                    }
                    int refLine = doc.getLineOfOffset(ref);
                    String indent = this.getIndentOfLine(doc, refLine);
                    if (indent != null) {
                        c.text = indent + "else";
                        c.length += c.offset - lineOffset;
                        c.offset = lineOffset;
                    }
                }
                return;
            }
            if (content.equals("cas")) {
                STPHeuristicScanner scanner = new STPHeuristicScanner(doc);
                int p = c.offset - 3;
                int line = doc.getLineOfOffset(p);
                int lineOffset = doc.getLineOffset(line);
                if (doc.get(lineOffset, p - lineOffset).trim().length() != 0) {
                    return;
                }
                int pos = scanner.findNonWhitespaceBackward(p - 1, -2);
                if (pos == -1) {
                    return;
                }
                int lastLine = doc.getLineOfOffset(pos);
                if (lastLine < line) {
                    STPIndenter indenter = new STPIndenter(doc, scanner, this.fProject);
                    int ref = indenter.findReferencePosition(p, false, STPIndenter.MatchMode.MATCH_CASE);
                    if (ref == -1) {
                        return;
                    }
                    int refLine = doc.getLineOfOffset(ref);
                    int nextToken = scanner.nextToken(ref, -2);
                    String indent = nextToken == 1013 || nextToken == 1022 ? this.getIndentOfLine(doc, refLine) : indenter.computeIndentation(p).toString();
                    if (indent != null) {
                        c.text = indent + "case";
                        c.length += c.offset - lineOffset;
                        c.offset = lineOffset;
                    }
                }
                return;
            }
        }
        catch (BadLocationException e) {
            IDEPlugin.log(e);
        }
    }

    private static int computeAnonymousPosition(IDocument document, int offset, int max) {
        int openingParen;
        int startScan;
        STPHeuristicScanner scanner = new STPHeuristicScanner(document);
        int pos = offset;
        int length = max;
        int scanTo = scanner.scanForward(pos, length, '}');
        if (scanTo == -1) {
            scanTo = length;
        }
        int closingParen = STPAutoEditStrategy.findClosingParenToLeft(scanner, pos) - 1;
        while ((closingParen = scanner.scanForward(startScan = closingParen + 1, scanTo, ')')) != -1 && (openingParen = scanner.findOpeningPeer(closingParen - 1, '(', ')')) >= 1) {
            if (openingParen <= pos) continue;
        }
        return -1;
    }

    private static int findClosingParenToLeft(STPHeuristicScanner scanner, int position) {
        if (position < 1) {
            return position;
        }
        if (scanner.previousToken(position - 1, -2) == 6) {
            return scanner.getPosition() + 1;
        }
        return position;
    }

    private boolean isClosedBrace(IDocument document, int offset) {
        return STPAutoEditStrategy.getBlockBalance(document, offset) <= 0;
    }

    private void smartIndentOnKeypress(IDocument document, DocumentCommand command) {
        switch (command.text.charAt(0)) {
            case '}': {
                this.smartIndentAfterClosingBracket(document, command);
                break;
            }
            case '{': {
                this.smartIndentAfterOpeningBracket(document, command);
                break;
            }
            case 'e': {
                this.smartIndentUponE(document, command);
                break;
            }
            case '#': {
                this.smartIndentAfterHash(document, command);
                break;
            }
            case '\"': {
                this.smartInsertCloseChar(document, command, '\"');
                break;
            }
            case ')': {
                this.smartInsertCloseChar(document, command, ')');
                break;
            }
            case ']': {
                this.smartInsertCloseChar(document, command, ']');
            }
        }
    }

    private void smartInsertCloseChar(IDocument d, DocumentCommand c, char ch) {
        if (c.offset < 1 || d.getLength() == 0) {
            return;
        }
        try {
            if (d.getChar(c.offset) == ch) {
                int backslashCount = 0;
                int prevOffset = c.offset - 1;
                while (prevOffset > 0 && d.getChar(prevOffset) == '\\') {
                    --prevOffset;
                    ++backslashCount;
                }
                if (!(backslashCount & true)) {
                    c.text = "";
                    ++c.offset;
                }
            }
        }
        catch (BadLocationException e) {
            IDEPlugin.log(e);
        }
    }

    private void smartIndentAfterHash(IDocument doc, DocumentCommand c) {
        try {
            IRegion startLine;
            String indent;
            ITypedRegion partition = TextUtilities.getPartition((IDocument)doc, (String)this.fPartitioning, (int)c.offset, (boolean)false);
            if ("__dftl_partition_content_type".equals(partition.getType()) && (indent = doc.get((startLine = doc.getLineInformationOfOffset(c.offset)).getOffset(), c.offset - startLine.getOffset())).trim().length() == 0) {
                c.offset -= indent.length();
                c.length += indent.length();
            }
        }
        catch (BadLocationException e) {
            IDEPlugin.log(e);
        }
    }

    private void smartIndentAfterOpeningBracket(IDocument d, DocumentCommand c) {
        if (c.offset < 1 || d.getLength() == 0) {
            return;
        }
        int p = c.offset == d.getLength() ? c.offset - 1 : c.offset;
        try {
            int line;
            int lineOffset;
            STPHeuristicScanner scanner = new STPHeuristicScanner(d);
            ITypedRegion partition = TextUtilities.getPartition((IDocument)d, (String)this.fPartitioning, (int)p, (boolean)false);
            if ("__stp_conditional".equals(partition.getType())) {
                scanner = new STPHeuristicScanner(d, this.fPartitioning, "__stp_conditional");
            }
            if (!d.get(lineOffset = d.getLineOffset(line = d.getLineOfOffset(c.offset)), c.offset - lineOffset).trim().isEmpty()) {
                return;
            }
            int pos = scanner.findNonWhitespaceBackward(p, -2);
            if (pos == -1) {
                return;
            }
            int lastLine = d.getLineOfOffset(pos);
            if (lastLine < line) {
                STPIndenter indenter = new STPIndenter(d, scanner, this.fProject);
                StringBuilder indent = indenter.computeIndentation(p, true);
                String toDelete = d.get(lineOffset, c.offset - lineOffset);
                if (indent != null && !indent.toString().equals(toDelete)) {
                    c.text = indent.append(c.text).toString();
                    c.length += c.offset - lineOffset;
                    c.offset = lineOffset;
                }
            }
        }
        catch (BadLocationException e) {
            IDEPlugin.log(e);
        }
    }

    private boolean isLineDelimiter(IDocument document, String text) {
        String[] delimiters = document.getLegalLineDelimiters();
        if (delimiters != null) {
            return TextUtilities.equals((String[])delimiters, (String)text) > -1;
        }
        return false;
    }

    private int getBracketCount(IDocument d, int start, int end, boolean ignoreCloseBrackets) throws BadLocationException {
        int bracketcount = 0;
        block8: while (start < end) {
            char curr = d.getChar(start);
            ++start;
            switch (curr) {
                case '#': {
                    if (start >= end) break;
                    start = end;
                    break;
                }
                case '/': {
                    if (start >= end) break;
                    char next = d.getChar(start);
                    if (next == '*') {
                        start = this.getCommentEnd(d, start + 1, end);
                        break;
                    }
                    if (next != '/') break;
                    start = end;
                    break;
                }
                case '*': {
                    char next;
                    if (start >= end || (next = d.getChar(start)) != '/') continue block8;
                    bracketcount = 0;
                    ++start;
                    break;
                }
                case '{': {
                    ++bracketcount;
                    ignoreCloseBrackets = false;
                    break;
                }
                case '}': {
                    if (ignoreCloseBrackets) break;
                    --bracketcount;
                    break;
                }
                case '\"': 
                case '\'': {
                    start = this.getStringEnd(d, start, end, curr);
                }
            }
        }
        return bracketcount;
    }

    private int getCommentEnd(IDocument d, int pos, int end) throws BadLocationException {
        while (pos < end) {
            char curr = d.getChar(pos);
            if (curr != '*' || ++pos >= end || d.getChar(pos) != '/') continue;
            return pos + 1;
        }
        return end;
    }

    private String getIndentOfLine(IDocument d, int line) throws BadLocationException {
        if (line > -1) {
            int start = d.getLineOffset(line);
            int end = start + d.getLineLength(line) - 1;
            int whiteend = this.findEndOfWhiteSpace(d, start, end);
            return d.get(start, whiteend - start);
        }
        return "";
    }

    private int getStringEnd(IDocument d, int pos, int end, char ch) throws BadLocationException {
        while (pos < end) {
            char curr = d.getChar(pos);
            ++pos;
            if (curr == '\\') {
                ++pos;
                continue;
            }
            if (curr != ch) continue;
            return pos;
        }
        return end;
    }

    private void smartIndentAfterClosingBracket(IDocument d, DocumentCommand c) {
        if (c.offset == -1 || d.getLength() == 0) {
            return;
        }
        try {
            int reference;
            int indLine;
            int p = c.offset == d.getLength() ? c.offset - 1 : c.offset;
            int line = d.getLineOfOffset(p);
            int start = d.getLineOffset(line);
            int whiteend = this.findEndOfWhiteSpace(d, start, c.offset);
            STPHeuristicScanner scanner = new STPHeuristicScanner(d);
            ITypedRegion partition = TextUtilities.getPartition((IDocument)d, (String)this.fPartitioning, (int)p, (boolean)false);
            if ("__stp_conditional".equals(partition.getType())) {
                scanner = new STPHeuristicScanner(d, this.fPartitioning, "__stp_conditional");
            }
            STPIndenter indenter = new STPIndenter(d, scanner, this.fProject);
            if (whiteend == c.offset && (indLine = d.getLineOfOffset(reference = indenter.findReferencePosition(c.offset, false, STPIndenter.MatchMode.MATCH_BRACE))) != -1 && indLine != line) {
                StringBuilder replaceText = new StringBuilder(this.getIndentOfLine(d, indLine));
                replaceText.append(d.get(whiteend, c.offset - whiteend));
                replaceText.append(c.text);
                c.length += c.offset - start;
                c.offset = start;
                c.text = replaceText.toString();
            }
        }
        catch (BadLocationException e) {
            IDEPlugin.log(e);
        }
    }

    private static void installPartitioner(Document document) {
        String[] types = new String[]{"__dftl_partition_content_type", "__stp_comment", "__stp_conditional"};
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new STPPartitionScanner(), types);
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner("__stp_partitioning", (IDocumentPartitioner)partitioner);
    }

    private static void removePartitioner(Document document) {
        document.setDocumentPartitioner("__stp_partitioning", null);
    }

    private void smartPaste(IDocument document, DocumentCommand command) {
        int newOffset = command.offset;
        int newLength = command.length;
        String newText = command.text;
        try {
            STPHeuristicScanner scanner = new STPHeuristicScanner(document);
            STPIndenter indenter = new STPIndenter(document, scanner, this.fProject);
            int offset = newOffset;
            int refOffset = indenter.findReferencePosition(offset);
            if (refOffset == -1) {
                return;
            }
            int peerOffset = this.getPeerPosition(document, command);
            if ((peerOffset = indenter.findReferencePosition(peerOffset)) == -1) {
                return;
            }
            refOffset = Math.min(refOffset, peerOffset);
            int firstLine = 1;
            IRegion line = document.getLineInformationOfOffset(offset);
            String notSelected = document.get(line.getOffset(), offset - line.getOffset());
            if (notSelected.trim().length() == 0) {
                newLength += notSelected.length();
                newOffset = line.getOffset();
                firstLine = 0;
            }
            int firstPrefixLine = Math.max(document.getLineOfOffset(refOffset) - 100, 0);
            int prefixOffset = document.getLineInformation(firstPrefixLine).getOffset();
            String prefix = document.get(prefixOffset, newOffset - prefixOffset);
            Document temp = new Document(prefix + newText);
            DocumentRewriteSession session = temp.startRewriteSession(DocumentRewriteSessionType.STRICTLY_SEQUENTIAL);
            scanner = new STPHeuristicScanner((IDocument)temp);
            indenter = new STPIndenter((IDocument)temp, scanner, this.fProject);
            STPAutoEditStrategy.installPartitioner(temp);
            boolean isIndentDetected = false;
            StringBuilder addition = new StringBuilder();
            int insertLength = 0;
            int first = document.computeNumberOfLines(prefix) + firstLine;
            int lines = temp.getNumberOfLines();
            boolean changed = false;
            boolean indentInsideLineComments = true;
            int l = first;
            while (l < lines) {
                IRegion r = temp.getLineInformation(l);
                int lineOffset = r.getOffset();
                int lineLength = r.getLength();
                if (lineLength != 0) {
                    if (!isIndentDetected) {
                        String current = IndentUtil.getCurrentIndent((IDocument)temp, l, indentInsideLineComments);
                        StringBuilder correct = new StringBuilder(IndentUtil.computeIndent((IDocument)temp, l, indenter, scanner));
                        insertLength = this.subtractIndent(correct, current, addition);
                        if (temp.get(lineOffset, lineLength).trim().length() != 0) {
                            isIndentDetected = true;
                            if (insertLength == 0) {
                                if (firstLine == 0) {
                                    command.offset = newOffset;
                                    command.length = newLength;
                                    if (changed) break;
                                }
                                return;
                            }
                            STPAutoEditStrategy.removePartitioner(temp);
                        } else {
                            boolean bl = changed = insertLength != 0;
                        }
                    }
                    if (insertLength > 0) {
                        STPAutoEditStrategy.addIndent(temp, l, addition, indentInsideLineComments);
                    } else if (insertLength < 0) {
                        this.cutIndent(temp, l, -insertLength, indentInsideLineComments);
                    }
                }
                ++l;
            }
            temp.stopRewriteSession(session);
            newText = temp.get(prefix.length(), temp.getLength() - prefix.length());
            command.offset = newOffset;
            command.length = newLength;
            command.text = newText;
        }
        catch (BadLocationException e) {
            IDEPlugin.log(e);
        }
    }

    private int subtractIndent(CharSequence correct, CharSequence current, StringBuilder difference) {
        int c2;
        int c1 = this.computeVisualLength(correct);
        int diff = c1 - (c2 = this.computeVisualLength(current));
        if (diff <= 0) {
            return diff;
        }
        difference.setLength(0);
        int len = 0;
        int i = 0;
        while (len < diff) {
            char c = correct.charAt(i++);
            difference.append(c);
            len += this.computeVisualLength(c);
        }
        return diff;
    }

    private static void addIndent(Document document, int line, CharSequence indent, boolean indentInsideLineComments) throws BadLocationException {
        IRegion region = document.getLineInformation(line);
        int insert = region.getOffset();
        int endOffset = region.getOffset() + region.getLength();
        if (indentInsideLineComments) {
            while (insert < endOffset - 2 && document.get(insert, 2).equals(LINE_COMMENT)) {
                insert += 2;
            }
        }
        document.replace(insert, 0, indent.toString());
    }

    private void cutIndent(Document document, int line, int toDelete, boolean indentInsideLineComments) throws BadLocationException {
        IRegion region = document.getLineInformation(line);
        int from = region.getOffset();
        int endOffset = region.getOffset() + region.getLength();
        if (indentInsideLineComments) {
            while (from < endOffset - 2 && document.get(from, 2).equals(LINE_COMMENT)) {
                from += 2;
            }
        }
        int to = from;
        while (toDelete > 0 && to < endOffset) {
            char ch = document.getChar(to);
            if (!Character.isWhitespace(ch) || (toDelete -= this.computeVisualLength(ch)) < 0) break;
            ++to;
        }
        document.replace(from, to - from, null);
    }

    private int computeVisualLength(CharSequence seq) {
        int size = 0;
        int tablen = this.getVisualTabLengthPreference();
        int i = 0;
        while (i < seq.length()) {
            char ch = seq.charAt(i);
            if (ch == '\t') {
                if (tablen != 0) {
                    size += tablen - size % tablen;
                }
            } else {
                ++size;
            }
            ++i;
        }
        return size;
    }

    private int computeVisualLength(char ch) {
        if (ch == '\t') {
            return this.getVisualTabLengthPreference();
        }
        return 1;
    }

    private int getVisualTabLengthPreference() {
        return CodeFormatterUtil.getTabWidth();
    }

    private int getPeerPosition(IDocument document, DocumentCommand command) {
        if (document.getLength() == 0) {
            return 0;
        }
        Document pasted = new Document(command.text);
        STPAutoEditStrategy.installPartitioner(pasted);
        int firstPeer = command.offset;
        STPHeuristicScanner pScanner = new STPHeuristicScanner((IDocument)pasted);
        STPHeuristicScanner dScanner = new STPHeuristicScanner(document);
        int afterToken = dScanner.nextToken(command.offset + command.length, -2);
        try {
            switch (afterToken) {
                case 2: {
                    pasted.replace(pasted.getLength(), 0, "}");
                    break;
                }
                case 6: {
                    pasted.replace(pasted.getLength(), 0, ")");
                    break;
                }
                case 4: {
                    pasted.replace(pasted.getLength(), 0, "]");
                }
            }
        }
        catch (BadLocationException e) {
            Assert.isTrue((boolean)false);
        }
        int pPos = 0;
        int dPos = Math.max(0, command.offset - 1);
        block16: while (true) {
            int token = pScanner.nextToken(pPos, -2);
            pPos = pScanner.getPosition();
            switch (token) {
                case 1: 
                case 3: 
                case 5: {
                    if ((pPos = STPAutoEditStrategy.skipScope(pScanner, pPos, token)) != -1) continue block16;
                    return firstPeer;
                }
                case 2: {
                    int peer = dScanner.findOpeningPeer(dPos, '{', '}');
                    dPos = peer - 1;
                    if (peer == -1) {
                        return firstPeer;
                    }
                    firstPeer = peer;
                    continue block16;
                }
                case 4: {
                    int peer = dScanner.findOpeningPeer(dPos, '[', ']');
                    dPos = peer - 1;
                    if (peer == -1) {
                        return firstPeer;
                    }
                    firstPeer = peer;
                    continue block16;
                }
                case 6: {
                    int peer = dScanner.findOpeningPeer(dPos, '(', ')');
                    dPos = peer - 1;
                    if (peer == -1) {
                        return firstPeer;
                    }
                    firstPeer = peer;
                    continue block16;
                }
                case 1013: 
                case 1022: {
                    STPIndenter indenter = new STPIndenter(document, dScanner, this.fProject);
                    int peer = indenter.findReferencePosition(dPos, false, STPIndenter.MatchMode.MATCH_CASE);
                    if (peer == -1) {
                        return firstPeer;
                    }
                    firstPeer = peer;
                    continue block16;
                }
                case 1023: 
                case 1024: 
                case 1025: {
                    STPIndenter indenter = new STPIndenter(document, dScanner, this.fProject);
                    int peer = indenter.findReferencePosition(dPos, false, STPIndenter.MatchMode.MATCH_ACCESS_SPECIFIER);
                    if (peer == -1) {
                        return firstPeer;
                    }
                    firstPeer = peer;
                    continue block16;
                }
                case -1: {
                    return firstPeer;
                }
            }
        }
    }

    private static int skipScope(STPHeuristicScanner scanner, int pos, int token) {
        int closeToken;
        int openToken = token;
        switch (token) {
            case 5: {
                closeToken = 6;
                break;
            }
            case 3: {
                closeToken = 4;
                break;
            }
            case 1: {
                closeToken = 2;
                break;
            }
            default: {
                Assert.isTrue((boolean)false);
                return -1;
            }
        }
        int depth = 1;
        int p = pos;
        while (true) {
            int tok = scanner.nextToken(p, -2);
            p = scanner.getPosition();
            if (tok == openToken) {
                ++depth;
                continue;
            }
            if (tok == closeToken) {
                if (--depth != 0) continue;
                return p + 1;
            }
            if (tok == -1) break;
        }
        return -1;
    }
}

